/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgCommit;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgHistoryUtil {
    private static final Logger LOG = Logger.getInstance(HgHistoryUtil.class);

    private HgHistoryUtil() {
    }

    @NotNull
    public static List<VcsCommitMetadata> loadMetadata(@NotNull Project project, final @NotNull VirtualFile root, int limit, @NotNull List<String> parameters) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(2);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<VcsCommitMetadata> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtil.toStringArray(templateList);
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, parameters, HgChangesetUtil.makeTemplate(templates));
        HgBaseLogParser<VcsCommitMetadata> baseParser = new HgBaseLogParser<VcsCommitMetadata>(){

            @Override
            protected VcsCommitMetadata convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changeset == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (parents == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (revisionDate == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (author == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (email == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (attributes == null) {
                    1.$$$reportNull$$$0(6);
                }
                String message = 1.parseAdditionalStringAttribute(attributes, 5);
                String subject = 1.extractSubject(message);
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                return factory.createCommitMetadata(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, message, author, email, revisionDate.getTime());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rev";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeset";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "revisionDate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "author";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "email";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$1";
                objectArray[2] = "convertDetails";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        List<VcsCommitMetadata> list = HgHistoryUtil.getCommitRecords(project, result, baseParser);
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<HgCommit> history(@NotNull Project project, @NotNull VirtualFile root, int limit, @NotNull List<String> hashParameters, boolean silent) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(5);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(6);
        }
        if (hashParameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(7);
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        ArrayList result = ContainerUtil.newArrayList();
        VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<HgCommit> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        HgFileRevisionLogParser parser = new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), hgvcs.getVersion());
        try {
            HgHistoryUtil.readLog(project, root, hgvcs.getVersion(), limit, hashParameters, HgChangesetUtil.makeTemplate(templates), (Consumer<StringBuilder>)((Consumer)stringBuilder -> {
                HgFileRevision revision;
                if (project == null) {
                    HgHistoryUtil.$$$reportNull$$$0(71);
                }
                if (root == null) {
                    HgHistoryUtil.$$$reportNull$$$0(72);
                }
                if ((revision = (HgFileRevision)parser.convert(stringBuilder.toString())) != null) {
                    result.add(HgHistoryUtil.createDetails(project, root, factory, revision));
                }
            }));
        }
        catch (VcsException e) {
            if (!silent) {
                VcsNotifier.getInstance((Project)project).notifyError(HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), e.getMessage());
            }
            throw e;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> createFullCommitsFromResult(@NotNull Project project, @NotNull VirtualFile root, @Nullable HgCommandResult result, @NotNull HgVersion version, boolean silent) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(10);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(11);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(12);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<HgFileRevision> hgRevisions = HgHistoryUtil.getCommitRecords(project, result, new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), version), silent);
        ArrayList<HgCommit> vcsFullCommitDetailsList = new ArrayList<HgCommit>();
        for (HgFileRevision revision : hgRevisions) {
            vcsFullCommitDetailsList.add(HgHistoryUtil.createDetails(project, root, factory, revision));
        }
        ArrayList<HgCommit> arrayList = vcsFullCommitDetailsList;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static HgCommit createDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsLogObjectsFactory factory, @NotNull HgFileRevision revision) {
        void var9_22;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(15);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(16);
        }
        if (factory == null) {
            HgHistoryUtil.$$$reportNull$$$0(17);
        }
        if (revision == null) {
            HgHistoryUtil.$$$reportNull$$$0(18);
        }
        HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
        List<HgRevisionNumber> parents = vcsRevisionNumber.getParents();
        SmartList parentsHashes = new SmartList();
        for (HgRevisionNumber hgRevisionNumber : parents) {
            parentsHashes.add(factory.createHash(hgRevisionNumber.getChangeset()));
        }
        ArrayList<VcsFileStatusInfo> firstParentChanges = new ArrayList<VcsFileStatusInfo>();
        for (String string : revision.getModifiedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.MODIFICATION, string, null));
        }
        for (String string : revision.getAddedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.NEW, string, null));
        }
        for (String string : revision.getDeletedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.DELETED, string, null));
        }
        for (Map.Entry<String, String> entry : revision.getMovedFiles().entrySet()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.MOVED, entry.getKey(), entry.getValue()));
        }
        ArrayList arrayList = ContainerUtil.newArrayList();
        arrayList.add(firstParentChanges);
        boolean bl = true;
        while (var9_22 < parents.size()) {
            HgRevisionNumber parent = parents.get((int)var9_22);
            HgStatusCommand status = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(true).baseRevision(parent).targetRevision(vcsRevisionNumber).build(project);
            Set<HgChange> hgChanges = status.executeInCurrentThread(root);
            arrayList.add(HgHistoryUtil.convertHgChanges(hgChanges));
            ++var9_22;
        }
        HgCommit hgCommit = new HgCommit(project, root, factory.createHash(vcsRevisionNumber.getChangeset()), (List<Hash>)parentsHashes, vcsRevisionNumber, factory.createUser(vcsRevisionNumber.getName(), vcsRevisionNumber.getEmail()), revision.getRevisionDate().getTime(), arrayList);
        if (hgCommit == null) {
            HgHistoryUtil.$$$reportNull$$$0(19);
        }
        return hgCommit;
    }

    @NotNull
    private static List<VcsFileStatusInfo> convertHgChanges(@NotNull Set<HgChange> changes) {
        if (changes == null) {
            HgHistoryUtil.$$$reportNull$$$0(20);
        }
        HashSet deleted = ContainerUtil.newHashSet();
        HashSet copied = ContainerUtil.newHashSet();
        for (HgChange change : changes) {
            Change.Type type = HgHistoryUtil.getType(change.getStatus());
            if (Change.Type.DELETED.equals((Object)type)) {
                deleted.add(change.beforeFile().getRelativePath());
                continue;
            }
            if (!Change.Type.MOVED.equals((Object)type)) continue;
            copied.add(change.beforeFile().getRelativePath());
        }
        ArrayList result = ContainerUtil.newArrayList();
        block5: for (HgChange change : changes) {
            String secondPath;
            String firstPath;
            Change.Type type = HgHistoryUtil.getType(change.getStatus());
            LOG.assertTrue(type != null, (Object)("Unsupported status for change " + change));
            switch (type) {
                case DELETED: {
                    firstPath = change.beforeFile().getRelativePath();
                    secondPath = null;
                    if (!copied.contains(firstPath)) break;
                    continue block5;
                }
                case MOVED: {
                    firstPath = change.beforeFile().getRelativePath();
                    secondPath = change.afterFile().getRelativePath();
                    if (deleted.contains(firstPath)) break;
                    type = Change.Type.NEW;
                    firstPath = change.afterFile().getRelativePath();
                    secondPath = null;
                    break;
                }
                default: {
                    firstPath = change.afterFile().getRelativePath();
                    secondPath = null;
                }
            }
            result.add(new VcsFileStatusInfo(type, (String)ObjectUtils.notNull((Object)firstPath), secondPath));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    private static Change.Type getType(@NotNull HgFileStatusEnum status) {
        if (status == null) {
            HgHistoryUtil.$$$reportNull$$$0(22);
        }
        switch (status) {
            case ADDED: {
                return Change.Type.NEW;
            }
            case MODIFIED: {
                return Change.Type.MODIFICATION;
            }
            case DELETED: {
                return Change.Type.DELETED;
            }
            case COPY: {
                return Change.Type.MOVED;
            }
            case UNVERSIONED: 
            case MISSING: 
            case UNMODIFIED: 
            case IGNORED: {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static HgCommandResult getLogResult(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgVersion version, int limit, @NotNull List<String> parameters, @NotNull String template) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(23);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(24);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(25);
        }
        if (parameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(26);
        }
        if (template == null) {
            HgHistoryUtil.$$$reportNull$$$0(27);
        }
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        ArrayList<String> args = new ArrayList<String>(parameters);
        if (!version.isParentRevisionTemplateSupported()) {
            args.add("--debug");
        }
        return hgLogCommand.execute(root, template, limit, HgHistoryUtil.getOriginalHgFile(project, root), args);
    }

    public static void readLog(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgVersion version, int limit, @NotNull List<String> hashes, @NotNull String template, @NotNull Consumer<StringBuilder> consumer) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(28);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(29);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(30);
        }
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(31);
        }
        if (template == null) {
            HgHistoryUtil.$$$reportNull$$$0(32);
        }
        if (consumer == null) {
            HgHistoryUtil.$$$reportNull$$$0(33);
        }
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        ThrowableConsumer logRunner = hashesChunk -> {
            if (consumer == null) {
                HgHistoryUtil.$$$reportNull$$$0(66);
            }
            if (version == null) {
                HgHistoryUtil.$$$reportNull$$$0(67);
            }
            if (root == null) {
                HgHistoryUtil.$$$reportNull$$$0(68);
            }
            if (template == null) {
                HgHistoryUtil.$$$reportNull$$$0(69);
            }
            if (project == null) {
                HgHistoryUtil.$$$reportNull$$$0(70);
            }
            HgLogOutputSplitter splitter = new HgLogOutputSplitter(consumer);
            ArrayList<String> args = new ArrayList<String>((Collection<String>)hashesChunk);
            if (!version.isParentRevisionTemplateSupported()) {
                args.add("--debug");
            }
            hgLogCommand.execute(root, template, limit, HgHistoryUtil.getOriginalHgFile(project, root), args, splitter);
            splitter.finish();
        };
        if (hashes.isEmpty()) {
            logRunner.consume(hashes);
        } else {
            VcsFileUtil.foreachChunk(hashes, (int)2, (ThrowableConsumer)logRunner);
        }
    }

    public static HgFile getOriginalHgFile(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(34);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(35);
        }
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        if (project.isDisposed()) {
            return hgFile;
        }
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)project));
        return new HgFile(hgFile.getRepo(), originalFileName);
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecords(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<? super String, ? extends CommitInfo> converter) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(36);
        }
        if (converter == null) {
            HgHistoryUtil.$$$reportNull$$$0(37);
        }
        List<? extends CommitInfo> list = HgHistoryUtil.getCommitRecords(project, result, converter, false);
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecords(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<? super String, ? extends CommitInfo> converter, boolean silent) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(39);
        }
        if (converter == null) {
            HgHistoryUtil.$$$reportNull$$$0(40);
        }
        LinkedList revisions = new LinkedList();
        if (result == null) {
            LinkedList linkedList = revisions;
            if (linkedList == null) {
                HgHistoryUtil.$$$reportNull$$$0(41);
            }
            return linkedList;
        }
        List<String> errors = result.getErrorLines();
        if (!errors.isEmpty()) {
            if (result.getExitValue() != 0) {
                if (silent) {
                    LOG.debug(errors.toString());
                } else {
                    VcsNotifier.getInstance((Project)project).notifyError(HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), errors.toString());
                }
                List list = Collections.emptyList();
                if (list == null) {
                    HgHistoryUtil.$$$reportNull$$$0(42);
                }
                return list;
            }
            LOG.warn(errors.toString());
        }
        String output = result.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        List list = ContainerUtil.mapNotNull((Collection)changeSets, converter);
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> readCommitMetadata(@NotNull Project project, final @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(44);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(45);
        }
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(46);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(47);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtil.toStringArray(templateList);
        List list = VcsFileUtil.foreachChunk(HgHistoryUtil.prepareHashes(hashes), (int)2, strings -> {
            if (project == null) {
                HgHistoryUtil.$$$reportNull$$$0(64);
            }
            if (root == null) {
                HgHistoryUtil.$$$reportNull$$$0(65);
            }
            HgCommandResult logResult = HgHistoryUtil.getLogResult(project, root, version, -1, strings, HgChangesetUtil.makeTemplate(templates));
            return HgHistoryUtil.getCommitRecords(project, logResult, new HgBaseLogParser<VcsCommitMetadata>(){

                @Override
                protected VcsCommitMetadata convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                    if (rev == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (changeset == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (parents == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (revisionDate == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (author == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    if (email == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    if (attributes == null) {
                        2.$$$reportNull$$$0(6);
                    }
                    String message = 2.parseAdditionalStringAttribute(attributes, 5);
                    String subject = 2.extractSubject(message);
                    SmartList parentsHash = new SmartList();
                    for (HgRevisionNumber parent : parents) {
                        parentsHash.add(factory.createHash(parent.getChangeset()));
                    }
                    return factory.createCommitMetadata(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, message, author, email, revisionDate.getTime());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "rev";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "changeset";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "parents";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "revisionDate";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[0] = "author";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[0] = "email";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[0] = "attributes";
                            break;
                        }
                    }
                    objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$2";
                    objectArray[2] = "convertDetails";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public static List<TimedVcsCommit> readAllHashes(@NotNull Project project, @NotNull VirtualFile root, final @NotNull Consumer<? super VcsUser> userRegistry, @NotNull List<String> params) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(49);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(50);
        }
        if (userRegistry == null) {
            HgHistoryUtil.$$$reportNull$$$0(51);
        }
        if (params == null) {
            HgHistoryUtil.$$$reportNull$$$0(52);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(53);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = ArrayUtil.toStringArray(HgBaseLogParser.constructDefaultTemplate(version));
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, -1, params, HgChangesetUtil.makeTemplate(templates));
        List<TimedVcsCommit> list = HgHistoryUtil.getCommitRecords(project, result, new HgBaseLogParser<TimedVcsCommit>(){

            @Override
            protected TimedVcsCommit convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (changeset == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (parents == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (revisionDate == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (author == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (email == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (attributes == null) {
                    3.$$$reportNull$$$0(6);
                }
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                userRegistry.consume((Object)factory.createUser(author, email));
                return factory.createTimedCommit(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rev";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeset";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "revisionDate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "author";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "email";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$3";
                objectArray[2] = "convertDetails";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(54);
        }
        return list;
    }

    @Nullable
    static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(Project project) {
        if (!project.isDisposed()) {
            return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        }
        return null;
    }

    @NotNull
    public static Change createChange(@NotNull Project project, @NotNull VirtualFile root, @Nullable String fileBefore, @Nullable HgRevisionNumber revisionBefore, @Nullable String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        ContentRevision afterRevision;
        HgContentRevision beforeRevision;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(55);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(56);
        }
        HgContentRevision hgContentRevision = beforeRevision = fileBefore == null || aStatus == FileStatus.ADDED ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        if (aStatus == FileStatus.DELETED) {
            afterRevision = null;
        } else if (revisionAfter == null && fileBefore != null) {
            afterRevision = CurrentContentRevision.create((FilePath)new HgFile(root, new File(root.getPath(), fileAfter != null ? fileAfter : fileBefore)).toFilePath());
        } else {
            assert (revisionAfter != null);
            afterRevision = fileAfter == null ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        }
        Change change = new Change(beforeRevision, afterRevision, aStatus);
        if (change == null) {
            HgHistoryUtil.$$$reportNull$$$0(57);
        }
        return change;
    }

    @NotNull
    public static List<String> prepareHashes(@NotNull List<String> hashes) {
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(58);
        }
        ArrayList<String> hashArgs = new ArrayList<String>();
        for (String hash : hashes) {
            hashArgs.add("-r");
            hashArgs.add(hash);
        }
        ArrayList<String> arrayList = hashArgs;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(59);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getDescendingHeadsOfBranches(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(60);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(61);
        }
        if (hash == null) {
            HgHistoryUtil.$$$reportNull$$$0(62);
        }
        HashSet<String> branchHeads = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-r");
        params.add("descendants(" + hash.asString() + ") and head()");
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        String template = HgChangesetUtil.makeTemplate("{branch}", "{bookmarks}");
        HgCommandResult logResult = hgLogCommand.execute(root, template, -1, null, params);
        if (logResult == null || logResult.getExitValue() != 0) {
            throw new VcsException("Couldn't get commit details: log command execution error.");
        }
        String output = logResult.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        for (String line : changeSets) {
            List attributes = StringUtil.split((String)line, (String)"\u0017");
            branchHeads.addAll(attributes);
        }
        HashSet<String> hashSet = branchHeads;
        if (hashSet == null) {
            HgHistoryUtil.$$$reportNull$$$0(63);
        }
        return hashSet;
    }

    public static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 57: 
            case 59: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 57: 
            case 59: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 16: 
            case 24: 
            case 29: 
            case 35: 
            case 45: 
            case 50: 
            case 56: 
            case 61: 
            case 65: 
            case 68: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 57: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/log/HgHistoryUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashParameters";
                break;
            }
            case 12: 
            case 25: 
            case 30: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 27: 
            case 32: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 31: 
            case 46: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 33: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/log/HgHistoryUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMetadata";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "history";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFullCommitsFromResult";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetails";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertHgChanges";
                break;
            }
            case 38: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitRecords";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "readCommitMetadata";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "readAllHashes";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHashes";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendingHeadsOfBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadMetadata";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 57: 
            case 59: 
            case 63: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "history";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFullCommitsFromResult";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDetails";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertHgChanges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLogResult";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readLog";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalHgFile";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCommitRecords";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "readCommitMetadata";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "readAllHashes";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "prepareHashes";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getDescendingHeadsOfBranches";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readCommitMetadata$2";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readLog$1";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$history$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 57: 
            case 59: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HgLogOutputSplitter
    extends HgLineProcessListener {
        @NotNull
        private final StringBuilder myOutput;
        private final Consumer<StringBuilder> myConsumer;

        HgLogOutputSplitter(Consumer<StringBuilder> consumer) {
            this.myConsumer = consumer;
            this.myOutput = new StringBuilder();
        }

        @Override
        protected void processOutputLine(@NotNull String line) {
            int separatorIndex;
            if (line == null) {
                HgLogOutputSplitter.$$$reportNull$$$0(0);
            }
            while ((separatorIndex = line.indexOf("\u0003")) >= 0) {
                this.myOutput.append(line, 0, separatorIndex);
                this.myConsumer.consume((Object)this.myOutput);
                this.myOutput.setLength(0);
                line = line.substring(separatorIndex + 1);
            }
            this.myOutput.append(line);
        }

        @Override
        public void finish() throws VcsException {
            super.finish();
            if (this.myOutput.length() != 0) {
                this.myConsumer.consume((Object)this.myOutput);
                this.myOutput.setLength(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/zmlx/hg4idea/log/HgHistoryUtil$HgLogOutputSplitter", "processOutputLine"));
        }
    }
}

