/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.ide.OpenFileHttpServiceKt;
import org.jetbrains.ide.OpenFileRequest;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\"\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"LINE_AND_COLUMN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "NOT_FOUND", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "request", "Lorg/jetbrains/ide/OpenFileRequest;", "openAbsolutePath", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "Ljava/nio/file/Path;", "openRelativePath", "", "path", "", "intellij.platform.builtInServer.impl"})
public final class OpenFileHttpServiceKt {
    private static final RuntimeException NOT_FOUND = Promises.createError$default((String)"not found", (boolean)false, (int)2, null);
    private static final Pattern LINE_AND_COLUMN = Pattern.compile("^(.*?)(?::(\\d+))?(?::(\\d+))?$");

    private static final void navigate(Project project, VirtualFile file2, OpenFileRequest request) {
        Project project2;
        Project project3 = project;
        if (project3 == null) {
            project3 = project2 = RestService.getLastFocusedOrOpenedProject();
        }
        if (project3 == null) {
            ProjectManager projectManager2 = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager2, (String)"ProjectManager.getInstance()");
            Project project4 = projectManager2.getDefaultProject();
            project2 = project4;
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"ProjectManager.getInstance().defaultProject");
        }
        Project effectiveProject = project2;
        new OpenFileDescriptor(effectiveProject, file2, Math.max(request.getLine() - 1, 0), Math.max(request.getColumn() - 1, 0)).navigate(true);
        if (request.getFocused()) {
            com.intellij.ide.impl.ProjectUtil.focusProjectWindow(project, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean openRelativePath(String path, OpenFileRequest request) {
        boolean bl;
        VirtualFile virtualFile = null;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ProjectManager projectManager2 = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager2, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager2.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] projects = projectArray;
        int n = projects.length;
        for (int i = 0; i < n; ++i) {
            Project openedProject;
            Project project = openedProject = projects[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"openedProject");
            if (project.getBaseDir() != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2;
                virtualFile = it.findFileByRelativePath(path);
            }
            if (virtualFile == null) {
                virtualFile = WebServerPathToFileManager.findVirtualFile$default(WebServerPathToFileManager.Companion.getInstance(openedProject), path, false, null, 6, null);
            }
            if (virtualFile == null) continue;
            project.element = openedProject;
            break;
        }
        if (virtualFile == null) {
            block1: for (Project openedProject : projects) {
                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)openedProject);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(openedProject)");
                VcsRoot[] vcsRootArray = projectLevelVcsManager.getAllVcsRoots();
                int n2 = vcsRootArray.length;
                for (int i = 0; i < n2; ++i) {
                    VcsRoot vcsRoot;
                    VcsRoot vcsRoot2 = vcsRoot = vcsRootArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsRoot2, (String)"vcsRoot");
                    VirtualFile root = vcsRoot2.getPath();
                    if (root == null || (virtualFile = root.findFileByRelativePath(path)) == null) continue;
                    project.element = openedProject;
                    continue block1;
                }
            }
        }
        VirtualFile virtualFile3 = virtualFile;
        if (virtualFile3 != null) {
            void project;
            VirtualFile virtualFile4;
            VirtualFile it = virtualFile4 = virtualFile3;
            Project project2 = (Project)project.element;
            if (project2 == null) {
                Intrinsics.throwNpe();
            }
            AppUIUtil.invokeLaterIfProjectAlive(project2, new Runnable(it, (Ref.ObjectRef)project, request){
                final /* synthetic */ VirtualFile $it;
                final /* synthetic */ Ref.ObjectRef $project$inlined;
                final /* synthetic */ OpenFileRequest $request$inlined;
                {
                    this.$it = virtualFile;
                    this.$project$inlined = objectRef;
                    this.$request$inlined = openFileRequest;
                }

                public final void run() {
                    OpenFileHttpServiceKt.access$navigate((Project)this.$project$inlined.element, this.$it, this.$request$inlined);
                }
            });
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Promise<Void> openAbsolutePath(Path file2, OpenFileRequest request) {
        AsyncPromise promise2 = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(new Runnable(promise2, file2, request){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Path $file;
            final /* synthetic */ OpenFileRequest $request;

            public final void run() {
                AsyncPromise $receiver$iv = this.$promise;
                try {
                    Boolean bl;
                    VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                        final /* synthetic */ openAbsolutePath.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final T compute() {
                            return (T)LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)this.this$0.$file));
                        }
                    });
                    if (virtualFile == null) {
                        bl = this.$promise.setError((Throwable)OpenFileHttpServiceKt.access$getNOT_FOUND$p());
                    } else {
                        OpenFileHttpServiceKt.access$navigate(ProjectUtil.guessProjectForContentFile$default((VirtualFile)virtualFile, null, (int)2, null), virtualFile, this.$request);
                        this.$promise.setResult(null);
                        bl = Unit.INSTANCE;
                    }
                    Boolean bl2 = bl;
                }
                catch (Throwable e$iv) {
                    $receiver$iv.setError(e$iv);
                    Object var5_5 = null;
                }
            }
            {
                this.$promise = asyncPromise;
                this.$file = path;
                this.$request = openFileRequest;
            }
        });
        return (Promise)promise2;
    }

    public static final /* synthetic */ Pattern access$getLINE_AND_COLUMN$p() {
        return LINE_AND_COLUMN;
    }

    @NotNull
    public static final /* synthetic */ RuntimeException access$getNOT_FOUND$p() {
        return NOT_FOUND;
    }

    @NotNull
    public static final /* synthetic */ Promise access$openAbsolutePath(@NotNull Path file2, @NotNull OpenFileRequest request) {
        return OpenFileHttpServiceKt.openAbsolutePath(file2, request);
    }

    public static final /* synthetic */ boolean access$openRelativePath(@NotNull String path, @NotNull OpenFileRequest request) {
        return OpenFileHttpServiceKt.openRelativePath(path, request);
    }

    public static final /* synthetic */ void access$navigate(@Nullable Project project, @NotNull VirtualFile file2, @NotNull OpenFileRequest request) {
        OpenFileHttpServiceKt.navigate(project, file2, request);
    }
}

