/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public static final Topic<Runnable> JSON_SCHEMA_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Schema.Changed", Runnable.class);
    public static final Topic<Runnable> JSON_DEPS_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Deps.Changed", Runnable.class);

    public static void startListening(@NotNull Project project, @NotNull JsonSchemaService service2, @NotNull MessageBusConnection connection) {
        if (project == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(0);
        }
        if (service2 == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(2);
        }
        final MyUpdater updater = new MyUpdater(project, service2);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(updater));
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file2) {
                if (file2 != null) {
                    updater.onFileChange(file2.getViewProvider().getVirtualFile());
                }
            }
        });
    }

    private JsonSchemaVfsListener(final @NotNull MyUpdater updater) {
        if (updater == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(3);
        }
        super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){
            @NotNull
            private final MyUpdater myUpdater;
            {
                this.myUpdater = updater;
            }

            protected void onFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.myUpdater.onFileChange(schemaFile);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.myUpdater.onFileChange(schemaFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "schemaFile";
                objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startListening";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyUpdater {
        @NotNull
        private final Project myProject;
        private final ZipperUpdater myUpdater;
        @NotNull
        private final JsonSchemaService myService;
        private final Set<VirtualFile> myDirtySchemas;
        private final Runnable myRunnable;
        private final ExecutorService myTaskExecutor;

        protected MyUpdater(@NotNull Project project, @NotNull JsonSchemaService service2) {
            if (project == null) {
                MyUpdater.$$$reportNull$$$0(0);
            }
            if (service2 == null) {
                MyUpdater.$$$reportNull$$$0(1);
            }
            this.myDirtySchemas = ContainerUtil.newConcurrentSet();
            this.myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"JsonVfsUpdaterExecutor");
            this.myProject = project;
            this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
            this.myService = service2;
            this.myRunnable = () -> {
                if (service2 == null) {
                    MyUpdater.$$$reportNull$$$0(3);
                }
                if (project == null) {
                    MyUpdater.$$$reportNull$$$0(4);
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet<VirtualFile> scope = new HashSet<VirtualFile>(this.myDirtySchemas);
                if (scope.stream().anyMatch(f -> {
                    if (service2 == null) {
                        MyUpdater.$$$reportNull$$$0(5);
                    }
                    return service2.possiblyHasReference(f.getName());
                })) {
                    ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_DEPS_CHANGED)).run();
                }
                this.myDirtySchemas.removeAll(scope);
                if (scope.isEmpty()) {
                    return;
                }
                List finalScope = ContainerUtil.filter(scope, file2 -> this.myService.isApplicableToFile((VirtualFile)file2) && ((JsonSchemaServiceImpl)this.myService).isMappedSchema((VirtualFile)file2, false));
                if (finalScope.isEmpty()) {
                    return;
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_SCHEMA_CHANGED)).run();
                DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                Editor[] editors = EditorFactory.getInstance().getAllEditors();
                Arrays.stream(editors).filter(editor -> editor instanceof EditorEx).map(editor -> ((EditorEx)editor).getVirtualFile()).filter(file2 -> file2 != null && file2.isValid()).forEach(file2 -> {
                    Collection<VirtualFile> schemaFiles = ((JsonSchemaServiceImpl)this.myService).getSchemasForFile((VirtualFile)file2, false, true);
                    if (schemaFiles.stream().anyMatch(finalScope::contains)) {
                        ReadAction.nonBlocking(() -> Optional.ofNullable(psiManager.findFile(file2)).ifPresent(arg_0 -> ((DaemonCodeAnalyzer)analyzer).restart(arg_0))).submit((Executor)this.myTaskExecutor);
                    }
                });
            };
        }

        protected void onFileChange(@NotNull VirtualFile schemaFile) {
            if (schemaFile == null) {
                MyUpdater.$$$reportNull$$$0(2);
            }
            if ("json".equals(schemaFile.getExtension())) {
                this.myDirtySchemas.add(schemaFile);
                this.myUpdater.queue(this.myRunnable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemaFile";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener$MyUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileChange";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$7";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

