/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PermanentCommitsInfoImpl<CommitId>
implements PermanentCommitsInfo<CommitId> {
    private static final Logger LOG = Logger.getInstance(PermanentCommitsInfoImpl.class);
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<? extends CommitId> myCommitIdIndexes;
    @NotNull
    private final Map<Integer, CommitId> myNotLoadCommits;

    @NotNull
    public static <CommitId> PermanentCommitsInfoImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull Map<Integer, CommitId> notLoadedCommits) {
        if (graphCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(0);
        }
        if (notLoadedCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(1);
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        boolean isIntegerCase = !graphCommits.isEmpty() && graphCommits.get(0).getId().getClass() == Integer.class;
        List commitIdIndex = isIntegerCase ? PermanentCommitsInfoImpl.createCompressedIntList(graphCommits) : ContainerUtil.map(graphCommits, GraphCommit::getId);
        PermanentCommitsInfoImpl<CommitId> permanentCommitsInfoImpl = new PermanentCommitsInfoImpl<CommitId>(timestampGetter, commitIdIndex, notLoadedCommits);
        if (permanentCommitsInfoImpl == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(2);
        }
        return permanentCommitsInfoImpl;
    }

    @NotNull
    public static <CommitId> IntTimestampGetter createTimestampGetter(final @NotNull List<? extends GraphCommit<CommitId>> graphCommits) {
        if (graphCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(3);
        }
        IntTimestampGetter intTimestampGetter = IntTimestampGetter.newInstance(new TimestampGetter(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public long getTimestamp(int index) {
                return ((GraphCommit)graphCommits.get(index)).getTimestamp();
            }
        });
        if (intTimestampGetter == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(4);
        }
        return intTimestampGetter;
    }

    @NotNull
    private static List<Integer> createCompressedIntList(final @NotNull List<? extends GraphCommit<Integer>> graphCommits) {
        if (graphCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(5);
        }
        final IntList compressedIntList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public int get(int index) {
                return (Integer)((GraphCommit)graphCommits.get(index)).getId();
            }
        }, 30);
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                Integer n = compressedIntList.get(index);
                if (n == null) {
                    3.$$$reportNull$$$0(0);
                }
                return n;
            }

            @Override
            public int size() {
                return compressedIntList.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl$3", "get"));
            }
        };
        if (abstractList == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(6);
        }
        return abstractList;
    }

    public PermanentCommitsInfoImpl(@NotNull TimestampGetter timestampGetter, @NotNull List<? extends CommitId> commitIdIndex, @NotNull Map<Integer, CommitId> notLoadCommits) {
        if (timestampGetter == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(7);
        }
        if (commitIdIndex == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(8);
        }
        if (notLoadCommits == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(9);
        }
        this.myTimestampGetter = timestampGetter;
        this.myCommitIdIndexes = commitIdIndex;
        this.myNotLoadCommits = notLoadCommits;
    }

    @Override
    @NotNull
    public CommitId getCommitId(int nodeId) {
        if (nodeId < 0) {
            CommitId CommitId2 = this.myNotLoadCommits.get(nodeId);
            if (CommitId2 == null) {
                PermanentCommitsInfoImpl.$$$reportNull$$$0(10);
            }
            return CommitId2;
        }
        CommitId CommitId3 = this.myCommitIdIndexes.get(nodeId);
        if (CommitId3 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(11);
        }
        return CommitId3;
    }

    @Override
    public long getTimestamp(int nodeId) {
        if (nodeId < 0) {
            return 0L;
        }
        return this.myTimestampGetter.getTimestamp(nodeId);
    }

    @NotNull
    public TimestampGetter getTimestampGetter() {
        TimestampGetter timestampGetter = this.myTimestampGetter;
        if (timestampGetter == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(12);
        }
        return timestampGetter;
    }

    @Override
    public int getNodeId(@NotNull CommitId commitId) {
        int indexOf;
        if (commitId == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(13);
        }
        if ((indexOf = this.myCommitIdIndexes.indexOf(commitId)) != -1) {
            return indexOf;
        }
        return this.getNotLoadNodeId(commitId);
    }

    private int getNotLoadNodeId(@NotNull CommitId commitId) {
        if (commitId == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(14);
        }
        for (Map.Entry<Integer, CommitId> entry : this.myNotLoadCommits.entrySet()) {
            if (!entry.getValue().equals(commitId)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @NotNull
    public List<CommitId> convertToCommitIdList(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(15);
        }
        List list2 = ContainerUtil.map(commitIndexes, this::getCommitId);
        if (list2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public Set<CommitId> convertToCommitIdSet(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(17);
        }
        Set set = ContainerUtil.map2Set(commitIndexes, this::getCommitId);
        if (set == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> commitIds2) {
        if (commitIds2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(19);
        }
        Set<Integer> set = this.convertToNodeIds(commitIds2, false);
        if (set == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> commitIds2, boolean reportNotFound) {
        Collection unmatchedIds;
        if (commitIds2 == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(21);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        HashSet matchedIds = ContainerUtil.newHashSet();
        for (int i = 0; i < this.myCommitIdIndexes.size(); ++i) {
            CommitId commitId = this.myCommitIdIndexes.get(i);
            if (!commitIds2.contains(commitId)) continue;
            result2.add(i);
            matchedIds.add(commitId);
        }
        if (reportNotFound && !(unmatchedIds = ContainerUtil.subtract(commitIds2, (Collection)matchedIds)).isEmpty()) {
            LOG.warn("Unmatched commit ids " + unmatchedIds);
        }
        for (Map.Entry<Integer, CommitId> entry : this.myNotLoadCommits.entrySet()) {
            if (!commitIds2.contains(entry.getValue())) continue;
            result2.add(entry.getKey());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            PermanentCommitsInfoImpl.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphCommits";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoadedCommits";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIdIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notLoadCommits";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIndexes";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTimestampGetter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompressedIntList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitId";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestampGetter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommitIdList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommitIdSet";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTimestampGetter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCompressedIntList";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNodeId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNotLoadNodeId";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommitIdList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommitIdSet";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertToNodeIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

