/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class TableCellEditorWithButton
extends AbstractCellEditor
implements TableCellEditor {
    protected final MyComponent myComponent = new MyComponent();
    protected final EditorDelegate delegate = new EditorDelegate(){

        @Override
        public void setValue(Object value) {
            TableCellEditorWithButton.this.myComponent.getTextField().setText(value != null ? value.toString() : "");
        }

        @Override
        public Object getCellEditorValue() {
            return TableCellEditorWithButton.this.myComponent.getTextField().getText();
        }
    };
    protected final int myClickCountToStart = 1;

    public TableCellEditorWithButton() {
        this.myComponent.getTextField().addActionListener(this.delegate);
    }

    public JButton getButton() {
        return this.myComponent.getButton();
    }

    public JTextField getTextField() {
        return this.myComponent.getTextField();
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row2, int column) {
        this.delegate.setValue(value);
        return this.myComponent;
    }

    private class MyComponent
    extends JPanel {
        private final JTextField myTextField;
        private final FixedSizeButton myButton;

        MyComponent() {
            super(new GridBagLayout());
            this.myTextField = new JTextField();
            this.myButton = new FixedSizeButton((JComponent)this.myTextField);
            this.add((Component)this.myTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.myButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public FixedSizeButton getButton() {
            return this.myButton;
        }

        public JTextField getTextField() {
            return this.myTextField;
        }

        @Override
        public boolean requestDefaultFocus() {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTextField, true));
            return true;
        }
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 1;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            TableCellEditorWithButton.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            TableCellEditorWithButton.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditorWithButton.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TableCellEditorWithButton.this.stopCellEditing();
        }
    }
}

