/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Tag(value="dictionary")
public class DictionaryState
implements PersistentStateComponent<DictionaryState> {
    public static final String NAME_ATTRIBUTE = "name";
    @XCollection(style=XCollection.Style.v2, elementName="w", valueAttributeName="")
    public Set<String> words;
    @Attribute(value="name")
    public String name;
    @Transient
    private EditableDictionary dictionary;

    public DictionaryState() {
        this.words = new THashSet();
    }

    public DictionaryState(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            DictionaryState.$$$reportNull$$$0(0);
        }
        this.words = new THashSet();
        this.setDictionary(dictionary);
    }

    @Transient
    public void setDictionary(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            DictionaryState.$$$reportNull$$$0(1);
        }
        this.dictionary = dictionary;
        this.name = dictionary.getName();
        this.synchronizeWords();
    }

    @Transient
    public EditableDictionary getDictionary() {
        return this.dictionary;
    }

    public DictionaryState getState() {
        this.synchronizeWords();
        return this;
    }

    private void synchronizeWords() {
        if (this.dictionary != null) {
            this.words = new THashSet(this.dictionary.getWords());
        }
    }

    public void loadState(@NotNull DictionaryState state) {
        if (state == null) {
            DictionaryState.$$$reportNull$$$0(2);
        }
        if (state != null && state.name != null) {
            this.name = state.name;
            this.words = state.words;
        }
        this.retrieveDictionary();
    }

    private void retrieveDictionary() {
        assert (this.name != null);
        this.dictionary = new UserDictionary(this.name);
        this.dictionary.addToDictionary(this.words);
    }

    public String toString() {
        return "DictionaryState{dictionary=" + this.dictionary + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/state/DictionaryState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setDictionary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

