/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

class RangeMarkerWindow
implements RangeMarkerEx {
    private final DocumentWindow myDocumentWindow;
    private final RangeMarkerEx myHostMarker;
    private final int myStartShift;
    private final int myEndShift;

    RangeMarkerWindow(@NotNull DocumentWindow documentWindow, RangeMarkerEx hostMarker, int startShift, int endShift) {
        if (documentWindow == null) {
            RangeMarkerWindow.$$$reportNull$$$0(0);
        }
        this.myDocumentWindow = documentWindow;
        this.myHostMarker = hostMarker;
        this.myStartShift = startShift;
        this.myEndShift = endShift;
    }

    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocumentWindow;
        if (documentWindow == null) {
            RangeMarkerWindow.$$$reportNull$$$0(1);
        }
        return documentWindow;
    }

    public int getStartOffset() {
        int hostOffset = this.myHostMarker.getStartOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) - this.myStartShift;
    }

    public int getEndOffset() {
        int hostOffset = this.myHostMarker.getEndOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) + this.myStartShift + this.myEndShift;
    }

    public boolean isValid() {
        int endOffset;
        if (!this.myHostMarker.isValid() || !this.myDocumentWindow.isValid()) {
            return false;
        }
        int startOffset = this.getStartOffset();
        return startOffset <= (endOffset = this.getEndOffset()) && endOffset <= this.myDocumentWindow.getTextLength();
    }

    public void setGreedyToLeft(boolean greedy) {
        this.myHostMarker.setGreedyToLeft(greedy);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myHostMarker.setGreedyToRight(greedy);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            RangeMarkerWindow.$$$reportNull$$$0(2);
        }
        return (T)this.myHostMarker.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            RangeMarkerWindow.$$$reportNull$$$0(3);
        }
        this.myHostMarker.putUserData(key, value);
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerWindow.$$$reportNull$$$0(4);
        }
        this.myHostMarker.documentChanged(e);
    }

    @Override
    public long getId() {
        return this.myHostMarker.getId();
    }

    public RangeMarkerEx getDelegate() {
        return this.myHostMarker;
    }

    public boolean isGreedyToRight() {
        return this.myHostMarker.isGreedyToRight();
    }

    public boolean isGreedyToLeft() {
        return this.myHostMarker.isGreedyToLeft();
    }

    public void dispose() {
        this.myHostMarker.dispose();
    }

    public String toString() {
        return "RangeMarkerWindow" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/RangeMarkerWindow";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/RangeMarkerWindow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

