/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="template")
public abstract class ArchivedProjectTemplate
implements ProjectTemplate {
    public static final String INPUT_FIELD = "input-field";
    public static final String TEMPLATE = "template";
    public static final String INPUT_DEFAULT = "default";
    protected final String myDisplayName;
    @Nullable
    private final String myCategory;
    private List<WizardInputField> myInputFields;
    private List<String> myFrameworks;
    private List<Artifact> myArtifacts;

    public ArchivedProjectTemplate(@NotNull String displayName, @Nullable String category) {
        if (displayName == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(0);
        }
        this.myInputFields = Collections.emptyList();
        this.myFrameworks = new ArrayList<String>();
        this.myArtifacts = new ArrayList<Artifact>();
        this.myDisplayName = displayName;
        this.myCategory = category;
    }

    @NotNull
    public String getName() {
        String string = this.myDisplayName;
        if (string == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Icon getIcon() {
        return this.getModuleType().getIcon();
    }

    protected abstract ModuleType getModuleType();

    @NotNull
    public ModuleBuilder createModuleBuilder() {
        TemplateModuleBuilder templateModuleBuilder = new TemplateModuleBuilder(this, this.getModuleType(), this.getInputFields());
        if (templateModuleBuilder == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(2);
        }
        return templateModuleBuilder;
    }

    @NotNull
    public List<WizardInputField> getInputFields() {
        List<WizardInputField> list2 = this.myInputFields;
        if (list2 == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="artifact")
    public List<Artifact> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="framework", valueAttributeName="")
    @NotNull
    public List<String> getFrameworks() {
        List<String> list2 = this.myFrameworks;
        if (list2 == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void setFrameworks(List<String> frameworks) {
        this.myFrameworks = frameworks;
    }

    @Nullable
    public ValidationInfo validateSettings() {
        return null;
    }

    public void handleUnzippedDirectories(File dir, List<? super File> filesToRefresh) throws IOException {
        filesToRefresh.add(dir);
    }

    public abstract <T> T processStream(@NotNull StreamProcessor<T> var1) throws IOException;

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    public void populateFromElement(@NotNull Element element) {
        if (element == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(5);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        this.myInputFields = ArchivedProjectTemplate.getFields(element);
    }

    private static List<WizardInputField> getFields(Element templateElement) {
        return ContainerUtil.mapNotNull((Collection)templateElement.getChildren(INPUT_FIELD), element -> {
            ProjectTemplateParameterFactory factory = WizardInputField.getFactoryById((String)element.getText());
            return factory == null ? null : factory.createField(element.getAttributeValue(INPUT_DEFAULT));
        });
    }

    static <T> T consumeZipStream(@NotNull StreamProcessor<T> consumer, @NotNull ZipInputStream stream) throws IOException {
        if (consumer == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(6);
        }
        if (stream == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(7);
        }
        try {
            T t = consumer.consume(stream);
            return t;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/ArchivedProjectTemplate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/ArchivedProjectTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateFromElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "consumeZipStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class StreamProcessor<T> {
        public abstract T consume(@NotNull ZipInputStream var1) throws IOException;
    }
}

