/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveBomAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoveBomAction.class));

    public RemoveBomAction() {
        super("Remove BOM");
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            RemoveBomAction.$$$reportNull$$$0(0);
        }
        if ((files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext())) == null || files2.length == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = false;
        String fromWhere = files2[0].getName();
        for (VirtualFile file2 : files2) {
            if (file2.isDirectory()) {
                enabled = true;
                fromWhere = "all files in " + file2.getName() + " (recursively)" + (files2.length == 1 ? "" : " and others");
                break;
            }
            if (file2.getBOM() == null) continue;
            enabled = true;
            fromWhere = file2.getName() + (files2.length == 1 ? "" : " and others");
            break;
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
        e.getPresentation().setDescription("Remove byte order mark from " + fromWhere);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            RemoveBomAction.$$$reportNull$$$0(1);
        }
        if ((files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext())) == null) {
            return;
        }
        final List<VirtualFile> filesToProcess = RemoveBomAction.getFilesWithBom(files2);
        if (filesToProcess.isEmpty()) {
            return;
        }
        final ArrayList filesUnableToProcess = new ArrayList();
        new Task.Backgroundable(RemoveBomAction.getEventProject((AnActionEvent)e), "Removing BOM", true, () -> false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                for (int i = 0; i < filesToProcess.size(); ++i) {
                    ProgressManager.checkCanceled();
                    VirtualFile virtualFile = (VirtualFile)filesToProcess.get(i);
                    indicator.setFraction((double)i * 1.0 / (double)filesToProcess.size());
                    indicator.setText2(StringUtil.shortenPathWithEllipsis((String)virtualFile.getPath(), (int)40));
                    byte[] bom = virtualFile.getBOM();
                    if (!(virtualFile instanceof NewVirtualFile) || bom == null) continue;
                    if (RemoveBomAction.isBOMMandatory(virtualFile)) {
                        filesUnableToProcess.add(virtualFile);
                        continue;
                    }
                    RemoveBomAction.doRemoveBOM(virtualFile, bom);
                }
                if (!filesUnableToProcess.isEmpty()) {
                    String title = "Was unable to remove BOM in " + filesUnableToProcess.size() + " " + StringUtil.pluralize((String)"file", (int)filesUnableToProcess.size());
                    String msg = (filesUnableToProcess.size() == 1 ? "This file has" : "These files have") + " mandatory BOM:<br/>    " + StringUtil.join((Collection)filesUnableToProcess, VirtualFile::getName, (String)"<br/>    ");
                    Notifications.Bus.notify((Notification)new Notification("Failed to remove BOM", title, msg, NotificationType.ERROR));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/editor/actions/RemoveBomAction$1", "run"));
            }
        }.queue();
    }

    private static boolean isBOMMandatory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RemoveBomAction.$$$reportNull$$$0(2);
        }
        return CharsetToolkit.getMandatoryBom((Charset)file2.getCharset()) != null;
    }

    private static void doRemoveBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] bom) {
        if (virtualFile == null) {
            RemoveBomAction.$$$reportNull$$$0(3);
        }
        if (bom == null) {
            RemoveBomAction.$$$reportNull$$$0(4);
        }
        virtualFile.setBOM(null);
        NewVirtualFile file2 = (NewVirtualFile)virtualFile;
        try {
            byte[] bytes = file2.contentsToByteArray();
            byte[] contentWithStrippedBom = new byte[bytes.length - bom.length];
            System.arraycopy(bytes, bom.length, contentWithStrippedBom, 0, contentWithStrippedBom.length);
            WriteAction.runAndWait(() -> file2.setBinaryContent(contentWithStrippedBom));
        }
        catch (IOException ex) {
            LOG.warn("Unexpected exception occurred on attempt to remove BOM from file " + file2, (Throwable)ex);
        }
    }

    @NotNull
    private static List<VirtualFile> getFilesWithBom(@NotNull VirtualFile[] roots) {
        if (roots == null) {
            RemoveBomAction.$$$reportNull$$$0(5);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            RemoveBomAction.getFilesWithBom(root, result2);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            RemoveBomAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void getFilesWithBom(@NotNull VirtualFile root, final @NotNull List<? super VirtualFile> result2) {
        if (root == null) {
            RemoveBomAction.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            RemoveBomAction.$$$reportNull$$$0(8);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory() && file2.getBOM() != null) {
                    result2.add(file2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/RemoveBomAction$2", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bom";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/RemoveBomAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/RemoveBomAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithBom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBOMMandatory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveBOM";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithBom";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

