/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.ide.CopyPasteManager;

public class DeleteToWordEndAction
extends TextComponentEditorAction {
    public DeleteToWordEndAction() {
        super((EditorActionHandler)new Handler(false));
    }

    private static void deleteToWordEnd(Editor editor, boolean camelMode) {
        int startOffset = editor.getCaretModel().getOffset();
        int endOffset = DeleteToWordEndAction.getWordEndOffset(editor, startOffset, camelMode);
        if (endOffset > startOffset) {
            Document document = editor.getDocument();
            document.deleteString(startOffset, endOffset);
        }
    }

    private static int getWordEndOffset(Editor editor, int offset, boolean camelMode) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        if (offset >= document.getTextLength() - 1) {
            return offset;
        }
        int newOffset = offset + 1;
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int maxOffset = document.getLineEndOffset(lineNumber);
        if (newOffset > maxOffset) {
            if (lineNumber + 1 >= document.getLineCount()) {
                return offset;
            }
            maxOffset = document.getLineEndOffset(lineNumber + 1);
        }
        while (!(newOffset >= maxOffset || EditorActionUtil.isWordEnd(text, newOffset, camelMode) || EditorActionUtil.isWordStart(text, newOffset, camelMode) || EditorActionUtil.isLexemeBoundary(editor, newOffset))) {
            ++newOffset;
        }
        return newOffset;
    }

    static class Handler
    extends EditorWriteActionHandler {
        private final boolean myNegateCamelMode;

        Handler(boolean negateCamelMode) {
            super(true);
            this.myNegateCamelMode = negateCamelMode;
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            boolean camelMode = editor.getSettings().isCamelWords();
            if (this.myNegateCamelMode) {
                boolean bl = camelMode = !camelMode;
            }
            if (editor.getSelectionModel().hasSelection()) {
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                return;
            }
            DeleteToWordEndAction.deleteToWordEnd(editor, camelMode);
        }
    }
}

