/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeCollectingVisitor;
import com.intellij.history.core.ChangeSetsProcessor;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.revisions.ChangeRevision;
import com.intellij.history.core.revisions.CurrentRevision;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevisionsCollector
extends ChangeSetsProcessor {
    private final LocalHistoryFacade myFacade;
    private final RootEntry myRoot;
    private final String myProjectId;
    private final String myPattern;
    private final List<Revision> myResult;

    public RevisionsCollector(LocalHistoryFacade facade, RootEntry rootEntry, @NotNull String path, String projectId, @Nullable String pattern) {
        if (path == null) {
            RevisionsCollector.$$$reportNull$$$0(0);
        }
        super(path);
        this.myResult = new ArrayList<Revision>();
        this.myFacade = facade;
        this.myRoot = rootEntry;
        this.myProjectId = projectId;
        this.myPattern = pattern;
    }

    public List<Revision> getResult() {
        this.process();
        return this.myResult;
    }

    @Override
    protected void process() {
        this.myResult.add(new CurrentRevision(this.myRoot, this.myPath));
        super.process();
    }

    @Override
    protected Pair<String, List<ChangeSet>> collectChanges() {
        ChangeCollectingVisitor v = new ChangeCollectingVisitor(this.myPath, this.myProjectId, this.myPattern);
        this.myFacade.accept(v);
        return Pair.create((Object)v.getPath(), v.getChanges());
    }

    @Override
    protected void nothingToVisit() {
    }

    @Override
    protected void visit(ChangeSet changeSet) {
        this.myResult.add(new ChangeRevision(this.myFacade, this.myRoot, this.myPath, changeSet, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/core/RevisionsCollector", "<init>"));
    }
}

