/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.hosting.RepositoryHostingService;
import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.ComponentVisibilityProgressManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloneDvcsDialog
extends DialogWrapper {
    private static final Pattern SSH_URL_PATTERN;
    private ComboBox<String> myRepositoryUrlCombobox;
    private CollectionComboBoxModel<String> myRepositoryUrlComboboxModel;
    private TextFieldWithAutoCompletion<String> myRepositoryUrlField;
    private ComponentVisibilityProgressManager mySpinnerProgressManager;
    private JButton myTestButton;
    private MyTextFieldWithBrowseButton myDirectoryField;
    private LoginButtonComponent myLoginButtonComponent;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final String myVcsDirectoryName;
    @Nullable
    private ValidationInfo myCreateDirectoryValidationInfo;
    @Nullable
    private ValidationInfo myRepositoryTestValidationInfo;
    @Nullable
    private ProgressIndicator myRepositoryTestProgressIndicator;
    @NotNull
    private final List<String> myLoadedRepositoryHostingServicesNames;
    @Nullable
    private Alarm myRepositoryUrlAutoCompletionTooltipAlarm;
    @NotNull
    private final Set<String> myUniqueAvailableRepositories;
    @NotNull
    private List<ValidationInfo> myRepositoryListLoadingErrors;

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName) {
        if (project == null) {
            CloneDvcsDialog.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(1);
        }
        if (vcsDirectoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(2);
        }
        this(project, displayName, vcsDirectoryName, null);
    }

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName, @Nullable String defaultUrl) {
        if (project == null) {
            CloneDvcsDialog.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(4);
        }
        if (vcsDirectoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(5);
        }
        super(project, true);
        this.myRepositoryListLoadingErrors = new ArrayList<ValidationInfo>();
        this.myProject = project;
        this.myVcsDirectoryName = vcsDirectoryName;
        this.myLoadedRepositoryHostingServicesNames = new ArrayList<String>();
        this.myUniqueAvailableRepositories = new HashSet<String>();
        this.initComponents(defaultUrl);
        Map<String, RepositoryListLoader> loadersToSchedule = this.initUrlAutocomplete();
        this.setTitle(DvcsBundle.getString("clone.title"));
        this.setOKButtonText(DvcsBundle.getString("clone.button"));
        this.init();
        this.scheduleLater(loadersToSchedule);
    }

    protected void doOKAction() {
        final String path = this.myDirectoryField.getText();
        new Task.Modal(this.myProject, "Creating Destination Directory", true){
            private ValidationInfo error;
            {
                super(arg0, arg1, arg2);
                this.error = null;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.error = CloneDvcsDialog.createDestination(path);
            }

            public void onSuccess() {
                if (this.error == null) {
                    CloneDvcsDialog.super.doOKAction();
                } else {
                    CloneDvcsDialog.this.myCreateDirectoryValidationInfo = this.error;
                    CloneDvcsDialog.this.startTrackingValidation();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CloneDvcsDialog$1", "run"));
            }
        }.queue();
    }

    @Nullable
    private static ValidationInfo createDestination(@NotNull String path) {
        if (path == null) {
            CloneDvcsDialog.$$$reportNull$$$0(6);
        }
        try {
            Path directoryPath = Paths.get(path, new String[0]);
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            } else if (!Files.isDirectory(directoryPath, new LinkOption[0]) || !Files.isWritable(directoryPath)) {
                return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.access")).withOKEnabled();
            }
            return null;
        }
        catch (InvalidPathException e) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.invalid"));
        }
        catch (Exception e) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.access")).withOKEnabled();
        }
    }

    @NotNull
    public String getSourceRepositoryURL() {
        String string = this.getCurrentUrlText();
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getParentDirectory() {
        Path parent = Paths.get(this.myDirectoryField.getText(), new String[0]).toAbsolutePath().getParent();
        String string = ((Path)ObjectUtils.assertNotNull((Object)parent)).toAbsolutePath().toString();
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getDirectoryName() {
        String string = Paths.get(this.myDirectoryField.getText(), new String[0]).getFileName().toString();
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void initComponents(@Nullable String defaultUrl) {
        String parentDirectory = this.getRememberedInputs().getCloneParentDir();
        this.myRepositoryUrlComboboxModel = new CollectionComboBoxModel();
        this.myRepositoryUrlField = TextFieldWithAutoCompletion.create(this.myProject, this.myRepositoryUrlComboboxModel.getItems(), false, "");
        JLabel repositoryUrlFieldSpinner = new JLabel((Icon)new AnimatedIcon.Default());
        repositoryUrlFieldSpinner.setVisible(false);
        this.mySpinnerProgressManager = new ComponentVisibilityProgressManager(repositoryUrlFieldSpinner);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.mySpinnerProgressManager);
        this.myRepositoryUrlCombobox = new ComboBox();
        this.myRepositoryUrlCombobox.setEditable(true);
        this.myRepositoryUrlCombobox.setEditor(ComboBoxCompositeEditor.withComponents(this.myRepositoryUrlField, new JComponent[]{repositoryUrlFieldSpinner}));
        this.myRepositoryUrlCombobox.setModel(this.myRepositoryUrlComboboxModel);
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CloneDvcsDialog.this.myDirectoryField.trySetChildPath(CloneDvcsDialog.this.defaultDirectoryName(CloneDvcsDialog.this.myRepositoryUrlField.getText().trim()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/ui/CloneDvcsDialog$2", "documentChanged"));
            }
        });
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/ui/CloneDvcsDialog$3", "documentChanged"));
            }
        });
        this.myTestButton = new JButton(DvcsBundle.getString("clone.repository.url.test.label"));
        this.myTestButton.addActionListener(e -> this.test());
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setHideIgnored(false);
        this.myDirectoryField = new MyTextFieldWithBrowseButton(StringUtil.isEmptyOrSpaces((String)parentDirectory) ? ProjectUtil.getBaseDir() : parentDirectory);
        this.myDirectoryField.addBrowseFolderListener(DvcsBundle.getString("clone.destination.directory.browser.title"), DvcsBundle.getString("clone.destination.directory.browser.description"), this.myProject, fcd);
        if (defaultUrl != null) {
            this.myRepositoryUrlField.setText(defaultUrl);
            this.myRepositoryUrlField.selectAll();
            this.myTestButton.setEnabled(true);
        }
    }

    private Map<String, RepositoryListLoader> initUrlAutocomplete() {
        Collection<RepositoryHostingService> repositoryHostingServices = this.getRepositoryHostingServices();
        if (repositoryHostingServices.size() > 1) {
            this.myRepositoryUrlAutoCompletionTooltipAlarm = new Alarm(this.getDisposable());
            this.myRepositoryUrlAutoCompletionTooltipAlarm.setActivationComponent(this.myRepositoryUrlCombobox);
        }
        ArrayList<Action> loginActions = new ArrayList<Action>();
        HashMap<String, RepositoryListLoader> enabledLoaders = new HashMap<String, RepositoryListLoader>();
        for (RepositoryHostingService service2 : repositoryHostingServices) {
            final String serviceDisplayName = service2.getServiceDisplayName();
            final RepositoryListLoader loader = service2.getRepositoryListLoader(this.myProject);
            if (loader == null) continue;
            if (loader.isEnabled()) {
                enabledLoaders.put(serviceDisplayName, loader);
                continue;
            }
            loginActions.add(new AbstractAction(DvcsBundle.message("clone.repository.url.autocomplete.login.text", serviceDisplayName)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (loader.enable((Component)CloneDvcsDialog.this.myLoginButtonComponent.getPanel())) {
                        CloneDvcsDialog.this.myLoginButtonComponent.removeAction(this);
                        CloneDvcsDialog.this.schedule(serviceDisplayName, loader);
                    }
                }
            });
        }
        this.myRepositoryUrlField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CloneDvcsDialog.this.showRepositoryUrlAutoCompletionTooltip();
            }
        });
        this.myLoginButtonComponent = new LoginButtonComponent(loginActions);
        return enabledLoaders;
    }

    @NotNull
    protected Collection<RepositoryHostingService> getRepositoryHostingServices() {
        List<RepositoryHostingService> list2 = Collections.emptyList();
        if (list2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private void scheduleLater(@NotNull Map<String, RepositoryListLoader> loaders) {
        if (loaders == null) {
            CloneDvcsDialog.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (loaders == null) {
                CloneDvcsDialog.$$$reportNull$$$0(31);
            }
            loaders.forEach(this::schedule);
        }, ModalityState.stateForComponent((Component)this.getRootPane()));
    }

    private void schedule(final @NotNull String serviceDisplayName, final @NotNull RepositoryListLoader loader) {
        if (serviceDisplayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(12);
        }
        if (loader == null) {
            CloneDvcsDialog.$$$reportNull$$$0(13);
        }
        this.mySpinnerProgressManager.run(new Task.Backgroundable(this.myProject, "Not Visible"){
            private final List<String> myNewRepositories;
            private final List<RepositoryListLoadingException> myErrors;
            {
                super(arg0, arg1);
                this.myNewRepositories = new ArrayList<String>();
                this.myErrors = new ArrayList<RepositoryListLoadingException>();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                RepositoryListLoader.Result loadingResult = loader.getAvailableRepositoriesFromMultipleSources(indicator);
                for (String repository : loadingResult.getUrls()) {
                    if (!CloneDvcsDialog.this.myUniqueAvailableRepositories.add(repository)) continue;
                    this.myNewRepositories.add(repository);
                }
                this.myErrors.addAll(loadingResult.getErrors());
            }

            public void onSuccess() {
                if (CloneDvcsDialog.this.mySpinnerProgressManager.getDisposed()) {
                    return;
                }
                if (!this.myNewRepositories.isEmpty()) {
                    CloneDvcsDialog.this.myRepositoryUrlCombobox.setSelectedItem((Object)CloneDvcsDialog.this.myRepositoryUrlField.getText());
                    CloneDvcsDialog.this.myRepositoryUrlComboboxModel.addAll(CloneDvcsDialog.this.myRepositoryUrlComboboxModel.getSize(), this.myNewRepositories);
                    CloneDvcsDialog.this.myRepositoryUrlField.setVariants(CloneDvcsDialog.this.myRepositoryUrlComboboxModel.getItems());
                }
                CloneDvcsDialog.this.myLoadedRepositoryHostingServicesNames.add(serviceDisplayName);
                CloneDvcsDialog.this.showRepositoryUrlAutoCompletionTooltip();
                if (!this.myErrors.isEmpty()) {
                    for (RepositoryListLoadingException error : this.myErrors) {
                        StringBuilder errorMessageBuilder = new StringBuilder();
                        errorMessageBuilder.append(error.getMessage());
                        Throwable cause = error.getCause();
                        if (cause != null) {
                            errorMessageBuilder.append(": ").append(cause.getMessage());
                        }
                        CloneDvcsDialog.this.myRepositoryListLoadingErrors.add(new ValidationInfo(errorMessageBuilder.toString()).asWarning());
                    }
                    CloneDvcsDialog.this.startTrackingValidation();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CloneDvcsDialog$6", "run"));
            }
        });
    }

    private void showRepositoryUrlAutoCompletionTooltip() {
        if (this.myRepositoryUrlAutoCompletionTooltipAlarm == null) {
            this.showRepositoryUrlAutoCompletionTooltipNow();
        } else {
            this.myRepositoryUrlAutoCompletionTooltipAlarm.cancelAllRequests();
            this.myRepositoryUrlAutoCompletionTooltipAlarm.addComponentRequest(this::showRepositoryUrlAutoCompletionTooltipNow, 1);
        }
    }

    private void showRepositoryUrlAutoCompletionTooltipNow() {
        if (!this.hasErrors((JComponent)this.myRepositoryUrlCombobox) && !this.myLoadedRepositoryHostingServicesNames.isEmpty()) {
            Editor editor = this.myRepositoryUrlField.getEditor();
            if (editor == null) {
                return;
            }
            String completionShortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            HintManager.getInstance().showInformationHint(editor, DvcsBundle.message("clone.repository.url.autocomplete.hint", DvcsUtil.joinWithAnd(this.myLoadedRepositoryHostingServicesNames, 0), completionShortcutText));
        }
    }

    private void test() {
        final String testUrl = this.getCurrentUrlText();
        if (this.myRepositoryTestProgressIndicator != null) {
            this.myRepositoryTestProgressIndicator.cancel();
            this.myRepositoryTestProgressIndicator = null;
        }
        this.myRepositoryTestProgressIndicator = this.mySpinnerProgressManager.run(new Task.Backgroundable(this.myProject, DvcsBundle.message("clone.repository.url.test.title", testUrl), true){
            private TestResult myTestResult;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                this.myTestResult = CloneDvcsDialog.this.test(testUrl);
            }

            public void onSuccess() {
                if (this.myTestResult.isSuccess()) {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
                    Disposable dialogDisposable = CloneDvcsDialog.this.getDisposable();
                    if (Disposer.isDisposed((Disposable)dialogDisposable)) {
                        return;
                    }
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(DvcsBundle.getString("clone.repository.url.test.success.message"))).setDisposable(dialogDisposable).createBalloon().show(new RelativePoint((Component)CloneDvcsDialog.this.myTestButton, new Point(CloneDvcsDialog.this.myTestButton.getWidth() / 2, CloneDvcsDialog.this.myTestButton.getHeight())), Balloon.Position.below);
                } else {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = new ValidationInfo(DvcsBundle.message("clone.repository.url.test.failed.message", this.myTestResult.myErrorMessage), (JComponent)CloneDvcsDialog.this.myRepositoryUrlCombobox);
                    CloneDvcsDialog.this.startTrackingValidation();
                }
                CloneDvcsDialog.this.myRepositoryTestProgressIndicator = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CloneDvcsDialog$7", "run"));
            }
        });
    }

    @NotNull
    protected abstract TestResult test(@NotNull String var1);

    @NotNull
    protected abstract DvcsRememberedInputs getRememberedInputs();

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo urlValidation = this.checkRepositoryURL();
        ValidationInfo directoryValidation = this.checkDirectory();
        this.myTestButton.setEnabled(urlValidation == null);
        ArrayList<ValidationInfo> infoList = new ArrayList<ValidationInfo>();
        ContainerUtil.addIfNotNull(infoList, (Object)this.myRepositoryTestValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)this.myCreateDirectoryValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)urlValidation);
        ContainerUtil.addIfNotNull(infoList, (Object)directoryValidation);
        infoList.addAll(this.myRepositoryListLoadingErrors);
        ArrayList<ValidationInfo> arrayList = infoList;
        if (arrayList == null) {
            CloneDvcsDialog.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    private ValidationInfo checkRepositoryURL() {
        String repository = this.getCurrentUrlText();
        if (repository.length() == 0) {
            return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.empty"), this.myRepositoryUrlCombobox);
        }
        try {
            if (new URI(repository).isAbsolute()) {
                return null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (SSH_URL_PATTERN.matcher(repository).matches()) {
            return null;
        }
        try {
            Path path = Paths.get(repository, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.not.directory"), this.myRepositoryUrlCombobox);
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.invalid"), this.myRepositoryUrlCombobox);
    }

    @Nullable
    private ValidationInfo checkDirectory() {
        String directoryPath = this.myDirectoryField.getText();
        if (directoryPath.length() == 0) {
            return new ValidationInfo("");
        }
        try {
            Path path = Paths.get(directoryPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.not.directory"), (JComponent)this.myDirectoryField.getTextField());
            }
            if (!CloneDvcsDialog.isDirectoryEmpty(path)) {
                return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.exists", new Object[0]), (JComponent)this.myDirectoryField.getTextField());
            }
        }
        catch (IOException | InvalidPathException e) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.invalid"), (JComponent)this.myDirectoryField.getTextField());
        }
        return null;
    }

    private static boolean isDirectoryEmpty(@NotNull Path directory) throws IOException {
        DirectoryStream<Path> directoryStream;
        if (directory == null) {
            CloneDvcsDialog.$$$reportNull$$$0(15);
        }
        return !(directoryStream = Files.newDirectoryStream(directory)).iterator().hasNext();
    }

    @NotNull
    private String getCurrentUrlText() {
        String string = FileUtil.expandUserHome((String)this.myRepositoryUrlField.getText().trim());
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Deprecated
    public void prependToHistory(@NotNull String item) {
        if (item == null) {
            CloneDvcsDialog.$$$reportNull$$$0(17);
        }
        this.myRepositoryUrlComboboxModel.add((Object)item);
    }

    public void rememberSettings() {
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        rememberedInputs.addUrl(this.getSourceRepositoryURL());
        rememberedInputs.setCloneParentDir(this.getParentDirectory());
    }

    @NotNull
    private static String safeUrlDecode(@NotNull String encoded) {
        String string;
        if (encoded == null) {
            CloneDvcsDialog.$$$reportNull$$$0(18);
        }
        try {
            string = URLDecoder.decode(encoded, "UTF-8");
        }
        catch (Exception e) {
            String string2 = encoded;
            if (string2 == null) {
                CloneDvcsDialog.$$$reportNull$$$0(20);
            }
            return string2;
        }
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private String defaultDirectoryName(@NotNull String url) {
        if (url == null) {
            CloneDvcsDialog.$$$reportNull$$$0(21);
        }
        String string = this.stripSuffix(CloneDvcsDialog.safeUrlDecode(CloneDvcsDialog.getLastPathFragment(url)));
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private String stripSuffix(@NotNull String directoryName) {
        if (directoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(23);
        }
        String string = directoryName.endsWith(this.myVcsDirectoryName) ? directoryName.substring(0, directoryName.length() - this.myVcsDirectoryName.length()) : directoryName;
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String getLastPathFragment(@NotNull String url) {
        int i;
        if (url == null) {
            CloneDvcsDialog.$$$reportNull$$$0(25);
        }
        if ((i = url.lastIndexOf(47)) == -1 && File.separatorChar != '/') {
            i = url.lastIndexOf(File.separatorChar);
        }
        if (i < 0) {
            if ("" == null) {
                CloneDvcsDialog.$$$reportNull$$$0(26);
            }
            return "";
        }
        if (i == url.length() - 1) {
            String string = CloneDvcsDialog.getLastPathFragment(url.substring(0, i));
            if (string == null) {
                CloneDvcsDialog.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = url.substring(i + 1);
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryUrlField;
    }

    @NotNull
    protected JPanel createSouthAdditionalPanel() {
        JPanel jPanel = this.myLoginButtonComponent.getPanel();
        if (jPanel == null) {
            CloneDvcsDialog.$$$reportNull$$$0(29);
        }
        return jPanel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)JBUI.Panels.simplePanel((int)10, (int)4).addToCenter(this.myRepositoryUrlCombobox).addToRight((Component)this.myTestButton)).withLabel(DvcsBundle.getString("clone.repository.url.label"))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myDirectoryField)).withLabel(DvcsBundle.getString("clone.destination.directory.label"))).createPanel();
        panel2.setPreferredSize((Dimension)new JBDimension(500, 50, true));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            CloneDvcsDialog.$$$reportNull$$$0(30);
        }
        return jPanel;
    }

    static {
        String ch = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]";
        String host = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*";
        String path = "/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        String all = "(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        SSH_URL_PATTERN = Pattern.compile("(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDirectoryName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CloneDvcsDialog";
                break;
            }
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaders";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceDisplayName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoded";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRepositoryURL";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryHostingServices";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentUrlText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "safeUrlDecode";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultDirectoryName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "stripSuffix";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastPathFragment";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthAdditionalPanel";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDestination";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scheduleLater";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryEmpty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prependToHistory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "safeUrlDecode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "defaultDirectoryName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "stripSuffix";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLastPathFragment";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleLater$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoginButtonComponent {
        @NotNull
        private final JBOptionButton myButton;
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final List<Action> myActions;

        LoginButtonComponent(@NotNull List<Action> actions) {
            if (actions == null) {
                LoginButtonComponent.$$$reportNull$$$0(0);
            }
            this.myButton = new JBOptionButton((Action)ContainerUtil.getFirstItem(actions), LoginButtonComponent.getActionsAfterFirst(actions));
            this.myPanel = UI.PanelFactory.panel((JComponent)this.myButton).withTooltip(DvcsBundle.getString("clone.repository.url.autocomplete.login.tooltip")).createPanel();
            this.myPanel.setVisible(!actions.isEmpty());
            this.myPanel.setBorder((Border)JBUI.Borders.emptyRight((int)16));
            this.myActions = new ArrayList<Action>(actions);
        }

        void removeAction(@NotNull Action action) {
            if (action == null) {
                LoginButtonComponent.$$$reportNull$$$0(1);
            }
            if (this.myActions.remove(action)) {
                if (!this.myActions.isEmpty()) {
                    this.myButton.setAction((Action)ContainerUtil.getFirstItem(this.myActions));
                    this.myButton.setOptions(LoginButtonComponent.getActionsAfterFirst(this.myActions));
                } else {
                    this.myButton.setAction(null);
                    this.myButton.setOptions(null);
                    this.myPanel.setVisible(false);
                }
            }
        }

        @NotNull
        private static Action[] getActionsAfterFirst(@NotNull List<Action> actions) {
            if (actions == null) {
                LoginButtonComponent.$$$reportNull$$$0(2);
            }
            if (actions.size() <= 1) {
                Action[] actionArray = new Action[]{};
                if (actionArray == null) {
                    LoginButtonComponent.$$$reportNull$$$0(3);
                }
                return actionArray;
            }
            Action[] actionArray = actions.subList(1, actions.size()).toArray(new Action[actions.size() - 1]);
            if (actionArray == null) {
                LoginButtonComponent.$$$reportNull$$$0(4);
            }
            return actionArray;
        }

        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                LoginButtonComponent.$$$reportNull$$$0(5);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CloneDvcsDialog$LoginButtonComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog$LoginButtonComponent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionsAfterFirst";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionsAfterFirst";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTextFieldWithBrowseButton
    extends TextFieldWithBrowseButton {
        @NotNull
        private final Path myDefaultParentPath;
        private boolean myModifiedByUser;

        private MyTextFieldWithBrowseButton(@NotNull String defaultParentPath) {
            if (defaultParentPath == null) {
                MyTextFieldWithBrowseButton.$$$reportNull$$$0(0);
            }
            this.myModifiedByUser = false;
            this.myDefaultParentPath = Paths.get(defaultParentPath, new String[0]).toAbsolutePath();
            this.setText(this.myDefaultParentPath.toString());
            this.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myModifiedByUser = true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/CloneDvcsDialog$MyTextFieldWithBrowseButton$1", "textChanged"));
                }
            });
        }

        public void trySetChildPath(@NotNull String child2) {
            if (child2 == null) {
                MyTextFieldWithBrowseButton.$$$reportNull$$$0(1);
            }
            if (!this.myModifiedByUser) {
                try {
                    this.setText(this.myDefaultParentPath.resolve(child2).toString());
                }
                catch (InvalidPathException invalidPathException) {
                }
                finally {
                    this.myModifiedByUser = false;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultParentPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog$MyTextFieldWithBrowseButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySetChildPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class TestResult {
        @NotNull
        public static final TestResult SUCCESS = new TestResult(null);
        @Nullable
        private final String myErrorMessage;

        public TestResult(@Nullable String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean isSuccess() {
            return this.myErrorMessage == null;
        }

        @Nullable
        public String getError() {
            return this.myErrorMessage;
        }
    }
}

