/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.CommonBundle;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.ui.MyDoNotAskOptionForPush;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushUtils;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dvcs/push/ui/ForcePushAction;", "Lcom/intellij/dvcs/push/ui/PushActionBase;", "()V", "actionPerformed", "", "project", "Lcom/intellij/openapi/project/Project;", "ui", "Lcom/intellij/dvcs/push/ui/VcsPushUi;", "confirmForcePush", "", "getDescription", "", "enabled", "isEnabled", "intellij.platform.vcs.dvcs.impl"})
public final class ForcePushAction
extends PushActionBase {
    @Override
    protected void actionPerformed(@NotNull Project project, @NotNull VcsPushUi ui) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        if (this.confirmForcePush(project, ui)) {
            ui.push(true);
        }
    }

    @Override
    protected boolean isEnabled(@NotNull VcsPushUi ui) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        return ui.canPush() && PushUtils.getProhibitedTarget(ui) == null;
    }

    @Override
    @Nullable
    protected String getDescription(@NotNull VcsPushUi ui, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        PushTarget prohibitedTarget = PushUtils.getProhibitedTarget(ui);
        return !enabled && prohibitedTarget != null ? "Force push to " + prohibitedTarget.getPresentation() + " is prohibited" : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean confirmForcePush(Project project, VcsPushUi ui) {
        MyDoNotAskOptionForPush myDoNotAskOptionForPush;
        PushTarget commonTarget;
        PushSupport aSupport;
        Object object;
        Object object2;
        Collection it$iv$iv;
        void $receiver$iv$iv;
        Map $receiver$iv;
        Map map = ui.getSelectedPushSpecs();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"ui.selectedPushSpecs");
        Map map2 = $receiver$iv = map;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Object $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Collection pushInfos;
            void $support_pushInfos;
            Object element$iv$iv$iv = iterator.next();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = k;
            object = map3;
            void var14_20 = $support_pushInfos;
            PushSupport support = (PushSupport)var14_20.getKey();
            var14_20 = $support_pushInfos;
            Collection collection = pushInfos = (Collection)var14_20.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"pushInfos");
            Iterable iterable = $receiver$iv2 = (Iterable)collection;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                PushInfo it;
                PushInfo pushInfo = it = (PushInfo)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)pushInfo, (String)"it");
                PushSpec<PushSource, PushTarget> pushSpec = pushInfo.getPushSpec();
                Intrinsics.checkExpressionValueIsNotNull(pushSpec, (String)"it.pushSpec");
                if (!(!support.isSilentForcePushAllowed(pushSpec.getTarget()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            object.put(object2, list2);
        }
        $receiver$iv = destination$iv$iv;
        LinkedHashMap result$iv = new LinkedHashMap();
        destination$iv$iv = $receiver$iv;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            List it = (List)entry.getValue();
            it$iv$iv = it;
            if (!(!it$iv$iv.isEmpty())) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map silentForcePushIsNotAllowed = result$iv;
        if (silentForcePushIsNotAllowed.isEmpty()) {
            return true;
        }
        if (silentForcePushIsNotAllowed.size() > 1) {
            aSupport = null;
            commonTarget = null;
        } else {
            void $receiver$iv$iv3;
            aSupport = (PushSupport)CollectionsKt.first((Iterable)silentForcePushIsNotAllowed.keySet());
            Object v = silentForcePushIsNotAllowed.get(aSupport);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            Iterable $receiver$iv3 = (Iterable)v;
            $receiver$iv$iv$iv = $receiver$iv3;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                void it;
                PushInfo $i$a$2$filterValues = (PushInfo)item$iv$iv;
                object = collection;
                void v5 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                PushSpec<PushSource, PushTarget> pushSpec = v5.getPushSpec();
                Intrinsics.checkExpressionValueIsNotNull(pushSpec, (String)"it.pushSpec");
                object2 = pushSpec.getTarget();
                object.add(object2);
            }
            commonTarget = (PushTarget)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)collection)));
        }
        String to = commonTarget != null ? " to <b>" + commonTarget.getPresentation() + "</b>" : "";
        String message = "You're going to force push" + to + ". It may overwrite commits at the remote. Are you sure you want to proceed?";
        if (commonTarget != null) {
            PushSupport pushSupport = aSupport;
            if (pushSupport == null) {
                Intrinsics.throwNpe();
            }
            myDoNotAskOptionForPush = new MyDoNotAskOptionForPush(pushSupport, commonTarget);
        } else {
            myDoNotAskOptionForPush = null;
        }
        MyDoNotAskOptionForPush myDoNotAskOptionForPush2 = myDoNotAskOptionForPush;
        int decision = Messages.showOkCancelDialog((Project)project, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)"Force Push", (String)"&Force Push", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)((DialogWrapper.DoNotAskOption)myDoNotAskOptionForPush2));
        return decision == 0;
    }
}

