/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.errordialog.PluginConflictDialog;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public enum PluginConflictReporter {
    INSTANCE;


    public void reportConflictByClasses(@NotNull Collection<Class<?>> conflictingClasses) {
        if (conflictingClasses == null) {
            PluginConflictReporter.$$$reportNull$$$0(0);
        }
        HashSet<PluginId> foundPlugins = new HashSet<PluginId>();
        boolean hasConflictWithPlatform = false;
        if (conflictingClasses.size() < 2) {
            Logger.getInstance(PluginConflictReporter.class).warn("One should provide at least two conflicting classes to report");
            return;
        }
        for (Class<?> aClass : conflictingClasses) {
            ClassLoader classLoader = aClass.getClassLoader();
            if (classLoader instanceof PluginClassLoader) {
                foundPlugins.add(((PluginClassLoader)((Object)classLoader)).getPluginId());
                continue;
            }
            hasConflictWithPlatform = true;
        }
        if (foundPlugins.isEmpty()) {
            Logger.getInstance(PluginConflictReporter.class).warn("The conflict has not come from PluginClassLoader");
            return;
        }
        new PluginConflictDialog(new ArrayList<PluginId>(foundPlugins), hasConflictWithPlatform).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingClasses", "com/intellij/diagnostic/PluginConflictReporter", "reportConflictByClasses"));
    }
}

