/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SaveExecutor;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.SaveSessionAndFile;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005J$\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/configurationStore/SaveSessionProducerManager;", "Lcom/intellij/configurationStore/SaveExecutor;", "()V", "sessions", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/components/StateStorage;", "Lcom/intellij/openapi/components/StateStorage$SaveSessionProducer;", "getProducer", "storage", "save", "", "readonlyFiles", "", "Lcom/intellij/openapi/components/impl/stores/SaveSessionAndFile;", "errors", "", "intellij.platform.configurationStore.impl"})
final class SaveSessionProducerManager
implements SaveExecutor {
    private final LinkedHashMap<StateStorage, StateStorage.SaveSessionProducer> sessions = new LinkedHashMap();

    @Nullable
    public final StateStorage.SaveSessionProducer getProducer(@NotNull StateStorage storage2) {
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        StateStorage.SaveSessionProducer session2 = this.sessions.get(storage2);
        if (session2 == null) {
            StateStorage.SaveSessionProducer saveSessionProducer = storage2.createSaveSessionProducer();
            if (saveSessionProducer == null) {
                return null;
            }
            session2 = saveSessionProducer;
            this.sessions.put(storage2, session2);
        }
        return session2;
    }

    @Override
    public boolean save(@NotNull List<SaveSessionAndFile> readonlyFiles, @NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        if (this.sessions.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (StateStorage.SaveSessionProducer session2 : this.sessions.values()) {
            StateStorage.SaveSession saveSession;
            if (session2.createSaveSession() == null) {
                continue;
            }
            ComponentStoreImplKt.executeSave(saveSession, readonlyFiles, errors);
            changed = true;
        }
        return changed;
    }
}

