/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.lang.HTMLComposerExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HTMLComposerImpl
extends HTMLComposer {
    private final int[] myListStack;
    private int myListStackTop = -1;
    private final Map<Key, HTMLComposerExtension> myExtensions = new HashMap<Key, HTMLComposerExtension>();
    private final Map<Language, HTMLComposerExtension> myLanguageExtensions = new HashMap<Language, HTMLComposerExtension>();
    @NonNls
    protected static final String BR = "<br>";
    @NonNls
    protected static final String NBSP = "&nbsp;";
    @NonNls
    protected static final String CODE_CLOSING = "</code>";
    @NonNls
    protected static final String CODE_OPENING = "<code>";
    @NonNls
    protected static final String B_OPENING = "<b>";
    @NonNls
    protected static final String B_CLOSING = "</b>";
    @NonNls
    protected static final String CLOSE_TAG = "\">";
    @NonNls
    protected static final String A_HREF_OPENING = "<a HREF=\"";
    @NonNls
    protected static final String A_CLOSING = "</a>";

    protected HTMLComposerImpl() {
        this.myListStack = new int[5];
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            HTMLComposerExtension extension = factory.createHTMLComposerExtension((HTMLComposer)this);
            if (extension == null) continue;
            this.myExtensions.put(extension.getID(), extension);
            this.myLanguageExtensions.put(extension.getLanguage(), extension);
        }
    }

    public abstract void compose(StringBuffer var1, RefEntity var2);

    public void compose(StringBuffer buf, RefEntity refElement, CommonProblemDescriptor descriptor) {
    }

    protected void genPageHeader(StringBuffer buf, RefEntity refEntity) {
        if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.capitalized.location", (Object[])new Object[0]));
            buf.append("<div class=\"location\">");
            this.appendShortName(buf, refElement);
            buf.append(BR);
            buf.append("in ");
            this.appendLocation(buf, refElement);
            buf.append("</div>");
            buf.append(BR).append(BR);
        }
    }

    private void appendLocation(StringBuffer buf, RefElement refElement) {
        HTMLComposerExtension extension = this.getLanguageExtension(refElement);
        if (extension != null) {
            extension.appendLocation((RefEntity)refElement, buf);
        }
        if (refElement instanceof RefFile) {
            buf.append(InspectionsBundle.message((String)"inspection.export.results.file", (Object[])new Object[0]));
            buf.append(NBSP);
            this.appendElementReference(buf, refElement, false);
        }
    }

    @Nullable
    private HTMLComposerExtension getLanguageExtension(RefElement refElement) {
        PsiElement element = refElement.getPsiElement();
        return element != null ? this.myLanguageExtensions.get(element.getLanguage()) : null;
    }

    private void appendShortName(final StringBuffer buf, RefElement refElement) {
        HTMLComposerExtension extension = this.getLanguageExtension(refElement);
        if (extension != null) {
            extension.appendShortName((RefEntity)refElement, buf);
        } else {
            refElement.accept(new RefVisitor(){

                public void visitFile(@NotNull RefFile file2) {
                    PsiFile psiFile;
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((psiFile = file2.getPsiElement()) != null) {
                        buf.append(HTMLComposerImpl.B_OPENING);
                        buf.append(psiFile.getName());
                        buf.append(HTMLComposerImpl.B_CLOSING);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/HTMLComposerImpl$1", "visitFile"));
                }
            });
        }
    }

    protected void appendQualifiedName(StringBuffer buf, RefEntity refEntity) {
        if (refEntity == null) {
            return;
        }
        String qName = "";
        while (!(refEntity instanceof RefProject)) {
            HTMLComposerExtension extension;
            if (qName.length() > 0) {
                qName = "." + qName;
            }
            String name = null;
            if (refEntity instanceof RefElement && (extension = this.getLanguageExtension((RefElement)refEntity)) != null) {
                name = extension.getQualifiedName(refEntity);
            }
            if (name == null) {
                name = refEntity.getName();
            }
            qName = name + qName;
            if (Comparing.strEqual((String)refEntity.getName(), (String)refEntity.getQualifiedName())) {
                buf.append(qName);
                return;
            }
            refEntity = refEntity.getOwner();
        }
        buf.append(qName);
    }

    public void appendElementReference(StringBuffer buf, RefElement refElement) {
        this.appendElementReference(buf, refElement, true);
    }

    public void appendElementReference(StringBuffer buf, RefElement refElement, String linkText, @NonNls String frameName) {
        String url = ((RefElementImpl)refElement).getURL();
        if (url != null) {
            this.appendElementReference(buf, url, linkText, frameName);
        }
    }

    public void appendElementReference(StringBuffer buf, String url, String linkText, @NonNls String frameName) {
        buf.append(A_HREF_OPENING);
        buf.append(url);
        if (frameName != null) {
            String target2 = "\" target=\"";
            buf.append("\" target=\"");
            buf.append(frameName);
        }
        buf.append(CLOSE_TAG);
        buf.append(linkText);
        buf.append(A_CLOSING);
    }

    protected void appendQuickFix(@NonNls StringBuffer buf, String text) {
        buf.append(text);
    }

    public void appendElementReference(StringBuffer buf, RefElement refElement, boolean isPackageIncluded) {
        HTMLComposerExtension extension = this.getLanguageExtension(refElement);
        if (extension != null) {
            extension.appendReferencePresentation((RefEntity)refElement, buf, isPackageIncluded);
        } else if (refElement instanceof RefFile) {
            VirtualFile file2;
            buf.append(A_HREF_OPENING);
            buf.append(((RefElementImpl)refElement).getURL());
            buf.append(CLOSE_TAG);
            String refElementName = refElement.getName();
            PsiElement element = refElement.getPsiElement();
            if (element != null && (file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) != null) {
                refElementName = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)file2, (String)file2.getPresentableUrl(), (Project)element.getProject(), (boolean)true, (boolean)false);
            }
            buf.append(refElementName);
            buf.append(A_CLOSING);
        }
    }

    public String composeNumereables(int n, String statement, String singleEnding, String multipleEnding) {
        StringBuilder buf = new StringBuilder();
        buf.append(n);
        buf.append(' ');
        buf.append(statement);
        if (n % 10 == 1 && n % 100 != 11) {
            buf.append(singleEnding);
        } else {
            buf.append(multipleEnding);
        }
        return buf.toString();
    }

    public void appendElementInReferences(StringBuffer buf, RefElement refElement) {
        if (refElement.getInReferences().size() > 0) {
            HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.used.from", (Object[])new Object[0]));
            this.startList(buf);
            for (RefElement refCaller : refElement.getInReferences()) {
                this.appendListItem(buf, refCaller);
            }
            this.doneList(buf);
        }
    }

    public void appendElementOutReferences(StringBuffer buf, RefElement refElement) {
        if (refElement.getOutReferences().size() > 0) {
            HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.export.results.uses", (Object[])new Object[0]));
            this.startList(buf);
            for (RefElement refCallee : refElement.getOutReferences()) {
                this.appendListItem(buf, refCallee);
            }
            this.doneList(buf);
        }
    }

    public void appendListItem(StringBuffer buf, RefElement refElement) {
        this.startListItem(buf);
        this.appendElementReference(buf, refElement, true);
        this.appendAdditionalListItemInfo(buf, refElement);
        HTMLComposerImpl.doneListItem(buf);
    }

    protected void appendAdditionalListItemInfo(StringBuffer buf, RefElement refElement) {
    }

    protected void appendResolution(StringBuffer buf, RefEntity where, String[] quickFixes) {
        if (where instanceof RefElement && !where.isValid()) {
            return;
        }
        if (quickFixes != null) {
            boolean listStarted = false;
            for (String text : quickFixes) {
                if (text == null) continue;
                if (!listStarted) {
                    HTMLComposerImpl.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.resolution", (Object[])new Object[0]));
                    this.startList(buf);
                    listStarted = true;
                }
                this.startListItem(buf);
                this.appendQuickFix(buf, text);
                HTMLComposerImpl.doneListItem(buf);
            }
            if (listStarted) {
                this.doneList(buf);
            }
        }
    }

    public void startList(@NonNls StringBuffer buf) {
        if (this.myListStackTop == -1) {
            buf.append("<div class=\"problem-description\">");
        }
        buf.append("<ul>");
        ++this.myListStackTop;
        this.myListStack[this.myListStackTop] = 0;
    }

    public void doneList(@NonNls StringBuffer buf) {
        buf.append("</ul>");
        if (this.myListStack[this.myListStackTop] != 0) {
            buf.append("<table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td>&nbsp;</td></tr></table>");
        }
        if (this.myListStackTop == 0) {
            buf.append("</div>");
        }
        --this.myListStackTop;
    }

    public void startListItem(@NonNls StringBuffer buf) {
        int n = this.myListStackTop;
        this.myListStack[n] = this.myListStack[n] + 1;
        buf.append("<li>");
    }

    public static void doneListItem(@NonNls StringBuffer buf) {
        buf.append("</li>");
    }

    public void appendNoProblems(StringBuffer buf) {
        buf.append("<p class=\"problem-description-group\">");
        buf.append(InspectionsBundle.message((String)"inspection.export.results.no.problems.found", (Object[])new Object[0]));
        buf.append("</p>");
    }

    public <T> T getExtension(Key<T> key) {
        return (T)this.myExtensions.get(key);
    }
}

