/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LastSelectedPropertiesFileStore", storages={@Storage(value="lastSelectedPropertiesFile.xml", roamingType=RoamingType.DISABLED)})
public class LastSelectedPropertiesFileStore
implements PersistentStateComponent<Element> {
    private static final String PROPERTIES_FILE_STATISTICS_KEY = "PROPERTIES_FILE";
    private final Map<String, String> lastSelectedUrls = new LinkedHashMap();
    private String lastSelectedFileUrl;

    public static LastSelectedPropertiesFileStore getInstance() {
        return (LastSelectedPropertiesFileStore)ServiceManager.getService(LastSelectedPropertiesFileStore.class);
    }

    @Nullable
    public String suggestLastSelectedPropertiesFileUrl(PsiFile context) {
        for (VirtualFile virtualFile = context.getVirtualFile(); virtualFile != null; virtualFile = virtualFile.getParent()) {
            String contextUrl = virtualFile.getUrl();
            String url = this.lastSelectedUrls.get(contextUrl);
            if (url == null) continue;
            return url;
        }
        if (this.lastSelectedFileUrl != null) {
            VirtualFile lastFile = VirtualFileManager.getInstance().findFileByUrl(this.lastSelectedFileUrl);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
            if (lastFile != null && ModuleUtilCore.findModuleForPsiElement((PsiElement)context) == fileIndex.getModuleForFile(lastFile)) {
                return this.lastSelectedFileUrl;
            }
        }
        return null;
    }

    public static int getUseCount(@NotNull String path) {
        if (path == null) {
            LastSelectedPropertiesFileStore.$$$reportNull$$$0(0);
        }
        return StatisticsManager.getInstance().getUseCount(new StatisticsInfo(PROPERTIES_FILE_STATISTICS_KEY, path));
    }

    public void saveLastSelectedPropertiesFile(PsiFile context, PropertiesFile file) {
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        assert (virtualFile != null);
        String contextUrl = virtualFile.getUrl();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null) {
            String url = vFile.getUrl();
            this.lastSelectedUrls.put(contextUrl, url);
            VirtualFile containingDir = virtualFile.getParent();
            this.lastSelectedUrls.put(containingDir.getUrl(), url);
            this.lastSelectedFileUrl = url;
            StatisticsManager.getInstance().incUseCount(new StatisticsInfo(PROPERTIES_FILE_STATISTICS_KEY, FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url))));
        }
    }

    public Element getState() {
        Element state = new Element("state");
        for (Map.Entry<String, String> entry : this.lastSelectedUrls.entrySet()) {
            Element child = new Element("entry");
            child.setAttribute("context", entry.getKey());
            child.setAttribute("url", entry.getValue());
            state.addContent(child);
        }
        if (this.lastSelectedFileUrl != null) {
            state.setAttribute("lastSelectedFileUrl", this.lastSelectedFileUrl);
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            LastSelectedPropertiesFileStore.$$$reportNull$$$0(1);
        }
        this.lastSelectedUrls.clear();
        for (Element child : state.getChildren("entry")) {
            String context = child.getAttributeValue("context");
            String url = child.getAttributeValue("url");
            VirtualFile propFile = VirtualFileManager.getInstance().findFileByUrl(url);
            VirtualFile contextFile = VirtualFileManager.getInstance().findFileByUrl(context);
            if (propFile == null || contextFile == null) continue;
            this.lastSelectedUrls.put(context, url);
        }
        this.lastSelectedFileUrl = state.getAttributeValue("lastSelectedFileUrl");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/LastSelectedPropertiesFileStore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUseCount";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

