/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import icons.PythonIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class PyRemoteSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] NAMES = new String[]{"python", "jython", "pypy", "python.exe", "jython.bat", "pypy.exe"};
    private static final String[] REMOTE_SDK_HOME_PREFIXES = new String[]{"ssh:", "vagrant:", "docker:", "docker-compose:", "sftp:"};
    public static PyRemoteSdkFlavor INSTANCE = new PyRemoteSdkFlavor();

    private PyRemoteSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        return Lists.newArrayList();
    }

    @Override
    public boolean isValidSdkHome(String path) {
        return StringUtil.isNotEmpty((String)path) && PyRemoteSdkFlavor.checkName(NAMES, PyRemoteSdkFlavor.getExecutableName(path)) && PyRemoteSdkFlavor.checkName(REMOTE_SDK_HOME_PREFIXES, path);
    }

    private static boolean checkName(String[] names, @Nullable String name) {
        if (name == null) {
            return false;
        }
        for (String n : names) {
            if (!name.startsWith(n)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getExecutableName(String path) {
        return RemoteFile.createRemoteFile((String)path).getName();
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.RemoteInterpreter;
    }
}

