/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public class CondaEnvSdkFlavor
extends CPythonSdkFlavor {
    public static final String[] CONDA_DEFAULT_ROOTS = new String[]{"anaconda", "anaconda2", "anaconda3", "miniconda", "miniconda2", "miniconda3", "Anaconda", "Anaconda2", "Anaconda3", "Miniconda", "Miniconda2", "Miniconda3"};
    public static CondaEnvSdkFlavor INSTANCE = new CondaEnvSdkFlavor();

    private CondaEnvSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (VirtualFile file : CondaEnvSdkFlavor.getCondaDefaultLocations()) {
            candidates.addAll(VirtualEnvSdkFlavor.findInDirectory(file));
        }
        return candidates;
    }

    public static List<VirtualFile> getCondaDefaultLocations() {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        VirtualFile userHome = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getUserHome().replace('\\', '/'));
        if (userHome != null) {
            VirtualFile condaHidden = userHome.findChild(".conda");
            if (condaHidden != null) {
                CondaEnvSdkFlavor.addEnvsFolder(roots, condaHidden);
            }
            for (String root : CONDA_DEFAULT_ROOTS) {
                VirtualFile condaFolder = userHome.findChild(root);
                CondaEnvSdkFlavor.addEnvsFolder(roots, condaFolder);
                if (SystemInfo.isWindows) {
                    VirtualFile appData = userHome.findFileByRelativePath("AppData\\Local\\Continuum\\" + root);
                    CondaEnvSdkFlavor.addEnvsFolder(roots, appData);
                    condaFolder = LocalFileSystem.getInstance().findFileByPath("C:\\" + root);
                    CondaEnvSdkFlavor.addEnvsFolder(roots, condaFolder);
                    continue;
                }
                String systemWidePath = "/opt/anaconda";
                condaFolder = LocalFileSystem.getInstance().findFileByPath("/opt/anaconda");
                CondaEnvSdkFlavor.addEnvsFolder(roots, condaFolder);
            }
        }
        CondaEnvSdkFlavor.addEnvsFolder(roots, CondaEnvSdkFlavor.findPreferredCondaEnvsFolder());
        return roots;
    }

    @Nullable
    private static VirtualFile findPreferredCondaEnvsFolder() {
        @SystemDependent String path = PyCondaPackageService.getInstance().PREFERRED_CONDA_PATH;
        if (path == null) {
            return null;
        }
        VirtualFile conda = StandardFileSystems.local().findFileByPath(path);
        if (conda == null) {
            return null;
        }
        VirtualFile binFolder = conda.getParent();
        if (binFolder == null) {
            return null;
        }
        return binFolder.getParent();
    }

    private static void addEnvsFolder(@NotNull List<VirtualFile> roots, @Nullable VirtualFile condaFolder) {
        VirtualFile envs;
        if (roots == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(0);
        }
        if (condaFolder != null && (envs = condaFolder.findChild("envs")) != null) {
            roots.add(envs);
        }
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        File bin = file.getParentFile();
        String condaName = "conda";
        if (SystemInfo.isWindows) {
            String string = condaName = new File(bin, "envs").exists() ? "conda.exe" : "conda.bat";
        }
        if (bin != null) {
            File conda = new File(bin, condaName);
            if (conda.exists()) {
                return true;
            }
            File condaFolder = bin.getParentFile();
            File condaExecutable = PythonSdkType.findExecutableFile(condaFolder, condaName);
            if (condaExecutable != null) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static File getCondaEnvRoot(@NotNull String binaryPath) {
        File binary;
        File bin;
        if (binaryPath == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(2);
        }
        if ((bin = (binary = new File(binaryPath)).getParentFile()) == null) {
            return null;
        }
        File root = bin.getParentFile();
        if (root == null) {
            return null;
        }
        File rootContainer = root.getParentFile();
        if (rootContainer == null) {
            return null;
        }
        return "envs".equals(rootContainer.getName()) ? root : null;
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Condaenv;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/flavors/CondaEnvSdkFlavor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addEnvsFolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSdkPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCondaEnvRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

