/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.remote.RemoteProcessControl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ExceptionBreakpointProperties;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyBreakpointHandlerFactory;
import com.jetbrains.python.debugger.PyBreakpointType;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyConcurrencyService;
import com.jetbrains.python.debugger.PyCythonExtensionWarning;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyExceptionBreakpointHandler;
import com.jetbrains.python.debugger.PyExecutionStack;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.PyLineBreakpointHandler;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.debugger.PySmartStepIntoHandler;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PySuspendContext;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import com.jetbrains.python.debugger.containerview.PyViewNumericContainerAction;
import com.jetbrains.python.debugger.pydev.ClientModeMultiProcessDebugger;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.MultiProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebugProcess
extends XDebugProcess
implements IPyDebugProcess,
ProcessListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.debugger.PyDebugProcess");
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)PyBundle.message("debug.notification.group", new Object[0]), (String)ToolWindowId.DEBUG);
    private final ProcessDebugger myDebugger;
    private final XBreakpointHandler[] myBreakpointHandlers;
    private final PyDebuggerEditorsProvider myEditorsProvider;
    private final ProcessHandler myProcessHandler;
    private final ExecutionConsole myExecutionConsole;
    private final Map<PySourcePosition, XLineBreakpoint> myRegisteredBreakpoints;
    private final Map<String, XBreakpoint<? extends ExceptionBreakpointProperties>> myRegisteredExceptionBreakpoints;
    private final List<PyThreadInfo> mySuspendedThreads;
    private final Map<String, XValueChildrenList> myStackFrameCache;
    private final Object myFrameCacheObject;
    private final Map<String, PyDebugValue> myNewVariableValue;
    private boolean myDownloadSources;
    private boolean myClosing;
    private PyPositionConverter myPositionConverter;
    private final XSmartStepIntoHandler<?> mySmartStepIntoHandler;
    private boolean myWaitingForConnection;
    private PyStackFrame myConsoleContextFrame;
    private PyReferrersLoader myReferrersProvider;
    private final List<PyFrameListener> myFrameListeners;
    private boolean isCythonWarningShown;
    @Nullable
    private XCompositeNode myCurrentRootNode;

    public PyDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, boolean multiProcess) {
        if (session == null) {
            PyDebugProcess.$$$reportNull$$$0(0);
        }
        if (serverSocket == null) {
            PyDebugProcess.$$$reportNull$$$0(1);
        }
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(2);
        }
        this(session, multiProcess ? process2 -> {
            if (serverSocket == null) {
                PyDebugProcess.$$$reportNull$$$0(42);
            }
            return process2.createMultiprocessDebugger(serverSocket);
        } : process2 -> {
            if (serverSocket == null) {
                PyDebugProcess.$$$reportNull$$$0(41);
            }
            return new RemoteDebugger((IPyDebugProcess)process2, serverSocket, process2.getConnectTimeout());
        }, executionConsole, processHandler);
    }

    public PyDebugProcess(@NotNull XDebugSession session, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull String serverHost, int serverPort) {
        if (session == null) {
            PyDebugProcess.$$$reportNull$$$0(3);
        }
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(4);
        }
        if (serverHost == null) {
            PyDebugProcess.$$$reportNull$$$0(5);
        }
        this(session, process2 -> {
            if (serverHost == null) {
                PyDebugProcess.$$$reportNull$$$0(40);
            }
            return new ClientModeMultiProcessDebugger((IPyDebugProcess)process2, serverHost, serverPort);
        }, executionConsole, processHandler);
    }

    private PyDebugProcess(final @NotNull XDebugSession session, @NotNull DebuggerFactory debuggerFactory, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler) {
        if (session == null) {
            PyDebugProcess.$$$reportNull$$$0(6);
        }
        if (debuggerFactory == null) {
            PyDebugProcess.$$$reportNull$$$0(7);
        }
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(8);
        }
        super(session);
        this.myRegisteredBreakpoints = new ConcurrentHashMap<PySourcePosition, XLineBreakpoint>();
        this.myRegisteredExceptionBreakpoints = new ConcurrentHashMap<String, XBreakpoint<? extends ExceptionBreakpointProperties>>();
        this.mySuspendedThreads = Collections.synchronizedList(Lists.newArrayList());
        this.myStackFrameCache = Maps.newConcurrentMap();
        this.myFrameCacheObject = new Object();
        this.myNewVariableValue = Maps.newHashMap();
        this.myDownloadSources = false;
        this.myClosing = false;
        this.myWaitingForConnection = false;
        this.myConsoleContextFrame = null;
        this.myFrameListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.isCythonWarningShown = false;
        session.setPauseActionSupported(true);
        this.myDebugger = debuggerFactory.createDebugger(this);
        ArrayList<XBreakpointHandler> breakpointHandlers = new ArrayList<XBreakpointHandler>();
        breakpointHandlers.add(new PyLineBreakpointHandler(this));
        breakpointHandlers.add(new PyExceptionBreakpointHandler(this));
        for (PyBreakpointHandlerFactory factory : PyBreakpointHandlerFactory.EP_NAME.getExtensionList()) {
            breakpointHandlers.add(factory.createBreakpointHandler(this));
        }
        this.myBreakpointHandlers = breakpointHandlers.toArray(XBreakpointHandler.EMPTY_ARRAY);
        this.myEditorsProvider = new PyDebuggerEditorsProvider();
        this.mySmartStepIntoHandler = new PySmartStepIntoHandler(this);
        this.myProcessHandler = processHandler;
        this.myExecutionConsole = executionConsole;
        if (this.myProcessHandler != null) {
            this.myProcessHandler.addProcessListener((ProcessListener)this);
        }
        this.myPositionConverter = processHandler instanceof PositionConverterProvider ? ((PositionConverterProvider)processHandler).createPositionConverter(this) : new PyLocalPositionConverter();
        final PyDebugValueExecutionService executionService = PyDebugValueExecutionService.getInstance((Project)this.getProject());
        executionService.sessionStarted((PyFrameAccessor)this);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                executionService.sessionStopped((PyFrameAccessor)PyDebugProcess.this);
            }
        });
        this.myDebugger.addCloseListener(new RemoteDebuggerCloseListener(){

            public void closed() {
                PyDebugProcess.this.handleStop();
            }

            public void communicationError() {
                PyDebugProcess.this.detachDebuggedProcess();
            }

            public void detached() {
                PyDebugProcess.this.detachDebuggedProcess();
            }
        });
        session.addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                XExecutionStack activeStack;
                String currentFrameThreadId = null;
                XStackFrame currentFrame = session.getCurrentStackFrame();
                if (currentFrame instanceof PyStackFrame) {
                    currentFrameThreadId = ((PyStackFrame)currentFrame).getThreadId();
                }
                if ((activeStack = session.getSuspendContext().getActiveExecutionStack()) == null || currentFrameThreadId == null) {
                    return;
                }
                XStackFrame frameFromSuspendContext = activeStack.getTopFrame();
                String activeStackThreadId = null;
                if (frameFromSuspendContext instanceof PyStackFrame) {
                    activeStackThreadId = ((PyStackFrame)frameFromSuspendContext).getThreadId();
                }
                if (!currentFrameThreadId.equals(activeStackThreadId)) {
                    PyThreadInfo threadInfo = null;
                    for (PyThreadInfo info : PyDebugProcess.this.mySuspendedThreads) {
                        if (!info.getId().equals(currentFrameThreadId)) continue;
                        threadInfo = info;
                        break;
                    }
                    if (threadInfo != null) {
                        PyDebugProcess.this.getSession().positionReached((XSuspendContext)PyDebugProcess.this.createSuspendContext(threadInfo));
                    }
                }
                for (PyFrameListener listener2 : PyDebugProcess.this.myFrameListeners) {
                    listener2.frameChanged();
                }
            }
        });
    }

    private MultiProcessDebugger createMultiprocessDebugger(ServerSocket serverSocket) {
        MultiProcessDebugger debugger = new MultiProcessDebugger((IPyDebugProcess)this, serverSocket, this.getConnectTimeout());
        debugger.addOtherDebuggerCloseListener(new MultiProcessDebugger.DebuggerProcessListener(){

            public void threadsClosed(Set<String> threadIds) {
                for (PyThreadInfo t : PyDebugProcess.this.mySuspendedThreads) {
                    if (!threadIds.contains(t.getId()) || !PyDebugProcess.this.getSession().isSuspended()) continue;
                    PyDebugProcess.this.getSession().resume();
                    break;
                }
            }
        });
        return debugger;
    }

    protected void detachDebuggedProcess() {
        this.handleStop();
    }

    protected void handleStop() {
        this.getSession().stop();
    }

    public void setPositionConverter(PyPositionConverter positionConverter) {
        this.myPositionConverter = positionConverter;
    }

    public PyPositionConverter getPositionConverter() {
        return this.myPositionConverter;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myBreakpointHandlers == null) {
            PyDebugProcess.$$$reportNull$$$0(9);
        }
        return this.myBreakpointHandlers;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        PyDebuggerEditorsProvider pyDebuggerEditorsProvider = this.myEditorsProvider;
        if (pyDebuggerEditorsProvider == null) {
            PyDebugProcess.$$$reportNull$$$0(10);
        }
        return pyDebuggerEditorsProvider;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole executionConsole = this.myExecutionConsole;
        if (executionConsole == null) {
            PyDebugProcess.$$$reportNull$$$0(11);
        }
        return executionConsole;
    }

    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    public void sessionInitialized() {
        this.waitForConnection(this.getConnectionMessage(), this.getConnectionTitle());
    }

    protected void waitForConnection(final String connectionMessage, String connectionTitle) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getSession().getProject(), connectionTitle, false){

            public void run(@NotNull ProgressIndicator indicator) {
                block4: {
                    if (indicator == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    indicator.setText(connectionMessage);
                    try {
                        PyDebugProcess.this.beforeConnect();
                        PyDebugProcess.this.myWaitingForConnection = true;
                        PyDebugProcess.this.myDebugger.waitForConnect();
                        PyDebugProcess.this.myWaitingForConnection = false;
                        PyDebugProcess.this.afterConnect();
                        PyDebugProcess.this.handshake();
                        PyDebugProcess.this.init();
                        PyDebugProcess.this.myDebugger.run();
                    }
                    catch (Exception e) {
                        PyDebugProcess.this.myWaitingForConnection = false;
                        if (PyDebugProcess.this.myProcessHandler != null) {
                            PyDebugProcess.this.myProcessHandler.destroyProcess();
                        }
                        if (!PyDebugProcess.this.shouldLogConnectionException(e)) break block4;
                        NOTIFICATION_GROUP.createNotification(PyBundle.message("debug.notification.title.connection.failed", new Object[0]), e.getMessage(), NotificationType.ERROR, null).notify(this.myProject);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/debugger/PyDebugProcess$5", "run"));
            }
        });
    }

    protected boolean shouldLogConnectionException(Exception e) {
        return true;
    }

    public void init() {
        this.getSession().rebuildViews();
        this.registerBreakpoints();
        this.setShowReturnValues(PyDebuggerSettings.getInstance().isWatchReturnValues());
    }

    public int handleDebugPort(int localPort) throws IOException {
        if (this.myProcessHandler instanceof RemoteProcessControl) {
            return PyDebugProcess.getRemoteTunneledPort(localPort, (RemoteProcessControl)this.myProcessHandler);
        }
        return localPort;
    }

    protected static int getRemoteTunneledPort(int localPort, @NotNull RemoteProcessControl handler) throws IOException {
        if (handler == null) {
            PyDebugProcess.$$$reportNull$$$0(12);
        }
        try {
            return (Integer)handler.getRemoteSocket(localPort).getSecond();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void recordSignature(PySignature signature) {
        PySignatureCacheManager.getInstance(this.getSession().getProject()).recordSignature(this.myPositionConverter.convertSignature(signature));
    }

    public void recordLogEvent(PyConcurrencyEvent event) {
        PyConcurrencyService.getInstance(this.getSession().getProject()).recordEvent(this.getSession(), event, event.isAsyncio());
    }

    public void showConsole(PyThreadInfo thread) {
        this.myConsoleContextFrame = new PyExecutionStack(this, thread).getTopFrame();
        if (this.myExecutionConsole instanceof PythonDebugLanguageConsoleView) {
            PythonDebugLanguageConsoleView consoleView = (PythonDebugLanguageConsoleView)this.myExecutionConsole;
            UIUtil.invokeLaterIfNeeded(() -> {
                consoleView.enableConsole(false);
                consoleView.getPydevConsoleView().setConsoleEnabled(true);
            });
        }
    }

    public void consoleInputRequested(boolean isStarted) {
        if (this.myExecutionConsole instanceof PythonDebugLanguageConsoleView) {
            PythonConsoleView consoleView = ((PythonDebugLanguageConsoleView)this.myExecutionConsole).getPydevConsoleView();
            if (isStarted) {
                consoleView.inputRequested();
            } else {
                consoleView.inputReceived();
            }
        }
    }

    public void showCythonWarning() {
        if (!this.isCythonWarningShown) {
            PyCythonExtensionWarning.showCythonExtensionWarning(this.getSession().getProject());
            this.isCythonWarningShown = true;
        }
    }

    protected void afterConnect() {
    }

    protected void beforeConnect() {
    }

    protected String getConnectionMessage() {
        return "Waiting for connection...";
    }

    protected String getConnectionTitle() {
        return "Connecting To Debugger";
    }

    private void handshake() throws PyDebuggerException {
        String remoteVersion = this.myDebugger.handshake();
        String currentBuild = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        remoteVersion = "@@BUILD_NUMBER@@".equals(remoteVersion) ? currentBuild : (remoteVersion.startsWith("PY-") ? remoteVersion.substring(3) : null);
        this.printToConsole("Connected to pydev debugger (build " + remoteVersion + ")\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        if (remoteVersion != null && !remoteVersion.equals(currentBuild) && !remoteVersion.startsWith(currentBuild)) {
            LOG.warn(String.format("Wrong debugger version. Remote version: %s Current build: %s", remoteVersion, currentBuild));
            this.printToConsole("Warning: wrong debugger version. Use pycharm-debugger.egg from PyCharm installation folder.\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public void printToConsole(String text2, ConsoleViewContentType contentType) {
        ((ConsoleView)this.myExecutionConsole).print(text2, contentType);
    }

    private void registerBreakpoints() {
        this.registerLineBreakpoints();
        this.registerExceptionBreakpoints();
    }

    private void registerExceptionBreakpoints() {
        for (XBreakpoint<? extends ExceptionBreakpointProperties> bp : this.myRegisteredExceptionBreakpoints.values()) {
            this.addExceptionBreakpoint(bp);
        }
    }

    public void registerLineBreakpoints() {
        for (Map.Entry<PySourcePosition, XLineBreakpoint> entry : this.myRegisteredBreakpoints.entrySet()) {
            this.addBreakpoint(entry.getKey(), entry.getValue());
        }
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            PyDebugProcess.$$$reportNull$$$0(13);
        }
        if (topToolbar == null) {
            PyDebugProcess.$$$reportNull$$$0(14);
        }
        if (settings == null) {
            PyDebugProcess.$$$reportNull$$$0(15);
        }
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        settings.add((AnAction)new WatchReturnValuesAction(this));
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(this));
        settings.add((AnAction)new PyVariableViewSettings.VariablesPolicyGroup());
    }

    public void setShowReturnValues(boolean showReturnValues) {
        this.myDebugger.setShowReturnValues(showReturnValues);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_OVER);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_INTO);
    }

    public void startStepIntoMyCode(@Nullable XSuspendContext context) {
        if (!this.checkCanPerformCommands()) {
            return;
        }
        this.getSession().sessionResumed();
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_INTO_MY_CODE);
    }

    public void startSetNextStatement(@Nullable XSuspendContext context, @NotNull XSourcePosition sourcePosition, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (sourcePosition == null) {
            PyDebugProcess.$$$reportNull$$$0(16);
        }
        if (callback == null) {
            PyDebugProcess.$$$reportNull$$$0(17);
        }
        if (!this.checkCanPerformCommands()) {
            return;
        }
        this.dropFrameCaches();
        if (this.isConnected()) {
            String threadId = PyDebugProcess.threadIdBeforeResumeOrStep(context);
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                if (threadId == null || !threadId.equals(suspendedThread.getId())) continue;
                this.myDebugger.setNextStatement(threadId, sourcePosition, this.getFunctionName(sourcePosition), callback);
                break;
            }
        }
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.passToCurrentThread(context, ResumeOrStepCommand.Mode.STEP_OUT);
    }

    public void startSmartStepInto(String functionName) {
        this.dropFrameCaches();
        if (this.isConnected()) {
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                this.myDebugger.smartStepInto(suspendedThread.getId(), functionName);
            }
        }
    }

    public void stop() {
        this.myDebugger.close();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.passToAllThreads(ResumeOrStepCommand.Mode.RESUME);
    }

    public void startPausing() {
        if (this.isConnected()) {
            this.myDebugger.suspendAllThreads();
        }
    }

    public void suspendAllOtherThreads(PyThreadInfo thread) {
        this.myDebugger.suspendOtherThreads(thread);
    }

    public boolean isSuspendedOnAllThreadsPolicy() {
        if (this.getSession().isSuspended()) {
            for (PyThreadInfo threadInfo : this.getThreads()) {
                String exceptionName;
                List frames = threadInfo.getFrames();
                if (threadInfo.getState() != PyThreadInfo.State.SUSPENDED || frames == null) continue;
                XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint = null;
                if (threadInfo.isStopOnBreakpoint()) {
                    PySourcePosition position = ((PyStackFrameInfo)frames.get(0)).getPosition();
                    breakpoint = (XBreakpoint<? extends ExceptionBreakpointProperties>)this.myRegisteredBreakpoints.get(position);
                } else if (threadInfo.isExceptionBreak() && (exceptionName = threadInfo.getMessage()) != null) {
                    breakpoint = this.myRegisteredExceptionBreakpoints.get(exceptionName);
                }
                if (breakpoint == null || !breakpoint.getType().isSuspendThreadSupported() || breakpoint.getSuspendPolicy() != SuspendPolicy.ALL) continue;
                return true;
            }
        }
        return false;
    }

    private void passToAllThreads(ResumeOrStepCommand.Mode mode) {
        this.dropFrameCaches();
        if (this.isConnected()) {
            for (PyThreadInfo thread : this.myDebugger.getThreads()) {
                this.myDebugger.resumeOrStep(thread.getId(), mode);
            }
        }
    }

    private void passToCurrentThread(@Nullable XSuspendContext context, ResumeOrStepCommand.Mode mode) {
        this.dropFrameCaches();
        if (this.isConnected()) {
            String threadId = PyDebugProcess.threadIdBeforeResumeOrStep(context);
            for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                if (threadId != null && !threadId.equals(suspendedThread.getId())) continue;
                this.myDebugger.resumeOrStep(suspendedThread.getId(), mode);
                break;
            }
        }
    }

    @Nullable
    private static String threadIdBeforeResumeOrStep(@Nullable XSuspendContext context) {
        if (context instanceof PySuspendContext) {
            return ((PySuspendContext)context).getActiveExecutionStack().getThreadId();
        }
        return null;
    }

    protected boolean isConnected() {
        return this.myDebugger.isConnected();
    }

    protected void disconnect() {
        this.myDebugger.disconnect();
        this.cleanUp();
    }

    public boolean isDownloadSources() {
        return this.myDownloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.myDownloadSources = downloadSources;
    }

    protected void cleanUp() {
        this.mySuspendedThreads.clear();
        this.myDownloadSources = false;
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            PyDebugProcess.$$$reportNull$$$0(18);
        }
        this.dropFrameCaches();
        if (this.isConnected() && !this.mySuspendedThreads.isEmpty()) {
            PySourcePosition pyPosition = this.myPositionConverter.convertToPython(position);
            String type = (String)ReadAction.compute(() -> {
                if (position == null) {
                    PyDebugProcess.$$$reportNull$$$0(39);
                }
                String t = "python-line";
                Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
                if (document != null) {
                    for (XBreakpointType breakpointType : XBreakpointType.EXTENSION_POINT_NAME.getExtensionList()) {
                        if (!(breakpointType instanceof PyBreakpointType) || !((PyBreakpointType)breakpointType).canPutInDocument(this.getSession().getProject(), document)) continue;
                        t = breakpointType.getId();
                        break;
                    }
                }
                return t;
            });
            this.myDebugger.setTempBreakpoint(type, pyPosition.getFile(), pyPosition.getLine());
            this.passToCurrentThread(context, ResumeOrStepCommand.Mode.RESUME);
        }
    }

    public PyDebugValue evaluate(String expression, boolean execute, boolean doTrunc) throws PyDebuggerException {
        this.dropFrameCaches();
        PyStackFrame frame = this.currentFrame();
        return this.evaluate(expression, execute, frame, doTrunc);
    }

    private PyDebugValue evaluate(String expression, boolean execute, PyStackFrame frame, boolean trimResult) throws PyDebuggerException {
        return this.myDebugger.evaluate(frame.getThreadId(), frame.getFrameId(), expression, execute, trimResult);
    }

    public void consoleExec(String command, PyDebugCallback<String> callback) {
        this.dropFrameCaches();
        try {
            PyStackFrame frame = this.currentFrame();
            this.myDebugger.consoleExec(frame.getThreadId(), frame.getFrameId(), command, callback);
        }
        catch (PyDebuggerException e) {
            callback.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentFrameCached() {
        try {
            Object object = this.myFrameCacheObject;
            synchronized (object) {
                PyStackFrame frame = this.currentFrame();
                return this.myStackFrameCache.containsKey(frame.getThreadFrameId());
            }
        }
        catch (PyDebuggerException pyDebuggerException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XValueChildrenList loadFrame() throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        Object object = this.myFrameCacheObject;
        synchronized (object) {
            if (!this.myStackFrameCache.containsKey(frame.getThreadFrameId())) {
                XValueChildrenList values = this.myDebugger.loadFrame(frame.getThreadId(), frame.getFrameId());
                this.myStackFrameCache.put(frame.getThreadFrameId(), values);
            }
        }
        return this.applyNewValue(this.myStackFrameCache.get(frame.getThreadFrameId()), frame.getThreadFrameId());
    }

    public void loadAsyncVariablesValues(@NotNull List<PyFrameAccessor.PyAsyncValue<String>> pyAsyncValues) {
        if (pyAsyncValues == null) {
            PyDebugProcess.$$$reportNull$$$0(19);
        }
        PyDebugValueExecutionService.getInstance((Project)this.getProject()).submitTask((PyFrameAccessor)this, () -> {
            block7: {
                if (pyAsyncValues == null) {
                    PyDebugProcess.$$$reportNull$$$0(38);
                }
                try {
                    if (!this.isConnected()) break block7;
                    PyStackFrame frame = this.currentFrame();
                    XSuspendContext context = this.getSession().getSuspendContext();
                    String threadId = PyDebugProcess.threadIdBeforeResumeOrStep(context);
                    for (PyThreadInfo suspendedThread : this.mySuspendedThreads) {
                        if (threadId != null && !threadId.equals(suspendedThread.getId())) continue;
                        this.myDebugger.loadFullVariableValues(frame.getThreadId(), frame.getFrameId(), pyAsyncValues);
                        break;
                    }
                }
                catch (PyDebuggerException e) {
                    if (!this.isConnected()) {
                        return;
                    }
                    for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                        PyDebugValue value = asyncValue.getDebugValue();
                        XValueNode node = value.getLastNode();
                        if (node == null || node.isObsolete()) continue;
                        if (e.getMessage().startsWith("Timeout")) {
                            value.updateNodeValueAfterLoading(node, " ", "", "Loading timed out");
                            PyVariableViewSettings.showWarningMessage(this.getCurrentRootNode());
                            continue;
                        }
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
    }

    private XValueChildrenList applyNewValue(XValueChildrenList pyDebugValues, String threadFrameId) {
        if (this.myNewVariableValue.containsKey(threadFrameId)) {
            PyDebugValue newValue = this.myNewVariableValue.get(threadFrameId);
            XValueChildrenList res = new XValueChildrenList();
            for (int i = 0; i < pyDebugValues.size(); ++i) {
                String name = pyDebugValues.getName(i);
                if (name.equals(newValue.getName())) {
                    res.add(name, (XValue)newValue);
                    continue;
                }
                res.add(name, pyDebugValues.getValue(i));
            }
            return res;
        }
        return pyDebugValues;
    }

    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        PyDebugValue debugValue = new PyDebugValue(var, var.getFullName());
        return this.myDebugger.loadVariable(frame.getThreadId(), frame.getFrameId(), debugValue);
    }

    public void loadReferrers(PyReferringObjectsValue var, PyDebugCallback<XValueChildrenList> callback) {
        try {
            PyStackFrame frame = this.currentFrame();
            this.myDebugger.loadReferrers(frame.getThreadId(), frame.getFrameId(), var, callback);
        }
        catch (PyDebuggerException e) {
            callback.error(e);
        }
    }

    public void changeVariable(PyDebugValue var, String value) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        PyDebugValue newValue = this.myDebugger.changeVariable(frame.getThreadId(), frame.getFrameId(), var, value);
        this.myNewVariableValue.put(frame.getThreadFrameId(), newValue);
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        if (this.myReferrersProvider == null) {
            this.myReferrersProvider = new PyReferrersLoader((IPyDebugProcess)this);
        }
        return this.myReferrersProvider;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        PyStackFrame frame = this.currentFrame();
        return this.myDebugger.loadArrayItems(frame.getThreadId(), frame.getFrameId(), var, rowOffset, colOffset, rows, cols, format);
    }

    @Nullable
    public String loadSource(String path) {
        return this.myDebugger.loadSource(path);
    }

    public boolean canSaveToTemp(String name) {
        Project project = this.getSession().getProject();
        return PyDebugSupportUtils.canSaveToTemp(project, name);
    }

    public void setCurrentRootNode(@Nullable XCompositeNode currentRootNode) {
        this.myCurrentRootNode = currentRootNode;
    }

    @Nullable
    public XCompositeNode getCurrentRootNode() {
        return this.myCurrentRootNode;
    }

    @NotNull
    private PyStackFrame currentFrame() throws PyDebuggerException {
        if (!this.isConnected()) {
            throw new PyDebuggerException("Disconnected");
        }
        PyStackFrame frame = (PyStackFrame)this.getSession().getCurrentStackFrame();
        if (frame == null && this.myConsoleContextFrame != null) {
            PyStackFrame pyStackFrame = this.myConsoleContextFrame;
            if (pyStackFrame == null) {
                PyDebugProcess.$$$reportNull$$$0(20);
            }
            return pyStackFrame;
        }
        if (frame == null) {
            throw new PyDebuggerException("Process is running");
        }
        PyStackFrame pyStackFrame = frame;
        if (pyStackFrame == null) {
            PyDebugProcess.$$$reportNull$$$0(21);
        }
        return pyStackFrame;
    }

    private String getFunctionNameForBreakpoint(XLineBreakpoint breakpoint) {
        XSourcePosition sourcePosition = breakpoint.getSourcePosition();
        return sourcePosition == null ? null : this.getFunctionName(sourcePosition);
    }

    @Nullable
    private String getFunctionName(@NotNull XSourcePosition position) {
        if (position == null) {
            PyDebugProcess.$$$reportNull$$$0(22);
        }
        VirtualFile file = position.getFile();
        return (String)ReadAction.compute(() -> {
            PsiElement psiElement;
            PyFunction function;
            int breakpointLine;
            if (position == null) {
                PyDebugProcess.$$$reportNull$$$0(37);
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            Project project = this.getSession().getProject();
            if (document != null && file.getFileType() == PythonFileType.INSTANCE && (breakpointLine = position.getLine()) < document.getLineCount() && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = XDebuggerUtil.getInstance().findContextElement(file, document.getLineStartOffset(breakpointLine), project, false)), PyFunction.class)) != null) {
                return function.getName();
            }
            return null;
        });
    }

    public void addBreakpoint(PySourcePosition position, XLineBreakpoint breakpoint) {
        this.myRegisteredBreakpoints.put(position, breakpoint);
        if (this.isConnected()) {
            String conditionExpression = breakpoint.getConditionExpression() == null ? null : breakpoint.getConditionExpression().getExpression();
            String logExpression = breakpoint.getLogExpressionObject() == null ? null : breakpoint.getLogExpressionObject().getExpression();
            SuspendPolicy policy = breakpoint.getType().isSuspendThreadSupported() ? breakpoint.getSuspendPolicy() : SuspendPolicy.NONE;
            this.myDebugger.setBreakpoint(breakpoint.getType().getId(), position.getFile(), position.getLine(), conditionExpression, logExpression, this.getFunctionNameForBreakpoint(breakpoint), policy);
        }
    }

    public void addTemporaryBreakpoint(String typeId, String file, int line) {
        if (this.isConnected()) {
            this.myDebugger.setTempBreakpoint(typeId, file, line);
        }
    }

    public void removeBreakpoint(PySourcePosition position) {
        XLineBreakpoint breakpoint = this.myRegisteredBreakpoints.get(position);
        if (breakpoint != null) {
            this.myRegisteredBreakpoints.remove(position);
            if (this.isConnected()) {
                this.myDebugger.removeBreakpoint(breakpoint.getType().getId(), position.getFile(), position.getLine());
            }
        }
    }

    public void addExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint) {
        this.myRegisteredExceptionBreakpoints.put(((ExceptionBreakpointProperties)breakpoint.getProperties()).getException(), breakpoint);
        if (this.isConnected()) {
            String conditionExpression = breakpoint.getConditionExpression() == null ? null : breakpoint.getConditionExpression().getExpression();
            ((ExceptionBreakpointProperties)breakpoint.getProperties()).setCondition(conditionExpression);
            String logExpression = breakpoint.getLogExpressionObject() == null ? null : breakpoint.getLogExpressionObject().getExpression();
            ((ExceptionBreakpointProperties)breakpoint.getProperties()).setLogExpression(logExpression);
            this.myDebugger.addExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public void removeExceptionBreakpoint(XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint) {
        this.myRegisteredExceptionBreakpoints.remove(((ExceptionBreakpointProperties)breakpoint.getProperties()).getException());
        if (this.isConnected()) {
            this.myDebugger.removeExceptionBreakpoint((ExceptionBreakpointCommandFactory)breakpoint.getProperties());
        }
    }

    public Collection<PyThreadInfo> getThreads() {
        return this.myDebugger.getThreads();
    }

    public void threadSuspended(PyThreadInfo threadInfo, boolean updateSourcePosition) {
        if (!this.mySuspendedThreads.contains(threadInfo)) {
            this.mySuspendedThreads.add(threadInfo);
            List frames = threadInfo.getFrames();
            if (frames != null) {
                PySuspendContext suspendContext = this.createSuspendContext(threadInfo);
                XBreakpoint<? extends ExceptionBreakpointProperties> breakpoint = null;
                if (threadInfo.isStopOnBreakpoint()) {
                    PySourcePosition position = ((PyStackFrameInfo)frames.get(0)).getPosition();
                    breakpoint = (XBreakpoint<? extends ExceptionBreakpointProperties>)this.myRegisteredBreakpoints.get(position);
                    if (breakpoint == null) {
                        this.myDebugger.removeTempBreakpoint(position.getFile(), position.getLine());
                    }
                } else if (threadInfo.isExceptionBreak()) {
                    String exceptionName = threadInfo.getMessage();
                    threadInfo.setMessage(null);
                    if (exceptionName != null) {
                        breakpoint = this.myRegisteredExceptionBreakpoints.get(exceptionName);
                    }
                }
                if (breakpoint != null && breakpoint.getType().isSuspendThreadSupported() && breakpoint.getSuspendPolicy() == SuspendPolicy.ALL) {
                    this.suspendAllOtherThreads(threadInfo);
                }
                if (updateSourcePosition) {
                    if (breakpoint != null) {
                        if (!this.getSession().breakpointReached((XBreakpoint)breakpoint, threadInfo.getMessage(), (XSuspendContext)suspendContext)) {
                            this.resume(suspendContext);
                        }
                    } else {
                        this.getSession().positionReached((XSuspendContext)suspendContext);
                    }
                }
            }
        }
    }

    @NotNull
    protected PySuspendContext createSuspendContext(PyThreadInfo threadInfo) {
        PySuspendContext pySuspendContext = new PySuspendContext(this, threadInfo);
        if (pySuspendContext == null) {
            PyDebugProcess.$$$reportNull$$$0(23);
        }
        return pySuspendContext;
    }

    public void threadResumed(PyThreadInfo threadInfo) {
        this.mySuspendedThreads.remove(threadInfo);
    }

    private void dropFrameCaches() {
        this.myStackFrameCache.clear();
        this.myNewVariableValue.clear();
        PyDebugValueExecutionService.getInstance((Project)this.getProject()).cancelSubmittedTasks((PyFrameAccessor)this);
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String prefix) throws Exception {
        if (this.isConnected()) {
            PyStackFrame frame = this.currentFrame();
            List list = this.myDebugger.getCompletions(frame.getThreadId(), frame.getFrameId(), prefix);
            if (list == null) {
                PyDebugProcess.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            PyDebugProcess.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public String getDescription(String prefix) throws Exception {
        if (this.isConnected()) {
            PyStackFrame frame = this.currentFrame();
            String string = this.myDebugger.getDescription(frame.getThreadId(), frame.getFrameId(), prefix);
            if (string == null) {
                PyDebugProcess.$$$reportNull$$$0(26);
            }
            return string;
        }
        if ("" == null) {
            PyDebugProcess.$$$reportNull$$$0(27);
        }
        return "";
    }

    public void startNotified(@NotNull ProcessEvent event) {
        if (event == null) {
            PyDebugProcess.$$$reportNull$$$0(28);
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            PyDebugProcess.$$$reportNull$$$0(29);
        }
        this.myDebugger.close();
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        if (event == null) {
            PyDebugProcess.$$$reportNull$$$0(30);
        }
        this.myClosing = true;
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            PyDebugProcess.$$$reportNull$$$0(31);
        }
        if (outputType == null) {
            PyDebugProcess.$$$reportNull$$$0(32);
        }
    }

    public PyStackFrame createStackFrame(PyStackFrameInfo frameInfo) {
        return new PyStackFrame(this.getSession().getProject(), (PyFrameAccessor)this, frameInfo, this.getPositionConverter().convertFromPython(frameInfo.getPosition(), frameInfo.getName()));
    }

    public String getCurrentStateMessage() {
        if (this.getSession().isStopped()) {
            return XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
        }
        if (this.isConnected()) {
            return XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
        }
        return this.getConnectionMessage();
    }

    public void addProcessListener(ProcessListener listener2) {
        ProcessHandler handler = this.doGetProcessHandler();
        if (handler != null) {
            handler.addProcessListener(listener2);
        }
    }

    public boolean isWaitingForConnection() {
        return this.myWaitingForConnection;
    }

    public void setWaitingForConnection(boolean waitingForConnection) {
        this.myWaitingForConnection = waitingForConnection;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    @Nullable
    private XSourcePosition getCurrentFrameSourcePosition() {
        try {
            PyStackFrame frame = this.currentFrame();
            return frame.getSourcePosition();
        }
        catch (PyDebuggerException e) {
            return null;
        }
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    @Nullable
    public XSourcePosition getSourcePositionForName(String name, String parentType) {
        if (name == null) {
            return null;
        }
        XSourcePosition currentPosition = this.getCurrentFrameSourcePosition();
        PsiFile file = this.getPsiFile(currentPosition);
        if (file == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)parentType)) {
            Ref<PsiElement> elementRef = PyDebugProcess.resolveInCurrentFrame(name, currentPosition, file);
            return elementRef.isNull() ? null : XDebuggerUtil.getInstance().createPositionByElement((PsiElement)elementRef.get());
        }
        PyType parentDef = this.resolveTypeFromString(parentType, file);
        if (parentDef == null) {
            return null;
        }
        List<? extends RatedResolveResult> results = parentDef.resolveMember(name, null, AccessDirection.READ, PyResolveContext.noImplicits());
        if (results != null && !results.isEmpty()) {
            return XDebuggerUtil.getInstance().createPositionByElement(results.get(0).getElement());
        }
        return PyDebugProcess.typeToPosition(parentDef);
    }

    @NotNull
    private static Ref<PsiElement> resolveInCurrentFrame(final String name, XSourcePosition currentPosition, PsiFile file) {
        final Ref elementRef = Ref.create();
        PsiElement currentElement = file.findElementAt(currentPosition.getOffset());
        if (currentElement == null) {
            Ref ref = elementRef;
            if (ref == null) {
                PyDebugProcess.$$$reportNull$$$0(33);
            }
            return ref;
        }
        PyResolveUtil.scopeCrawlUp(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (element instanceof PyImportElement) {
                    PyImportElement importElement = (PyImportElement)element;
                    if (name.equals(importElement.getVisibleName())) {
                        if (elementRef.isNull()) {
                            elementRef.set((Object)element);
                        }
                        return false;
                    }
                    return true;
                }
                if (elementRef.isNull()) {
                    elementRef.set((Object)element);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/debugger/PyDebugProcess$6";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, currentElement, name, null);
        Ref ref = elementRef;
        if (ref == null) {
            PyDebugProcess.$$$reportNull$$$0(34);
        }
        return ref;
    }

    @Nullable
    private PsiFile getPsiFile(XSourcePosition currentPosition) {
        if (currentPosition == null) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(currentPosition.getFile());
    }

    @Nullable
    public XSourcePosition getSourcePositionForType(String typeName) {
        XSourcePosition currentPosition = this.getCurrentFrameSourcePosition();
        PsiFile file = this.getPsiFile(currentPosition);
        if (typeName == null || !(file instanceof PyFile)) {
            return null;
        }
        PyType pyType = this.resolveTypeFromString(typeName, file);
        return pyType == null ? null : PyDebugProcess.typeToPosition(pyType);
    }

    public void showNumericContainer(@NotNull PyDebugValue value) {
        if (value == null) {
            PyDebugProcess.$$$reportNull$$$0(35);
        }
        PyViewNumericContainerAction.showNumericViewer(this.getProject(), value);
    }

    public void addFrameListener(@NotNull PyFrameListener listener2) {
        if (listener2 == null) {
            PyDebugProcess.$$$reportNull$$$0(36);
        }
        this.myFrameListeners.add(listener2);
    }

    @Nullable
    private static XSourcePosition typeToPosition(PyType pyType) {
        PyClassType classType = PyUtil.as(pyType, PyClassType.class);
        if (classType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)classType.getPyClass());
        }
        PyModuleType moduleType = PyUtil.as(pyType, PyModuleType.class);
        if (moduleType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)moduleType.getModule());
        }
        return null;
    }

    private PyType resolveTypeFromString(String typeName, PsiFile file) {
        typeName = typeName.replace("__builtin__.", "");
        PyType pyType = null;
        if (!typeName.contains(".")) {
            pyType = PyTypeParser.getTypeByName((PsiElement)file, typeName);
        }
        if (pyType == null) {
            PyElementGenerator generator = PyElementGenerator.getInstance(this.getProject());
            PyPsiFacade psiFacade = PyPsiFacade.getInstance(this.getProject());
            PsiFile dummyFile = generator.createDummyFile(((PyFile)file).getLanguageLevel(), "");
            Module moduleForFile = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)moduleForFile);
            pyType = psiFacade.parseTypeAnnotation(typeName, (PsiElement)dummyFile);
        }
        return pyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSocket";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 5: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverHost";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerFactory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebugProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 18: 
            case 22: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 19: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyAsyncValues";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebugProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "currentFrame";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuspendContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInCurrentFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteTunneledPort";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startSetNextStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadAsyncVariablesValues";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "startNotified";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processTerminated";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processWillTerminate";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onTextAvailable";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showNumericContainer";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addFrameListener";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFunctionName$6";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadAsyncVariablesValues$5";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runToPosition$4";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface DebuggerFactory {
        @NotNull
        public ProcessDebugger createDebugger(@NotNull PyDebugProcess var1);
    }

    private static class WatchReturnValuesAction
    extends ToggleAction {
        private volatile boolean myWatchesReturnValues;
        private final PyDebugProcess myProcess;
        private final String myText;

        WatchReturnValuesAction(@NotNull PyDebugProcess debugProcess) {
            if (debugProcess == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(0);
            }
            super("", "Enables watching executed functions return values", null);
            this.myWatchesReturnValues = PyDebuggerSettings.getInstance().isWatchReturnValues();
            this.myProcess = debugProcess;
            this.myText = "Show Return Values";
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
            presentation.setText(this.myText);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(2);
            }
            return this.myWatchesReturnValues;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean watch) {
            if (e == null) {
                WatchReturnValuesAction.$$$reportNull$$$0(3);
            }
            this.myWatchesReturnValues = watch;
            PyDebuggerSettings.getInstance().setWatchReturnValues(watch);
            Project project = e.getProject();
            if (project != null) {
                this.myProcess.setShowReturnValues(this.myWatchesReturnValues);
                this.myProcess.getSession().rebuildViews();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/debugger/PyDebugProcess$WatchReturnValuesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

