/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.CharMatcher;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IJSwingUtilities;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.parsing.PythonConsoleData;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConsoleUtil {
    public static final String ORDINARY_PROMPT = ">>>";
    public static final String INPUT_PROMPT = ">?";
    public static final String INDENT_PROMPT = "...";
    public static final String IPYTHON_INDENT_PROMPT = "...:";
    public static final String HELP_PROMPT = "help>";
    public static final String EXECUTING_PROMPT = "";
    private static final String IPYTHON_PAGING_PROMPT = "---Return to continue, q to quit---";
    static final String[] PROMPTS = new String[]{">>>", "...", "help>", "---Return to continue, q to quit---"};
    static final Key<PythonConsoleData> PYTHON_CONSOLE_DATA = Key.create((String)"python-console-data");

    private PyConsoleUtil() {
    }

    public static boolean isPagingPrompt(@Nullable String prompt) {
        return prompt != null && IPYTHON_PAGING_PROMPT.equals(prompt.trim());
    }

    static String processPrompts(LanguageConsoleView languageConsole, String string) {
        for (String prompt : PROMPTS) {
            if (!string.startsWith(prompt)) continue;
            if (prompt != HELP_PROMPT) {
                StringBuilder builder = new StringBuilder();
                builder.append(prompt).append(prompt);
                while (string.startsWith(builder.toString())) {
                    builder.append(prompt);
                }
                String multiPrompt = builder.toString().substring(prompt.length());
                if (prompt == INDENT_PROMPT) {
                    prompt = multiPrompt;
                }
                string = string.substring(multiPrompt.length());
            } else {
                string = string.substring(prompt.length());
            }
            String currentPrompt = languageConsole.getPrompt();
            String trimmedPrompt = prompt.trim();
            if (currentPrompt == null || currentPrompt.equals(trimmedPrompt)) break;
            languageConsole.setPrompt(trimmedPrompt);
            PyConsoleUtil.scrollDown((Editor)languageConsole.getConsoleEditor());
            break;
        }
        return string;
    }

    public static void scrollDown(Editor currentEditor) {
        ApplicationManager.getApplication().invokeLater(() -> currentEditor.getCaretModel().moveToOffset(currentEditor.getDocument().getTextLength()));
    }

    public static boolean detectIPythonImported(@NotNull String text2, ConsoleViewContentType outputType) {
        if (text2 == null) {
            PyConsoleUtil.$$$reportNull$$$0(0);
        }
        return text2.contains("PyDev console: using IPython ");
    }

    public static boolean detectSourcePrinting(@NotNull String text2) {
        if (text2 == null) {
            PyConsoleUtil.$$$reportNull$$$0(1);
        }
        return text2.contains("Source:");
    }

    public static boolean detectIPythonStart(@NotNull String text2) {
        if (text2 == null) {
            PyConsoleUtil.$$$reportNull$$$0(2);
        }
        return text2.contains("IPython-->");
    }

    public static boolean detectIPythonEnd(@NotNull String text2) {
        if (text2 == null) {
            PyConsoleUtil.$$$reportNull$$$0(3);
        }
        return text2.contains("<--IPython");
    }

    public static boolean detectIPythonAutomagicOn(@NotNull String text2) {
        if (text2 == null) {
            PyConsoleUtil.$$$reportNull$$$0(4);
        }
        return text2.contains("Automagic is ON, % prefix NOT needed for magic functions.");
    }

    public static boolean detectIPythonAutomagicOff(@NotNull String text2) {
        if (text2 == null) {
            PyConsoleUtil.$$$reportNull$$$0(5);
        }
        return text2.contains("Automagic is OFF, % prefix IS needed for magic functions.");
    }

    public static void markIPython(@NotNull VirtualFile file) {
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(6);
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIPythonEnabled(true);
    }

    @NotNull
    public static PythonConsoleData getOrCreateIPythonData(@NotNull VirtualFile file) {
        PythonConsoleData consoleData;
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(7);
        }
        if ((consoleData = (PythonConsoleData)file.getUserData(PYTHON_CONSOLE_DATA)) == null) {
            consoleData = new PythonConsoleData();
            file.putUserData(PYTHON_CONSOLE_DATA, (Object)consoleData);
        }
        PythonConsoleData pythonConsoleData = consoleData;
        if (pythonConsoleData == null) {
            PyConsoleUtil.$$$reportNull$$$0(8);
        }
        return pythonConsoleData;
    }

    public static void setIPythonAutomagic(@NotNull VirtualFile file, boolean detected) {
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(9);
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIPythonAutomagic(detected);
    }

    public static void setCurrentIndentSize(@NotNull VirtualFile file, int indentSize) {
        if (file == null) {
            PyConsoleUtil.$$$reportNull$$$0(10);
        }
        PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(file);
        consoleData.setIndentSize(indentSize);
    }

    public static AnAction createTabCompletionAction(final PythonConsoleView consoleView) {
        AnAction runCompletions = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                EditorEx editor;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LookupManager.getActiveLookup((Editor)(editor = consoleView.getConsoleEditor())) != null) {
                    AnAction replace = ActionManager.getInstance().getAction("EditorChooseLookupItemReplace");
                    ActionUtil.performActionDumbAware((AnAction)replace, (AnActionEvent)e);
                    return;
                }
                AnAction completionAction = ActionManager.getInstance().getAction("CodeCompletion");
                if (completionAction != null) {
                    ActionUtil.performActionDumbAware((AnAction)completionAction, (AnActionEvent)e);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                EditorEx editor;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (LookupManager.getActiveLookup((Editor)(editor = consoleView.getConsoleEditor())) != null) {
                    e.getPresentation().setEnabled(false);
                }
                int offset = editor.getCaretModel().getOffset();
                Document document = editor.getDocument();
                int lineStart = document.getLineStartOffset(document.getLineNumber(offset));
                String textToCursor = document.getText(new TextRange(lineStart, offset));
                e.getPresentation().setEnabled(!CharMatcher.WHITESPACE.matchesAllOf((CharSequence)textToCursor));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        runCompletions.registerCustomShortcutSet(9, 0, consoleView.getConsoleEditor().getComponent());
        runCompletions.getTemplatePresentation().setVisible(false);
        return runCompletions;
    }

    public static AnAction createInterruptAction(final PythonConsoleView consoleView) {
        AnAction anAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ConsoleCommunication consoleCommunication;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((consoleCommunication = consoleView.getExecuteActionHandler().getConsoleCommunication()).isExecuting() || consoleCommunication.isWaitingForInput()) {
                    consoleView.print("^C", ProcessOutputTypes.SYSTEM);
                    consoleCommunication.interrupt();
                } else {
                    DocumentEx document = consoleView.getConsoleEditor().getDocument();
                    if (document.getTextLength() != 0) {
                        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> document.deleteString(0, document.getLineEndOffset(document.getLineCount() - 1))));
                    }
                }
            }

            public void update(@NotNull AnActionEvent e) {
                EditorEx consoleEditor;
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                boolean enabled = IJSwingUtilities.hasFocus((Component)(consoleEditor = consoleView.getConsoleEditor()).getComponent()) && !consoleEditor.getSelectionModel().hasSelection();
                e.getPresentation().setEnabled(enabled);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        anAction.registerCustomShortcutSet(67, 2, consoleView.getConsoleEditor().getComponent());
        anAction.getTemplatePresentation().setVisible(false);
        return anAction;
    }

    public static AnAction createScrollToEndAction(@NotNull Editor editor) {
        if (editor == null) {
            PyConsoleUtil.$$$reportNull$$$0(11);
        }
        return new ScrollToTheEndToolbarAction(editor);
    }

    private static AnActionEvent createActionEvent(@NotNull AnActionEvent e, PythonConsoleView consoleView) {
        if (e == null) {
            PyConsoleUtil.$$$reportNull$$$0(12);
        }
        ConsoleDataContext dataContext = new ConsoleDataContext(e.getDataContext(), consoleView);
        return new AnActionEvent(e.getInputEvent(), (DataContext)dataContext, e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
    }

    public static AnAction createPrintAction(final PythonConsoleView consoleView) {
        final AnAction printAction = ActionManager.getInstance().getAction("Print");
        DumbAwareAction newPrintAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                printAction.update(PyConsoleUtil.createActionEvent(e, consoleView));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                printAction.actionPerformed(PyConsoleUtil.createActionEvent(e, consoleView));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        newPrintAction.copyFrom(printAction);
        return newPrintAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PyConsoleUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIPythonData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonImported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "detectSourcePrinting";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonStart";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonEnd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonAutomagicOn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectIPythonAutomagicOff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markIPython";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateIPythonData";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIPythonAutomagic";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentIndentSize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createScrollToEndAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createActionEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConsoleDataContext
    implements DataContext {
        private final DataContext myOriginalDataContext;
        private final PythonConsoleView myConsoleView;

        ConsoleDataContext(DataContext dataContext, PythonConsoleView consoleView) {
            this.myOriginalDataContext = dataContext;
            this.myConsoleView = consoleView;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ConsoleDataContext.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return this.myConsoleView.getEditor();
            }
            return this.myOriginalDataContext.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/jetbrains/python/console/PyConsoleUtil$ConsoleDataContext", "getData"));
        }
    }
}

