/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CreateTestDialog
extends DialogWrapper {
    private TextFieldWithBrowseButton myTargetDir;
    private JTextField myClassName;
    private JPanel myMainPanel;
    private JTextField myFileName;
    private JTable myMethodsTable;
    private DefaultTableModel myTableModel;

    protected CreateTestDialog(Project project) {
        super(project);
        this.$$$setupUI$$$();
        this.init();
        this.myTargetDir.addBrowseFolderListener("Select target directory", null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myTargetDir.setEditable(false);
        this.myTargetDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTestDialog.this.getOKAction().setEnabled(CreateTestDialog.this.isValid());
            }
        });
        this.setTitle("Create test");
        this.addUpdater(this.myFileName);
        this.addUpdater(this.myClassName);
    }

    public void methodsSize(int methods) {
        this.myTableModel = new DefaultTableModel(methods, 2);
        this.myMethodsTable.setModel(this.myTableModel);
        TableColumn checkColumn = this.myMethodsTable.getColumnModel().getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkColumn);
        checkColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        checkColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.myMethodsTable.getColumnModel().getColumn(1).setHeaderValue("Test method");
        checkColumn.setHeaderValue("");
        this.getOKAction().setEnabled(true);
    }

    protected void addUpdater(JTextField field) {
        field.getDocument().addDocumentListener(new MyDocumentListener());
    }

    private boolean isValid() {
        return !StringUtil.isEmptyOrSpaces((String)this.getTargetDir()) && !StringUtil.isEmptyOrSpaces((String)this.getClassName()) && !StringUtil.isEmptyOrSpaces((String)this.getFileName());
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public String getTargetDir() {
        return this.myTargetDir.getText().trim();
    }

    public void setTargetDir(String text2) {
        this.myTargetDir.setText(text2);
    }

    public void setClassName(String text2) {
        this.myClassName.setText(text2);
    }

    public void setFileName(String text2) {
        this.myFileName.setText(text2);
    }

    public String getClassName() {
        return this.myClassName.getText().trim();
    }

    public String getFileName() {
        return this.myFileName.getText().trim();
    }

    public void addMethod(String name, int row) {
        this.myTableModel.setValueAt(name, row, 1);
        this.myTableModel.setValueAt(Boolean.FALSE, row, 0);
    }

    public List<String> getMethods() {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i != this.myTableModel.getRowCount(); ++i) {
            Object val = this.myTableModel.getValueAt(i, 0);
            if (val == null || !((Boolean)val).booleanValue()) continue;
            res.add((String)this.myTableModel.getValueAt(i, 1));
        }
        return res;
    }

    protected String getHelpId() {
        return "reference.dialogs.createTestsFromGoTo";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myTargetDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Target directory");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Test class name");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Test file name");
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 0, 0, 3, 3, null, null, null));
        JBTable jBTable = new JBTable();
        this.myMethodsTable = jBTable;
        jBTable.setShowVerticalLines(true);
        jBTable.setUpdateSelectionOnSort(false);
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CreateTestDialog.this.getOKAction().setEnabled(CreateTestDialog.this.isValid());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CreateTestDialog.this.getOKAction().setEnabled(CreateTestDialog.this.isValid());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            CreateTestDialog.this.getOKAction().setEnabled(CreateTestDialog.this.isValid());
        }
    }
}

