/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.doc;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.doc.TaskPsiElement;
import com.intellij.xml.util.XmlStringUtil;
import com.petebevin.markdown.MarkdownProcessor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TaskDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationProvider {
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String url;
        if (element instanceof TaskPsiElement && (url = ((TaskPsiElement)element).getTask().getIssueUrl()) != null) {
            return Collections.singletonList(url);
        }
        return null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String description;
        if (!(element instanceof TaskPsiElement)) {
            return null;
        }
        Task task = ((TaskPsiElement)element).getTask();
        StringBuilder builder = new StringBuilder();
        builder.append("<b>Summary:</b> ").append(task.getSummary()).append("<br>");
        builder.append("<b>Id:</b> ").append(task.getPresentableId()).append("<br>");
        if (task.getCreated() != null) {
            builder.append("<b>Created at:</b> ").append(task.getCreated()).append("<br>");
        }
        if (task.getUpdated() != null) {
            builder.append("<b>Updated at:</b> ").append(task.getUpdated()).append("<br>");
        }
        if ((description = task.getDescription()) != null) {
            MarkdownProcessor processor = new MarkdownProcessor();
            builder.append("<b>Description:</b><br>").append(processor.markdown(description));
        }
        for (Comment comment : task.getComments()) {
            comment.appendTo(builder);
        }
        return XmlStringUtil.wrapInHtml((CharSequence)builder);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return object instanceof Task ? new TaskPsiElement(psiManager, (Task)object) : null;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return element instanceof TaskPsiElement;
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }
}

