/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgHistoryProvider;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.MercurialInterceptor;
import org.netbeans.modules.mercurial.MercurialVCS;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.kenai.HgKenaiAccessor;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.shelve.ShelveChangesAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.RootsToFile;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class Mercurial {
    public static final int HG_FETCH_20_REVISIONS = 20;
    public static final int HG_FETCH_50_REVISIONS = 50;
    public static final int HG_FETCH_ALL_REVISIONS = -1;
    public static final int HG_NUMBER_FETCH_OPTIONS = 3;
    public static final int HG_NUMBER_TO_FETCH_DEFAULT = 7;
    public static final int HG_MAX_REVISION_COMBO_SIZE = 10;
    public static final String MERCURIAL_OUTPUT_TAB_TITLE = NbBundle.getMessage(Mercurial.class, (String)"CTL_Mercurial_DisplayName");
    public static final String CHANGESET_STR = "changeset:";
    public static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    public static final String PROP_CHANGESET_CHANGED = "changesetChanged";
    static final String PROP_HEAD_CHANGED = "headChanged";
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial");
    public static final Logger STATUS_LOG = Logger.getLogger("org.netbeans.modules.mercurial.status");
    private static final int STATUS_DIFFABLE = 1272;
    private static final String MERCURIAL_SUPPORTED_VERSION_093 = "0.9.3";
    private static final String MERCURIAL_SUPPORTED_VERSION_094 = "0.9.4";
    private static final String MERCURIAL_SUPPORTED_VERSION_095 = "0.9.5";
    private static final String MERCURIAL_SUPPORTED_VERSION_100 = "1.0";
    private static Mercurial instance;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private RootsToFile rootsToFile;
    private MercurialAnnotator mercurialAnnotator;
    private MercurialInterceptor mercurialInterceptor;
    private HgHistoryProvider historyProvider;
    private FileStatusCache fileStatusCache;
    private HashMap<HgURL, RequestProcessor> processorsToUrl;
    private boolean goodVersion;
    private String version;
    private boolean gotVersion;
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private RequestProcessor parallelRP;
    private Set<File> knownRoots = Collections.synchronizedSet(new HashSet());
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));

    public static synchronized Mercurial getInstance() {
        if (instance == null) {
            instance = new Mercurial();
            instance.init();
        }
        return instance;
    }

    private Mercurial() {
    }

    private void init() {
        int statisticsFrequency;
        this.setDefaultPath();
        this.fileStatusCache = new FileStatusCache(this);
        this.mercurialAnnotator = new MercurialAnnotator(this.fileStatusCache);
        this.mercurialInterceptor = new MercurialInterceptor(this, this.fileStatusCache);
        String s = System.getProperty("mercurial.root.stat.frequency", "0");
        try {
            statisticsFrequency = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            statisticsFrequency = 0;
        }
        this.rootsToFile = new RootsToFile(new RootsToFile.Callback(){

            public boolean repositoryExistsFor(File file) {
                return HgUtils.hgExistsFor(file);
            }

            public File getTopmostManagedAncestor(File file) {
                return Mercurial.this.getTopmostManagedAncestor(file);
            }
        }, Logger.getLogger("org.netbeans.modules.mercurial.RootsToFile"), statisticsFrequency);
        this.asyncInit();
    }

    void register(final MercurialVCS mvcs) {
        this.fileStatusCache.addPropertyChangeListener(mvcs);
        this.addPropertyChangeListener(mvcs);
        this.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (Mercurial.this.isAvailable(false, false)) {
                    ShelveChangesActionsRegistry.getInstance().registerAction((VersioningSystem)mvcs, ShelveChangesAction.getProvider());
                }
            }
        });
    }

    private void setDefaultPath() {
        String path;
        String defaultPath;
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String defaultPath2 = HgModuleConfig.getDefault().getExecutableBinaryPath();
            if (defaultPath2 == null || defaultPath2.length() == 0) {
                String[] pathNames = new String[]{"/Library/Frameworks/Python.framework/Versions/Current/bin", "/usr/bin", "/usr/local/bin", "/opt/local/bin/", "/sw/bin"};
                for (int i = 0; i < pathNames.length; ++i) {
                    if (!HgModuleConfig.getDefault().isExecPathValid(pathNames[i]).booleanValue()) continue;
                    HgModuleConfig.getDefault().setExecutableBinaryPath(pathNames[i]);
                    break;
                }
            }
        } else if (Utilities.isWindows() && ((defaultPath = HgModuleConfig.getDefault().getExecutableBinaryPath()) == null || defaultPath.length() == 0) && (path = HgUtils.findInUserPath(HgCommand.HG_WINDOWS_EXECUTABLES)) != null && !path.equals("")) {
            HgModuleConfig.getDefault().setExecutableBinaryPath(path);
        }
    }

    public void asyncInit() {
        this.gotVersion = false;
        RequestProcessor rp = this.getRequestProcessor();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Mercurial subsystem initialized", new Exception());
        }
        Runnable init = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HgKenaiAccessor.getInstance().registerVCSNoficationListener();
                Mercurial mercurial = Mercurial.this;
                synchronized (mercurial) {
                    Mercurial.this.checkVersionIntern();
                }
            }
        };
        rp.post(init);
    }

    private void checkVersionIntern() {
        this.version = HgCommand.getHgVersion();
        this.goodVersion = this.version != null ? this.isSupportedVersion(this.version) : false;
        LOG.log(this.goodVersion ? Level.FINE : Level.INFO, "version: {0}", this.version);
        this.gotVersion = true;
    }

    private boolean isSupportedVersion(String version) {
        if (version.startsWith(MERCURIAL_SUPPORTED_VERSION_093) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_094) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_095) || version.startsWith(MERCURIAL_SUPPORTED_VERSION_100)) {
            return true;
        }
        return !version.startsWith("0.");
    }

    public boolean isAvailable() {
        return this.isAvailable(false, false);
    }

    public boolean isAvailable(boolean notifyUI) {
        return this.isAvailable(false, notifyUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(boolean forceCheck, boolean notifyUI) {
        OutputLogger logger;
        Mercurial mercurial = this;
        synchronized (mercurial) {
            if (!this.gotVersion) {
                LOG.log(Level.FINE, "Call to hg version not finished");
                if (forceCheck) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "isAvailable performed", new Exception());
                    }
                    this.checkVersionIntern();
                } else {
                    return true;
                }
            }
        }
        if (this.version != null && !this.goodVersion) {
            logger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_USING_UNRECOGNIZED_VERSION_MSG", (Object)this.version));
            logger.closeLog();
            LOG.log(Level.WARNING, "Using an unsupported hg version: {0}", this.version);
            this.goodVersion = true;
        } else if (this.version == null && notifyUI) {
            logger = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_OUTPUT_MSG"));
            HgUtils.warningDialog(Mercurial.class, "MSG_VERSION_NONE_TITLE", "MSG_VERSION_NONE_MSG");
            logger.closeLog();
            LOG.warning("Hg is not available");
        }
        return this.goodVersion;
    }

    public MercurialAnnotator getMercurialAnnotator() {
        return this.mercurialAnnotator;
    }

    MercurialInterceptor getMercurialInterceptor() {
        return this.mercurialInterceptor;
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public <T> T runWithoutExternalEvents(File repository, String commandName, Callable<T> callable) throws Exception {
        return this.getMercurialInterceptor().runWithoutExternalEvents(repository, commandName, callable);
    }

    public Set<File> getSeenRoots(File repositoryRoot) {
        return this.getMercurialInterceptor().getSeenRoots(repositoryRoot);
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof MercurialVCS && !HgUtils.isPartOfMercurialMetadata(file);
    }

    public File getRepositoryRoot(File file) {
        return this.rootsToFile.getRepositoryRoot(file);
    }

    public String getMimeType(File file) {
        String foMime;
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            foMime = "content/unknown";
        } else {
            foMime = fo.getMIMEType();
            if ("content/unknown".equals(foMime)) {
                foMime = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return HgUtils.isFileContentBinary(file) ? "application/octet-stream" : foMime;
        }
        return foMime;
    }

    public void versionedFilesChanged() {
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void refreshAnnotations(Set<File> files) {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, files);
    }

    public void changesetChanged(File repository) {
        this.support.firePropertyChange(PROP_CHANGESET_CHANGED, repository, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        FileInformation info = this.fileStatusCache.getStatus(workingCopy);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getOriginalFile: {0} {1}", new Object[]{workingCopy, info});
        }
        if ((info.getStatus() & 0x4F8) == 0) {
            if ((info.getStatus() & 0x1000) != 0 && info.getStatus(null) != null && info.getStatus(null).getOriginalFile() != null) {
                workingCopy = info.getStatus(null).getOriginalFile();
            } else {
                return;
            }
        }
        try {
            File original = VersionsCache.getInstance().getFileRevision(workingCopy, HgLogMessage.HgRevision.BASE);
            if (original == null) {
                return;
            }
            Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(originalFile), (InputStream)new FileInputStream(original));
            original.delete();
        }
        catch (IOException e) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.INFO, "Unable to get original file", e);
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor((HgURL)null);
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("Mercurial.ParallelRP", 5, true);
        }
        return this.parallelRP;
    }

    public RequestProcessor getRequestProcessor(File file) {
        return this.getRequestProcessor(new HgURL(file));
    }

    public RequestProcessor getRequestProcessor(HgURL url) {
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(url)) == null) {
            String rpName = "Mercurial - " + (url != null ? url.toString() : "ANY_KEY");
            rp = new RequestProcessor(rpName, 1, true);
            this.processorsToUrl.put(url, rp);
        }
        return rp;
    }

    public void clearRequestProcessor(HgURL url) {
        if (this.processorsToUrl != null & url != null) {
            this.processorsToUrl.remove(url);
        }
    }

    public void notifyFileChanged(File file) {
        this.fileStatusCache.notifyFileChanged(file);
    }

    public OutputLogger getLogger(String repositoryRoot) {
        return OutputLogger.getLogger(repositoryRoot);
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.emptyList();
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    public String getVersion() {
        return this.version;
    }

    File getTopmostManagedAncestor(File file) {
        String homeDir;
        File parent;
        long t = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        }
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        }
        if ((parent = this.getKnownParent(file)) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  getTopmostManagedParent returning known parent " + parent);
            }
            return parent;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            while (file != null) {
                if (HgUtils.isAdministrative(file)) {
                    file = file.getParentFile();
                    this.unversionedParents.remove(file);
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<File> done = new HashSet<File>();
        File topmost = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (VersioningSupport.isExcluded((File)file)) break;
            boolean forbiddenFolder = Utils.isForbiddenFolder((File)file);
            if (!forbiddenFolder && HgUtils.hgExistsFor(file)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                }
                done.clear();
                topmost = file;
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                }
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{topmost, System.currentTimeMillis() - t});
        }
        if (topmost != null && this.knownRoots.add(topmost) && (homeDir = System.getProperty("user.home")) != null && homeDir.startsWith(topmost.getAbsolutePath())) {
            LOG.log(Level.WARNING, "Home folder {0} lies under a hg versioned root {1}.Expecting lots of performance issues.", new Object[]{homeDir, topmost});
        }
        return topmost;
    }

    private File getKnownParent(File file) {
        File[] roots = this.knownRoots.toArray(new File[this.knownRoots.size()]);
        File knownParent = null;
        for (File r : roots) {
            if (VersioningSupport.isExcluded((File)file) || !Utils.isAncestorOrEqual((File)r, (File)file) || knownParent != null && !Utils.isAncestorOrEqual((File)knownParent, (File)r)) continue;
            knownParent = r;
        }
        return knownParent;
    }

    public void clearAncestorCaches() {
        this.unversionedParents.clear();
        this.knownRoots.clear();
        this.rootsToFile.clear();
    }

    public HgHistoryProvider getMercurialHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new HgHistoryProvider();
        }
        return this.historyProvider;
    }

    public void historyChanged(File repository) {
        Set<File> openFiles = HgUtils.getOpenedFiles(repository);
        if (!openFiles.isEmpty()) {
            this.support.firePropertyChange(PROP_HEAD_CHANGED, null, openFiles);
            if (this.historyProvider != null) {
                this.historyProvider.fireHistoryChange(openFiles.toArray(new File[openFiles.size()]));
            }
        }
    }
}

