/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.cookie;

import org.apache.maven.wagon.providers.http.httpclient.annotation.Immutable;
import org.apache.maven.wagon.providers.http.httpclient.cookie.ClientCookie;
import org.apache.maven.wagon.providers.http.httpclient.cookie.Cookie;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieAttributeHandler;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieOrigin;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieRestrictionViolationException;
import org.apache.maven.wagon.providers.http.httpclient.cookie.MalformedCookieException;
import org.apache.maven.wagon.providers.http.httpclient.cookie.SetCookie;
import org.apache.maven.wagon.providers.http.httpclient.cookie.SetCookie2;
import org.apache.maven.wagon.providers.http.httpclient.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }
}

