/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.modules.htmlui.Buttons;
import org.netbeans.modules.htmlui.NbBrowsers;
import org.netbeans.modules.htmlui.NbFxPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class HTMLDialogImpl
implements Runnable {
    private static final Logger LOG = Logger.getLogger(HTMLDialogImpl.class.getName());
    private volatile int state;
    private NbFxPanel p;
    private DialogDescriptor dd;
    private WebView webView;
    private String url;
    private Runnable onPageLoad;
    private List<String> techIds = new ArrayList<String>();
    private boolean nestedLoop;
    private static final Method GET;
    private static final Method ENTER;
    private static final Method EXIT;

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOnPageLoad(Runnable onPageLoad) {
        this.onPageLoad = onPageLoad;
    }

    public void addTechIds(String[] ids) {
        this.techIds.addAll(Arrays.asList(ids));
    }

    @Override
    public void run() {
        switch (this.state) {
            case 0: {
                this.initPanel();
                break;
            }
            case 1: {
                this.initFX();
                break;
            }
            case 2: {
                this.initPage();
                if (this.nestedLoop) {
                    this.state = 3;
                    EventQueue.invokeLater(this);
                    break;
                }
                this.state = -1;
                break;
            }
            case 3: {
                this.showDialog();
                this.state = 4;
                Platform.runLater((Runnable)this);
                break;
            }
            case 4: {
                this.state = -1;
                HTMLDialogImpl.exitNestedLoop(this);
                break;
            }
            default: {
                throw new IllegalStateException("State: " + this.state);
            }
        }
    }

    public String showAndWait() {
        if (EventQueue.isDispatchThread()) {
            this.run();
            this.showDialog();
        } else if (Platform.isFxApplicationThread()) {
            this.nestedLoop = true;
            EventQueue.invokeLater(this);
            HTMLDialogImpl.enterNestedLoop(this);
        } else {
            try {
                EventQueue.invokeAndWait(this);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
            this.showDialog();
        }
        Object val = this.dd.getValue();
        return val instanceof JButton ? ((JButton)val).getName() : null;
    }

    private void showDialog() {
        this.p.setPreferredSize(new Dimension(600, 400));
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
    }

    private void initPanel() {
        this.p = new NbFxPanel();
        this.dd = new DialogDescriptor((Object)this.p, "");
        this.dd.setOptions(new Object[0]);
        this.state = 1;
        Platform.runLater((Runnable)this);
    }

    private void initFX() {
        URL pageUrl;
        Platform.setImplicitExit((boolean)false);
        this.webView = new WebView();
        BorderPane bp = new BorderPane();
        Scene scene = new Scene((Parent)bp, (Paint)Color.ALICEBLUE);
        class X
        implements ChangeListener<String>,
        Runnable {
            private String title;

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                this.title = HTMLDialogImpl.this.webView.getEngine().getTitle();
                EventQueue.invokeLater(this);
            }

            @Override
            public void run() {
                if (this.title != null) {
                    HTMLDialogImpl.this.dd.setTitle(this.title);
                }
            }
        }
        X x = new X();
        this.webView.getEngine().titleProperty().addListener((ChangeListener)x);
        Platform.runLater((Runnable)x);
        bp.setCenter((Node)this.webView);
        this.p.setScene(scene);
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = HTMLDialogImpl.class.getClassLoader();
        }
        try {
            pageUrl = new URL(this.url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        this.state = 2;
        NbBrowsers.load(this.webView, pageUrl, this, loader, this.techIds.toArray());
    }

    private void initPage() {
        try {
            this.onPageLoad.run();
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
        }
        Object[] buttons = Buttons.buttons();
        this.dd.setOptions(buttons);
    }

    public <C> C component(Class<C> type) {
        URL pageUrl;
        this.state = -1;
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = HTMLDialogImpl.class.getClassLoader();
        }
        try {
            pageUrl = new URL(this.url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        if (type == Node.class) {
            WebView wv = new WebView();
            NbBrowsers.load(wv, pageUrl, this.onPageLoad, loader, this.techIds.toArray());
            return type.cast(wv);
        }
        if (type == JComponent.class) {
            final JFXPanel tmp = new JFXPanel();
            final ClassLoader l = loader;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebView wv = new WebView();
                    NbBrowsers.load(wv, pageUrl, HTMLDialogImpl.this.onPageLoad, l, HTMLDialogImpl.this.techIds.toArray());
                    Scene s = new Scene((Parent)wv);
                    tmp.setScene(s);
                }
            });
            return type.cast(tmp);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private static void enterNestedLoop(HTMLDialogImpl impl) {
        try {
            Object tk = GET.invoke(null, new Object[0]);
            ENTER.invoke(tk, impl);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, "enterNestedEventLoop(" + impl + ")", ex);
        }
    }

    private static void exitNestedLoop(HTMLDialogImpl impl) {
        try {
            Object tk = GET.invoke(null, new Object[0]);
            EXIT.invoke(tk, impl, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, "exitNestedEventLoop(" + impl + ", null)", ex);
        }
    }

    static {
        Method g = null;
        Method n = null;
        Method x = null;
        try {
            Class<?> tC;
            String toolkitCN = "com.sun.javafx.tk.Toolkit";
            try {
                tC = Class.forName("com.sun.javafx.tk.Toolkit");
            }
            catch (ClassNotFoundException ex) {
                tC = Stage.class.getClassLoader().loadClass("com.sun.javafx.tk.Toolkit");
            }
            g = tC.getMethod("getToolkit", new Class[0]);
            n = tC.getMethod("enterNestedEventLoop", Object.class);
            x = tC.getMethod("exitNestedEventLoop", Object.class, Object.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
            LOG.log(Level.SEVERE, "Cannot initialize JavaFX Toolkit access. May cause deadlocks.", ex);
        }
        GET = g;
        ENTER = n;
        EXIT = x;
    }
}

