/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.project.libraries.ui.ALPUtils;
import org.netbeans.modules.project.libraries.ui.ProxyLibraryImplementation;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.LibraryStorageAreaCache;
import org.netbeans.spi.project.libraries.NamedLibraryImplementation;
import org.netbeans.spi.project.libraries.WritableLibraryProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class LibrariesModel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(LibrariesModel.class.getName());
    private static final Set<URL> createdAreas = Collections.synchronizedSet(new HashSet());
    private final Map<LibraryImplementation, LibraryStorageArea> library2Area = new HashMap<LibraryImplementation, LibraryStorageArea>();
    private final Map<LibraryStorageArea, ArealLibraryProvider> area2Storage = new HashMap<LibraryStorageArea, ArealLibraryProvider>();
    private final Map<LibraryImplementation, LibraryProvider> storageByLib = new HashMap<LibraryImplementation, LibraryProvider>();
    private final Map<LibraryStorageArea, LibraryProvider> area2Provider = new HashMap<LibraryStorageArea, LibraryProvider>();
    private final Collection<LibraryImplementation> actualLibraries = new TreeSet<LibraryImplementation>(new LibrariesComparator());
    private final List<LibraryImplementation> addedLibraries;
    private final List<LibraryImplementation> removedLibraries;
    private final List<ProxyLibraryImplementation> changedLibraries;
    private WritableLibraryProvider writableProvider;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    public LibrariesModel() {
        this.addedLibraries = new ArrayList<LibraryImplementation>();
        this.removedLibraries = new ArrayList<LibraryImplementation>();
        this.changedLibraries = new ArrayList<ProxyLibraryImplementation>();
        for (LibraryProvider lp : Lookup.getDefault().lookupAll(LibraryProvider.class)) {
            lp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)lp));
            if (this.writableProvider != null || !(lp instanceof WritableLibraryProvider)) continue;
            this.writableProvider = (WritableLibraryProvider)lp;
        }
        for (ArealLibraryProvider alp : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            alp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)alp));
        }
        this.computeLibraries();
    }

    public synchronized Collection<? extends LibraryImplementation> getLibraries() {
        return this.actualLibraries;
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    public LibraryStorageArea createArea() {
        for (ArealLibraryProvider alp : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            LibraryStorageArea area = alp.createArea();
            if (area == null) continue;
            createdAreas.add(area.getLocation());
            this.area2Storage.put(area, alp);
            this.propertyChange(null);
            return area;
        }
        return null;
    }

    public LibraryImplementation createArealLibrary(String type, String name, LibraryStorageArea area) {
        DummyArealLibrary impl = new DummyArealLibrary(type, name);
        assert (this.area2Storage.get(area) != null) : this.unknownArea(area);
        this.library2Area.put((LibraryImplementation)impl, area);
        return impl;
    }

    public Collection<? extends LibraryStorageArea> getAreas() {
        HashSet<LibraryStorageArea> areas = new HashSet<LibraryStorageArea>();
        for (ArealLibraryProvider alp : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (LibraryStorageArea area : alp.getOpenAreas()) {
                this.area2Storage.put(area, alp);
                areas.add(area);
            }
        }
        for (ArealLibraryProvider alp : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (URL location : createdAreas) {
                LibraryStorageArea area = alp.loadArea(location);
                if (area == null) continue;
                assert (area.getLocation().equals(location)) : "Bad location " + area.getLocation() + " does not match " + location + " from " + alp.getClass().getName();
                this.area2Storage.put(area, alp);
                areas.add(area);
            }
        }
        return areas;
    }

    public LibraryStorageArea getArea(LibraryImplementation library) {
        LibraryStorageArea area = this.getAreaOrNull(library);
        return area != null ? area : LibraryStorageArea.GLOBAL;
    }

    private LibraryStorageArea getAreaOrNull(LibraryImplementation library) {
        if (library instanceof ProxyLibraryImplementation) {
            library = ((ProxyLibraryImplementation)library).getDelegate();
        }
        return this.library2Area.get(library);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLibrary(LibraryImplementation impl) {
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            this.addedLibraries.add(impl);
            this.actualLibraries.add(impl);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLibrary(LibraryImplementation impl) {
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            if (this.addedLibraries.contains(impl)) {
                this.addedLibraries.remove(impl);
            } else {
                this.removedLibraries.add(((ProxyLibraryImplementation)impl).getDelegate());
            }
            this.actualLibraries.remove(impl);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyLibrary(ProxyLibraryImplementation impl) {
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            if (!this.addedLibraries.contains((Object)impl) && !this.changedLibraries.contains((Object)impl)) {
                this.changedLibraries.add(impl);
            }
        }
        this.cs.fireChange();
    }

    public boolean isLibraryEditable(LibraryImplementation impl) {
        if (this.addedLibraries.contains(impl)) {
            return true;
        }
        LibraryProvider provider = this.storageByLib.get(((ProxyLibraryImplementation)impl).getDelegate());
        return provider == this.writableProvider || this.getAreaOrNull(impl) != null;
    }

    public void apply() throws IOException {
        for (LibraryImplementation impl : this.removedLibraries) {
            LibraryProvider storage = this.storageByLib.get(impl);
            if (storage == this.writableProvider) {
                this.writableProvider.removeLibrary(impl);
                continue;
            }
            assert (impl instanceof LibraryImplementation2);
            LibraryStorageArea area = this.getAreaOrNull(impl);
            if (area != null) {
                ALPUtils.remove(this.area2Storage.get(area), (LibraryImplementation2)impl);
                continue;
            }
            throw new IOException("Cannot find storage for library: " + impl.getName());
        }
        for (LibraryImplementation impl : this.addedLibraries) {
            LibraryStorageArea area = this.getAreaOrNull(impl);
            if (area != null) {
                ArealLibraryProvider alp = this.area2Storage.get(area);
                assert (alp != null) : "Unknown area: " + area + " known areas: " + this.area2Storage.keySet();
                LibraryImplementation2 createdLib = ALPUtils.createLibrary(alp, impl.getType(), impl.getName(), area, ((DummyArealLibrary)impl).contents);
                LibrariesSupport.setDisplayName((LibraryImplementation)createdLib, (String)LibrariesSupport.getDisplayName((LibraryImplementation)impl));
                continue;
            }
            if (this.writableProvider != null) {
                this.writableProvider.addLibrary(impl);
                continue;
            }
            throw new IOException("Cannot add libraries, no WritableLibraryProvider.");
        }
        for (ProxyLibraryImplementation proxy : this.changedLibraries) {
            LibraryImplementation orig = proxy.getDelegate();
            LibraryProvider storage = this.storageByLib.get(orig);
            if (storage == this.writableProvider) {
                this.writableProvider.updateLibrary(orig, (LibraryImplementation)proxy);
                continue;
            }
            LibraryStorageArea area = this.library2Area.get(orig);
            if (area != null) {
                if (LibrariesSupport.supportsURIContent((LibraryImplementation)proxy)) {
                    LibraryImplementation2 orig2 = (LibraryImplementation2)proxy.getDelegate();
                    if (proxy.getNewURIContents() != null) {
                        for (Map.Entry<String, List<URI>> entry : proxy.getNewURIContents().entrySet()) {
                            orig2.setURIContent(entry.getKey(), entry.getValue());
                        }
                    }
                } else if (proxy.getNewContents() != null) {
                    for (Map.Entry entry : proxy.getNewContents().entrySet()) {
                        orig.setContent((String)entry.getKey(), (List)entry.getValue());
                    }
                }
                String origDisplayName = LibrariesSupport.getDisplayName((LibraryImplementation)orig);
                String string = LibrariesSupport.getDisplayName((LibraryImplementation)proxy);
                if (origDisplayName != null ? origDisplayName.equals(string) : string == null) continue;
                LibrariesSupport.setDisplayName((LibraryImplementation)orig, (String)string);
                continue;
            }
            throw new IOException("Cannot find storage for library: " + orig.getName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibrariesModel.this.computeLibraries();
                LibrariesModel.this.cs.fireChange();
            }
        });
    }

    private ProxyLibraryImplementation findModified(LibraryImplementation impl) {
        for (ProxyLibraryImplementation proxy : this.changedLibraries) {
            if (!proxy.getDelegate().equals(impl)) continue;
            return proxy;
        }
        return null;
    }

    private synchronized void computeLibraries() {
        this.actualLibraries.clear();
        for (LibraryProvider libraryProvider : Lookup.getDefault().lookupAll(LibraryProvider.class)) {
            for (LibraryImplementation lib : libraryProvider.getLibraries()) {
                ProxyLibraryImplementation proxy = this.findModified(lib);
                if (proxy != null) {
                    this.actualLibraries.add((LibraryImplementation)proxy);
                } else {
                    proxy = ProxyLibraryImplementation.createProxy(lib, this);
                    this.actualLibraries.add((LibraryImplementation)proxy);
                }
                this.storageByLib.put(lib, libraryProvider);
                LOG.log(Level.FINER, "computeLibraries: storage={0} lib={1} proxy={2}", new Object[]{libraryProvider, lib, proxy});
            }
        }
        for (LibraryStorageArea libraryStorageArea : this.getAreas()) {
            ArealLibraryProvider alp = this.area2Storage.get(libraryStorageArea);
            assert (alp != null) : libraryStorageArea;
            LibraryProvider prov = this.area2Provider.get(libraryStorageArea);
            if (prov == null) {
                prov = ALPUtils.getLibraries(alp, libraryStorageArea);
                prov.addPropertyChangeListener((PropertyChangeListener)this);
                this.area2Provider.put(libraryStorageArea, prov);
            }
            for (LibraryImplementation lib : prov.getLibraries()) {
                ProxyLibraryImplementation proxy = this.findModified(lib);
                if (proxy != null) {
                    this.actualLibraries.add((LibraryImplementation)proxy);
                } else {
                    proxy = ProxyLibraryImplementation.createProxy(lib, this);
                    this.actualLibraries.add((LibraryImplementation)proxy);
                }
                this.library2Area.put(lib, libraryStorageArea);
                LOG.log(Level.FINER, "computeLibraries: alp={0} area={1} lib={2} proxy={3}", new Object[]{alp, libraryStorageArea, lib, proxy});
            }
        }
        this.actualLibraries.addAll(this.addedLibraries);
        LOG.log(Level.FINE, "computeLibraries: actualLibraries={0} library2Area={1}", new Object[]{this.actualLibraries, this.library2Area});
    }

    private String unknownArea(LibraryStorageArea area) {
        StringBuilder sb = new StringBuilder();
        sb.append("Creating library in unknown area: ").append(area).append(" known areas: ").append(this.area2Storage.keySet()).append(" created: ").append(createdAreas);
        this.getAreas();
        sb.append(" known areas after reinit: ").append(this.area2Storage.keySet()).append(" providers: ").append(Lookup.getDefault().lookupAll(ArealLibraryProvider.class));
        return sb.toString();
    }

    public static final class LibrariesModelCache
    implements LibraryStorageAreaCache {
        public Collection<? extends URL> getCachedAreas() {
            return Collections.unmodifiableCollection(new ArrayList(createdAreas));
        }
    }

    private static final class DummyArealLibrary
    implements LibraryImplementation2,
    NamedLibraryImplementation {
        private final String type;
        private final String name;
        final Map<String, List<URI>> contents = new HashMap<String, List<URI>>();
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private String displayName;

        public DummyArealLibrary(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return null;
        }

        public String getLocalizingBundle() {
            return null;
        }

        public List<URL> getContent(String volumeType) throws IllegalArgumentException {
            return LibrariesSupport.convertURIsToURLs(this.getURIContent(volumeType), (LibrariesSupport.ConversionMode)LibrariesSupport.ConversionMode.WARN);
        }

        public List<URI> getURIContent(String volumeType) throws IllegalArgumentException {
            List<URI> content = this.contents.get(volumeType);
            if (content != null) {
                return content;
            }
            return Collections.emptyList();
        }

        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        public void setDisplayName(@NullAllowed String displayName) {
            this.displayName = displayName;
        }

        public void setDescription(String text) {
            throw new UnsupportedOperationException();
        }

        public void setLocalizingBundle(String resourceName) {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public void setContent(String volumeType, List<URL> path) throws IllegalArgumentException {
            this.setURIContent(volumeType, LibrariesSupport.convertURLsToURIs(path, (LibrariesSupport.ConversionMode)LibrariesSupport.ConversionMode.WARN));
        }

        public void setURIContent(String volumeType, List<URI> path) throws IllegalArgumentException {
            this.contents.put(volumeType, path);
            this.pcs.firePropertyChange("content", null, null);
        }

        public String toString() {
            return "DummyArealLibrary[" + this.name + "]";
        }
    }

    private static class LibrariesComparator
    implements Comparator<LibraryImplementation> {
        private LibrariesComparator() {
        }

        @Override
        public int compare(LibraryImplementation lib1, LibraryImplementation lib2) {
            String name2;
            String name1 = LibrariesSupport.getLocalizedName((LibraryImplementation)lib1);
            int r = name1.compareToIgnoreCase(name2 = LibrariesSupport.getLocalizedName((LibraryImplementation)lib2));
            return r != 0 ? r : System.identityHashCode(lib1) - System.identityHashCode(lib2);
        }
    }
}

