/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nu.validator.checker.AttributeUtil;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MicrodataChecker
extends Checker {
    private int depth;
    private Element.Builder builder;
    private static int counter;
    private List<Element> items;
    private Set<Element> properties;
    private Map<String, Element> idmap;
    private Locator locator;

    @Override
    public void reset() {
        this.depth = 0;
        this.builder = null;
        counter = 0;
        this.items = new LinkedList<Element>();
        this.properties = new LinkedHashSet<Element>();
        this.idmap = new HashMap<String, Element>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.depth;
        if ("http://www.w3.org/1999/xhtml" != uri) {
            return;
        }
        String id = null;
        String[] itemProp = null;
        String[] itemRef = null;
        boolean itemScope = false;
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            if (!atts.getURI(i).isEmpty()) continue;
            String attLocal = atts.getLocalName(i);
            String attValue = atts.getValue(i);
            if ("id" == attLocal) {
                id = attValue;
                continue;
            }
            if ("itemprop" == attLocal) {
                itemProp = AttributeUtil.split(attValue);
                continue;
            }
            if ("itemref" == attLocal) {
                itemRef = AttributeUtil.split(attValue);
                continue;
            }
            if ("itemscope" != attLocal) continue;
            itemScope = true;
        }
        if (id != null || itemProp != null || itemScope) {
            Element elm = new Element(new LocatorImpl(this.locator), itemProp, itemRef, itemScope);
            if (itemProp != null) {
                this.properties.add(elm);
            } else if (itemScope) {
                this.items.add(elm);
            }
            if (!this.idmap.containsKey(id)) {
                this.idmap.put(id, elm);
            }
            if (this.builder != null) {
                this.builder.appendChild(elm);
            }
            Element element = elm;
            element.getClass();
            this.builder = element.new Element.Builder(this.builder, this.depth);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.builder != null && this.builder.depth == this.depth) {
            this.builder = this.builder.parent;
        }
        --this.depth;
    }

    @Override
    public void endDocument() throws SAXException {
        for (Element item : this.items) {
            this.checkItem(item, new ArrayDeque<Element>());
        }
        for (Element prop : this.properties) {
            this.err("The \u201citemprop\u201d attribute was specified, but the element is not a property of any item.", prop.locator);
        }
    }

    private void checkItem(Element root, Deque<Element> parents) throws SAXException {
        ArrayDeque<Element> pending = new ArrayDeque<Element>();
        HashSet<Element> memory = new HashSet<Element>();
        memory.add(root);
        for (Element child : root.children) {
            pending.push(child);
        }
        if (root.itemRef != null) {
            for (String id : root.itemRef) {
                Element refElm = this.idmap.get(id);
                if (refElm != null) {
                    pending.push(refElm);
                    continue;
                }
                this.err("The \u201citemref\u201d attribute referenced \u201c" + id + "\u201d, but there is no element with an \u201cid\u201d attribute with that value.", root.locator);
            }
        }
        boolean memoryError = false;
        while (pending.size() > 0) {
            Element current = (Element)pending.pop();
            if (memory.contains(current)) {
                memoryError = true;
                continue;
            }
            memory.add(current);
            if (!current.itemScope) {
                for (Element child : current.children) {
                    pending.push(child);
                }
            }
            if (current.itemProp == null) continue;
            this.properties.remove(current);
            if (!current.itemScope) continue;
            if (!parents.contains(current)) {
                parents.push(root);
                this.checkItem(current, parents);
                parents.pop();
                continue;
            }
            this.err("The \u201citemref\u201d attribute created a circular reference with another item.", current.locator);
        }
        if (memoryError) {
            this.err("The \u201citemref\u201d attribute contained redundant references.", root.locator);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    class Element {
        public final Locator locator;
        public final String[] itemProp;
        public final String[] itemRef;
        public final boolean itemScope;
        public final List<Element> children;
        private final int order;

        public Element(Locator locator, String[] itemProp, String[] itemRef, boolean itemScope) {
            this.locator = locator;
            this.itemProp = itemProp;
            this.itemRef = itemRef;
            this.itemScope = itemScope;
            this.children = new LinkedList<Element>();
            this.order = counter++;
        }

        public boolean equals(Object that) {
            return this == that;
        }

        public int hashCode() {
            return this.order;
        }

        class Builder {
            public final Builder parent;
            public final int depth;

            public Builder(Builder parent, int depth) {
                this.parent = parent;
                this.depth = depth;
            }

            public void appendChild(Element elm) {
                Element.this.children.add(elm);
            }
        }
    }
}

