/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class FunctionInvocation
extends VariableBase {
    private FunctionName functionName;
    private final ArrayList<Expression> parameters = new ArrayList();

    private FunctionInvocation(int start, int end, FunctionName functionName, Expression[] parameters) {
        super(start, end);
        this.functionName = functionName;
        this.parameters.addAll(Arrays.asList(parameters));
    }

    public FunctionInvocation(int start, int end, FunctionName functionName, List<Expression> parameters) {
        this(start, end, functionName, parameters == null ? new Expression[]{} : parameters.toArray(new Expression[parameters.size()]));
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getParameters()) {
            sb.append(expression).append(",");
        }
        return this.getFunctionName() + "(" + sb.toString() + ")";
    }
}

