/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom;

import java.awt.Color;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.netbeans.modules.html.custom.conf.Tag;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.openide.util.ImageUtilities;

public class CustomTagCompletionItem
extends HtmlCompletionItem {
    private static final ImageIcon HTML_TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/html/custom/resources/custom_html_element.png", (boolean)false);
    private static final Color GRAY_COLOR = Color.GRAY;
    private static final Color DEFAULT_FG_COLOR = new Color(0, 0, 255);
    private boolean possible = true;
    private Tag tag;

    public CustomTagCompletionItem(Tag tag, int substituteOffset) {
        super(tag.getName(), substituteOffset);
        this.tag = tag;
    }

    protected String getSubstituteText() {
        return "<" + this.getItemText();
    }

    protected String getLeftHtmlText() {
        StringBuilder b = new StringBuilder();
        if (this.possible) {
            b.append("<font color=#");
            b.append(CustomTagCompletionItem.hexColorCode((Color)DEFAULT_FG_COLOR));
            b.append(">&lt;");
            b.append(this.getItemText());
            b.append("&gt;</font>");
        } else {
            b.append("<font color=#");
            b.append(CustomTagCompletionItem.hexColorCode((Color)GRAY_COLOR));
            b.append(">&lt;");
            b.append(this.getItemText());
            b.append("&gt;</font>");
        }
        return b.toString();
    }

    protected ImageIcon getIcon() {
        return HTML_TAG_ICON;
    }

    public String getHelp() {
        String ctx;
        Iterator<String> i;
        String documentation;
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>");
        sb.append(this.tag.getName());
        sb.append("</h1>");
        sb.append("<h2>Custom HTML element</h2>");
        String description = this.tag.getDescription();
        if (description != null) {
            sb.append("<p>");
            sb.append(description);
            sb.append("</p>");
        }
        if ((documentation = this.tag.getDocumentation()) != null) {
            sb.append("<p>");
            sb.append(documentation);
            sb.append("</p>");
        }
        if (description != null || documentation != null) {
            sb.append("<hr/>");
        }
        sb.append("<p>");
        if (this.tag.getContexts().isEmpty()) {
            sb.append("<b>Allowed in all contexts.</b>");
        } else {
            sb.append("<b>Allowed in context(s): </b>");
            i = this.tag.getContexts().iterator();
            while (i.hasNext()) {
                ctx = i.next();
                sb.append(ctx);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append("</p>");
        sb.append("<p>");
        if (this.tag.getTagsNames().isEmpty()) {
            sb.append("<b>Defines no children elements.</b>");
        } else {
            sb.append("<b>Defined children elements: </b>");
            i = this.tag.getTagsNames().iterator();
            while (i.hasNext()) {
                ctx = i.next();
                sb.append(ctx);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append("</p>");
        sb.append("<p>");
        if (this.tag.getAttributesNames().isEmpty()) {
            sb.append("<b>Defines no attributes.</b>");
        } else {
            sb.append("<b>Defined attributes: </b>");
            i = this.tag.getAttributesNames().iterator();
            while (i.hasNext()) {
                ctx = i.next();
                sb.append(ctx);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append("</p>");
        return sb.toString();
    }

    public boolean hasHelp() {
        return true;
    }
}

