/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;

public class FilterStandardProjects
implements ProjectFactory {
    private static final boolean BLOCK_LANGTOOLS_PROJECT = Boolean.getBoolean("nb.jdk.project.block.langtools");
    public static final String MSG_FILTER = "This project cannot be load while the NetBeans JDK project is open.";

    public boolean isProject(FileObject projectDirectory) {
        FileObject jdkRoot;
        return projectDirectory.getFileObject("nbproject/project.xml") != null && (jdkRoot = projectDirectory.getFileObject("../../..")) != null && (JDKProject.isJDKProject(jdkRoot) || jdkRoot.getFileObject("../modules.xml") != null) && projectDirectory.getParent().equals(jdkRoot.getFileObject("make/netbeans")) && "netbeans".equals(projectDirectory.getParent().getName());
    }

    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        String project2Repository;
        FileObject repository;
        if (!this.isProject(projectDirectory)) {
            return null;
        }
        if ("langtools".equals(projectDirectory.getNameExt())) {
            if (!BLOCK_LANGTOOLS_PROJECT) {
                return null;
            }
            repository = projectDirectory.getFileObject("../../../../langtools");
            project2Repository = "../..";
        } else {
            repository = projectDirectory.getFileObject("../../..");
            project2Repository = "";
        }
        if (repository != null) {
            for (Project prj : OpenProjects.getDefault().getOpenProjects()) {
                if (!repository.equals(prj.getProjectDirectory().getFileObject(project2Repository))) continue;
                throw new IOException(MSG_FILTER);
            }
        }
        return null;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
    }
}

