/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.osgi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.felix.framework.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class LoggerImpl
extends Logger {
    private final File logFile;

    public LoggerImpl(File logFile) {
        this.logFile = logFile;
        this.setLogLevel(4);
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void doLog(Bundle bundle, ServiceReference sr, int level, String msg, Throwable throwable) {
        String s = "";
        if (sr != null) {
            s = s + "SvcRef " + sr + " ";
        } else if (bundle != null) {
            s = s + "Bundle " + bundle.toString() + " ";
        }
        s = s + msg;
        if (throwable != null) {
            if (throwable instanceof BundleException && ((BundleException)throwable).getNestedException() != null) {
                throwable = ((BundleException)throwable).getNestedException();
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            s = s + "\n" + sw.getBuffer();
        }
        this._log(level, s);
    }

    @Override
    protected void _log(Bundle bundle, ServiceReference sr, int level, String msg, Throwable throwable) {
        this._log(level, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _log(int level, String msg) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.logFile, true)));
            bw.write(this.toLevel(level) + " [" + new Date() + "]:\n" + msg + "\n");
            bw.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String toLevel(int level) {
        switch (level) {
            case 4: {
                return "DEBUG";
            }
            case 1: {
                return "ERROR";
            }
            case 3: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
        }
        return "UNKNOWNN[" + level + "]";
    }

    private int toLevel(String level) {
        if (level != null) {
            if ("DEBUG".equalsIgnoreCase(level)) {
                return 4;
            }
            if ("ERROR".equalsIgnoreCase(level)) {
                return 1;
            }
            if ("INFO".equalsIgnoreCase(level)) {
                return 3;
            }
            if ("WARNING".equalsIgnoreCase(level)) {
                return 2;
            }
        }
        return 1;
    }
}

