/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;

public final class GpxDistance {
    private GpxDistance() {
    }

    public static double getLowestDistance(OsmPrimitive p, GpxData gpxData) {
        return gpxData.getTrackPoints().mapToDouble(tp -> GpxDistance.getDistance(p, tp)).filter(x -> x >= 0.0).min().orElse(Double.MAX_VALUE);
    }

    public static double getDistance(OsmPrimitive p, WayPoint waypoint) {
        if (p instanceof Node) {
            return GpxDistance.getDistanceNode((Node)p, waypoint);
        }
        if (p instanceof Way) {
            return GpxDistance.getDistanceWay((Way)p, waypoint);
        }
        if (p instanceof Relation) {
            return GpxDistance.getDistanceRelation((Relation)p, waypoint);
        }
        return Double.MAX_VALUE;
    }

    public static double getDistanceRelation(Relation relation, WayPoint waypoint) {
        double distance;
        double shortestDistance = Double.MAX_VALUE;
        ArrayList<Node> nodes = new ArrayList<Node>(relation.getMemberPrimitives(Node.class));
        ArrayList<Way> ways = new ArrayList<Way>(relation.getMemberPrimitives(Way.class));
        ArrayList<Relation> relations = new ArrayList<Relation>(relation.getMemberPrimitives(Relation.class));
        if (nodes.isEmpty() && ways.isEmpty() && relations.isEmpty()) {
            return Double.MAX_VALUE;
        }
        for (Relation nrelation : relations) {
            distance = GpxDistance.getDistanceRelation(nrelation, waypoint);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        for (Way way : ways) {
            distance = GpxDistance.getDistanceWay(way, waypoint);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        for (Node node : nodes) {
            distance = GpxDistance.getDistanceNode(node, waypoint);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        return shortestDistance;
    }

    public static double getDistanceWay(Way way, WayPoint waypoint) {
        double shortestDistance = Double.MAX_VALUE;
        if (way == null || waypoint == null) {
            return shortestDistance;
        }
        LatLon llwaypoint = waypoint.getCoor();
        EastNorth enwaypoint = new EastNorth(llwaypoint.getY(), llwaypoint.getX());
        for (int i = 0; i < way.getNodesCount() - 1; ++i) {
            double distance = Double.MAX_VALUE;
            LatLon llfirst = way.getNode(i).getCoor();
            LatLon llsecond = way.getNode(i + 1).getCoor();
            EastNorth first = new EastNorth(llfirst.getY(), llfirst.getX());
            EastNorth second = new EastNorth(llsecond.getY(), llsecond.getX());
            if (first.isValid() && second.isValid()) {
                EastNorth closestPoint = Geometry.closestPointToSegment(first, second, enwaypoint);
                distance = llwaypoint.greatCircleDistance(new LatLon(closestPoint.getX(), closestPoint.getY()));
            } else if (first.isValid() && !second.isValid()) {
                distance = GpxDistance.getDistanceEastNorth(first, waypoint);
            } else if (!first.isValid() && second.isValid()) {
                distance = GpxDistance.getDistanceEastNorth(second, waypoint);
            } else if (!first.isValid() && !second.isValid()) {
                distance = Double.MAX_VALUE;
            }
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        return shortestDistance;
    }

    public static double getDistanceNode(Node node, WayPoint waypoint) {
        if (node == null) {
            return Double.MAX_VALUE;
        }
        return GpxDistance.getDistanceLatLon(node.getCoor(), waypoint);
    }

    public static double getDistanceEastNorth(EastNorth en, WayPoint waypoint) {
        if (en == null || !en.isValid()) {
            return Double.MAX_VALUE;
        }
        return GpxDistance.getDistanceLatLon(new LatLon(en.getY(), en.getX()), waypoint);
    }

    public static double getDistanceLatLon(LatLon latlon, WayPoint waypoint) {
        if (latlon == null || waypoint == null || waypoint.getCoor() == null) {
            return Double.MAX_VALUE;
        }
        return waypoint.getCoor().greatCircleDistance(latlon);
    }
}

