/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangePropertyKeyCommand
extends Command {
    private final List<? extends OsmPrimitive> objects;
    private final String key;
    private final String newKey;

    public ChangePropertyKeyCommand(OsmPrimitive object, String key, String newKey) {
        this(Collections.singleton(object), key, newKey);
    }

    public ChangePropertyKeyCommand(Collection<? extends OsmPrimitive> objects, String key, String newKey) {
        this(objects.iterator().next().getDataSet(), objects, key, newKey);
    }

    public ChangePropertyKeyCommand(DataSet ds, Collection<? extends OsmPrimitive> objects, String key, String newKey) {
        super(ds);
        this.objects = new LinkedList<OsmPrimitive>(objects);
        this.key = key;
        this.newKey = newKey;
    }

    @Override
    public boolean executeCommand() {
        if (!super.executeCommand()) {
            return false;
        }
        for (OsmPrimitive osmPrimitive : this.objects) {
            String oldValue = osmPrimitive.get(this.key);
            if (oldValue == null && !osmPrimitive.hasKey(this.newKey)) continue;
            osmPrimitive.setModified(true);
            osmPrimitive.put(this.newKey, oldValue);
            osmPrimitive.remove(this.key);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.objects);
    }

    @Override
    public String getDescriptionText() {
        String text = I18n.tr("Replace \"{0}\" by \"{1}\" for", this.key, this.newKey);
        if (this.objects.size() == 1) {
            NameVisitor v = new NameVisitor();
            this.objects.get(0).accept(v);
            text = text + " " + I18n.tr(v.className, new Object[0]) + " " + v.name;
        } else {
            text = text + " " + this.objects.size() + " " + I18n.trn("object", "objects", this.objects.size(), new Object[0]);
        }
        return text;
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "key");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>();
        NameVisitor v = new NameVisitor();
        for (OsmPrimitive osmPrimitive : this.objects) {
            osmPrimitive.accept(v);
            children.add(new SinglePrimitivePseudoCommand(v.name, osmPrimitive, v.icon));
        }
        return children;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objects, this.key, this.newKey);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ChangePropertyKeyCommand that = (ChangePropertyKeyCommand)obj;
        return Objects.equals(this.objects, that.objects) && Objects.equals(this.key, that.key) && Objects.equals(this.newKey, that.newKey);
    }

    static final class SinglePrimitivePseudoCommand
    implements PseudoCommand {
        private final String name;
        private final OsmPrimitive osm;
        private final Icon icon;

        SinglePrimitivePseudoCommand(String name, OsmPrimitive osm, Icon icon) {
            this.name = name;
            this.osm = osm;
            this.icon = icon;
        }

        @Override
        public String getDescriptionText() {
            return this.name;
        }

        @Override
        public Icon getDescriptionIcon() {
            return this.icon;
        }

        @Override
        public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
            return Collections.singleton(this.osm);
        }
    }
}

