/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.ParseException;
import gnu.classpath.tools.gjdoc.Parser;
import gnu.classpath.tools.gjdoc.SourceComponent;

class CommentComponent
extends SourceComponent {
    CommentComponent() {
    }

    int match(char[] source, int index) throws ParseException {
        if (index + 1 < source.length && source[index] == '/' && source[index + 1] == '*') {
            index += 2;
            while (index + 1 < source.length) {
                if (source[index] == '*' && source[index + 1] == '/') {
                    return index + 2;
                }
                ++index;
            }
            throw new ParseException("unexpected end of input");
        }
        return -1;
    }

    int process(Parser parser, char[] source, int startIndex, int endIndex) {
        String boilerplateComment;
        if (source[startIndex + 0] == '/' && source[startIndex + 1] == '*' && source[startIndex + 2] == '*') {
            parser.setLastComment(new String(source, startIndex, endIndex - startIndex));
        } else if (parser.getBoilerplateComment() == null && Main.getInstance().isCopyLicenseText() && (boilerplateComment = new String(source, startIndex + 2, endIndex - startIndex - 4)).toLowerCase().indexOf("copyright") >= 0) {
            parser.setBoilerplateComment(boilerplateComment);
        }
        return endIndex;
    }
}

