/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityMap2Int;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static int defaultProtocolVersion = 2;
    private DataOutputStream dataOutput;
    private boolean writeDataAsBlocks;
    private DataOutputStream realOutput;
    private DataOutputStream blockDataOutput;
    private byte[] blockData;
    private int blockDataCount;
    private Object currentObject;
    ObjectStreamClass currentObjectStreamClass;
    private PutField currentPutField;
    private boolean fieldsAlreadyWritten;
    private boolean replacementEnabled;
    private boolean isSerializing;
    private int nextOID;
    private ObjectIdentityMap2Int OIDLookupTable;
    private int protocolVersion;
    private boolean useSubclassMethod;
    private SetAccessibleAction setAccessible = new SetAccessibleAction();
    private int depth = 0;
    private boolean dump = false;
    private static final boolean DEBUG = false;

    public ObjectOutputStream(OutputStream out) throws IOException {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null && ObjectOutputStream.overridesMethods(this.getClass())) {
            secMan.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.realOutput = new DataOutputStream(out);
        this.blockData = new byte[1024];
        this.blockDataCount = 0;
        this.blockDataOutput = new DataOutputStream(this);
        this.setBlockDataMode(true);
        this.replacementEnabled = false;
        this.isSerializing = false;
        this.nextOID = 0x7E0000;
        this.OIDLookupTable = new ObjectIdentityMap2Int();
        this.protocolVersion = defaultProtocolVersion;
        this.useSubclassMethod = false;
        this.writeStreamHeader();
    }

    @Override
    public final void writeObject(Object obj) throws IOException {
        this.writeObject(obj, true);
    }

    public void writeUnshared(Object obj) throws IOException {
        this.writeObject(obj, false);
    }

    private final void writeObject(Object obj, boolean shared) throws IOException {
        block51: {
            if (this.useSubclassMethod) {
                if (this.dump) {
                    this.dumpElementln("WRITE OVERRIDE: " + obj);
                }
                this.writeObjectOverride(obj);
                return;
            }
            if (this.dump) {
                this.dumpElementln("WRITE: ", obj);
            }
            this.depth += 2;
            boolean was_serializing = this.isSerializing;
            boolean old_mode = this.setBlockDataMode(false);
            try {
                try {
                    Class<? extends Object> clazz;
                    ObjectStreamClass osc;
                    this.isSerializing = true;
                    boolean replaceDone = false;
                    Object replacedObject = null;
                    while (true) {
                        if (obj == null) {
                            this.realOutput.writeByte(112);
                            break block51;
                        }
                        int handle = this.findHandle(obj);
                        if (handle >= 0 && shared) {
                            this.realOutput.writeByte(113);
                            this.realOutput.writeInt(handle);
                            break block51;
                        }
                        if (obj instanceof Class) {
                            Class cl = (Class)obj;
                            osc = ObjectStreamClass.lookupForClassObject(cl);
                            this.realOutput.writeByte(118);
                            if (!osc.isProxyClass) {
                                this.writeObject(osc);
                            } else {
                                System.err.println("1");
                                this.realOutput.writeByte(125);
                                Class<?>[] intfs = cl.getInterfaces();
                                this.realOutput.writeInt(intfs.length);
                                int i = 0;
                                while (i < intfs.length) {
                                    this.realOutput.writeUTF(intfs[i].getName());
                                    ++i;
                                }
                                boolean oldmode = this.setBlockDataMode(true);
                                this.annotateProxyClass(cl);
                                this.setBlockDataMode(oldmode);
                                this.realOutput.writeByte(120);
                                this.writeObject(osc.getSuper());
                            }
                            if (shared) {
                                this.assignNewHandle(obj);
                            }
                            break block51;
                        }
                        if (obj instanceof ObjectStreamClass) {
                            this.writeClassDescriptor((ObjectStreamClass)obj);
                            break block51;
                        }
                        clazz = obj.getClass();
                        osc = ObjectStreamClass.lookupForClassObject(clazz);
                        if (osc == null) {
                            throw new NotSerializableException(clazz.getName());
                        }
                        if (osc.isEnum()) {
                            this.realOutput.writeByte(126);
                            this.writeObject(osc);
                            if (shared) {
                                this.assignNewHandle(obj);
                            }
                            this.writeObject(((Enum)obj).name());
                            break block51;
                        }
                        if (!this.replacementEnabled && !(obj instanceof Serializable) || replaceDone) break;
                        replacedObject = obj;
                        if (obj instanceof Serializable) {
                            try {
                                Method m = osc.writeReplaceMethod;
                                if (m != null) {
                                    obj = m.invoke(obj, new Object[0]);
                                }
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                        }
                        if (this.replacementEnabled) {
                            obj = this.replaceObject(obj);
                        }
                        replaceDone = true;
                    }
                    if (obj instanceof String) {
                        String s = (String)obj;
                        long l = this.realOutput.getUTFlength(s, 0, 0L);
                        if (l <= 65535L) {
                            this.realOutput.writeByte(116);
                            if (shared) {
                                this.assignNewHandle(obj);
                            }
                            this.realOutput.writeUTFShort(s, (int)l);
                        } else {
                            this.realOutput.writeByte(124);
                            if (shared) {
                                this.assignNewHandle(obj);
                            }
                            this.realOutput.writeUTFLong(s, l);
                        }
                        break block51;
                    }
                    if (clazz.isArray()) {
                        this.realOutput.writeByte(117);
                        this.writeObject(osc);
                        if (shared) {
                            this.assignNewHandle(obj);
                        }
                        this.writeArraySizeAndElements(obj, clazz.getComponentType());
                        break block51;
                    }
                    this.realOutput.writeByte(115);
                    this.writeObject(osc);
                    if (shared) {
                        if (replaceDone) {
                            this.assignNewHandle(replacedObject);
                        } else {
                            this.assignNewHandle(obj);
                        }
                    }
                    if (obj instanceof Externalizable) {
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(true);
                        }
                        ((Externalizable)obj).writeExternal(this);
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(false);
                            this.realOutput.writeByte(120);
                        }
                        break block51;
                    }
                    if (obj instanceof Serializable) {
                        Object prevObject = this.currentObject;
                        ObjectStreamClass prevObjectStreamClass = this.currentObjectStreamClass;
                        this.currentObject = obj;
                        ObjectStreamClass[] hierarchy = osc.hierarchy();
                        int i = 0;
                        while (i < hierarchy.length) {
                            this.currentObjectStreamClass = hierarchy[i];
                            this.fieldsAlreadyWritten = false;
                            if (this.currentObjectStreamClass.hasWriteMethod()) {
                                if (this.dump) {
                                    this.dumpElementln("WRITE METHOD CALLED FOR: ", obj);
                                }
                                this.setBlockDataMode(true);
                                this.callWriteMethod(obj, this.currentObjectStreamClass);
                                this.setBlockDataMode(false);
                                this.realOutput.writeByte(120);
                                if (this.dump) {
                                    this.dumpElementln("WRITE ENDBLOCKDATA FOR: ", obj);
                                }
                            } else {
                                if (this.dump) {
                                    this.dumpElementln("WRITE FIELDS CALLED FOR: ", obj);
                                }
                                this.writeFields(obj, this.currentObjectStreamClass);
                            }
                            ++i;
                        }
                        this.currentObject = prevObject;
                        this.currentObjectStreamClass = prevObjectStreamClass;
                        this.currentPutField = null;
                        break block51;
                    }
                    throw new NotSerializableException(String.valueOf(clazz.getName()) + " in " + obj.getClass());
                }
                catch (ObjectStreamException ose) {
                    throw ose;
                }
                catch (IOException e) {
                    this.realOutput.writeByte(123);
                    this.reset(true);
                    this.setBlockDataMode(false);
                    try {
                        this.writeObject(e);
                    }
                    catch (IOException ioe) {
                        StreamCorruptedException ex = new StreamCorruptedException(ioe + " thrown while exception was being written to stream.");
                        throw ex;
                    }
                    this.reset(true);
                    this.isSerializing = was_serializing;
                    this.setBlockDataMode(old_mode);
                    this.depth -= 2;
                    if (this.dump) {
                        this.dumpElementln("END: ", obj);
                    }
                }
            }
            finally {
                this.isSerializing = was_serializing;
                this.setBlockDataMode(old_mode);
                this.depth -= 2;
                if (this.dump) {
                    this.dumpElementln("END: ", obj);
                }
            }
        }
    }

    protected void writeClassDescriptor(ObjectStreamClass osc) throws IOException {
        if (osc.isProxyClass) {
            this.realOutput.writeByte(125);
            Class<?>[] intfs = osc.forClass().getInterfaces();
            this.realOutput.writeInt(intfs.length);
            int i = 0;
            while (i < intfs.length) {
                this.realOutput.writeUTF(intfs[i].getName());
                ++i;
            }
            this.assignNewHandle(osc);
            boolean oldmode = this.setBlockDataMode(true);
            this.annotateProxyClass(osc.forClass());
            this.setBlockDataMode(oldmode);
            this.realOutput.writeByte(120);
        } else {
            this.realOutput.writeByte(114);
            this.realOutput.writeUTF(osc.getName());
            if (osc.isEnum()) {
                this.realOutput.writeLong(0L);
            } else {
                this.realOutput.writeLong(osc.getSerialVersionUID());
            }
            this.assignNewHandle(osc);
            int flags = osc.getFlags();
            if (this.protocolVersion == 2 && osc.isExternalizable()) {
                flags |= 8;
            }
            this.realOutput.writeByte(flags);
            ObjectStreamField[] fields = osc.fields;
            if (fields == ObjectStreamClass.INVALID_FIELDS) {
                throw new InvalidClassException(osc.getName(), "serialPersistentFields is invalid");
            }
            this.realOutput.writeShort(fields.length);
            int i = 0;
            while (i < fields.length) {
                ObjectStreamField field = fields[i];
                this.realOutput.writeByte(field.getTypeCode());
                this.realOutput.writeUTF(field.getName());
                if (!field.isPrimitive()) {
                    this.writeObject(field.getTypeString());
                }
                ++i;
            }
            boolean oldmode = this.setBlockDataMode(true);
            this.annotateClass(osc.forClass());
            this.setBlockDataMode(oldmode);
            this.realOutput.writeByte(120);
        }
        if (osc.isSerializable() || osc.isExternalizable()) {
            this.writeObject(osc.getSuper());
        } else {
            this.writeObject(null);
        }
    }

    public void defaultWriteObject() throws IOException, NotActiveException {
        this.markFieldsWritten();
        this.writeFields(this.currentObject, this.currentObjectStreamClass);
    }

    private void markFieldsWritten() throws IOException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultWriteObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyWritten) {
            throw new IOException("Only one of writeFields and defaultWriteObject may be called, and it may only be called once");
        }
        this.fieldsAlreadyWritten = true;
    }

    public void reset() throws IOException {
        this.reset(false);
    }

    private void reset(boolean internal) throws IOException {
        if (!internal) {
            if (this.isSerializing) {
                throw new IOException("Reset called while serialization in progress");
            }
            this.realOutput.writeByte(121);
        }
        this.clearHandles();
    }

    public void useProtocolVersion(int version) throws IOException {
        if (version != 1 && version != 2) {
            throw new IllegalArgumentException("Invalid protocol version requested.");
        }
        if (this.nextOID != 0x7E0000) {
            throw new IllegalStateException("Protocol version cannot be changed after serialization started.");
        }
        this.protocolVersion = version;
    }

    protected void annotateClass(Class<?> cl) throws IOException {
    }

    protected void annotateProxyClass(Class<?> cl) throws IOException {
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean old_val = this.replacementEnabled;
        this.replacementEnabled = enable;
        return old_val;
    }

    protected void writeStreamHeader() throws IOException {
        this.realOutput.writeShort(-21267);
        this.realOutput.writeShort(5);
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager sec_man = System.getSecurityManager();
        if (sec_man != null) {
            sec_man.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected void writeObjectOverride(Object obj) throws NotActiveException, IOException {
        throw new NotActiveException("Subclass of ObjectOutputStream must implement writeObjectOverride");
    }

    @Override
    public void write(int data) throws IOException {
        if (this.writeDataAsBlocks) {
            if (this.blockDataCount == 1024) {
                this.drain();
            }
            this.blockData[this.blockDataCount++] = (byte)data;
        } else {
            this.realOutput.write(data);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.writeDataAsBlocks) {
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.blockDataCount + len < 1024) {
                System.arraycopy(b, off, this.blockData, this.blockDataCount, len);
                this.blockDataCount += len;
            } else {
                this.drain();
                this.writeBlockDataHeader(len);
                this.realOutput.write(b, off, len);
            }
        } else {
            this.realOutput.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.drain();
        this.realOutput.flush();
    }

    protected void drain() throws IOException {
        if (this.blockDataCount == 0) {
            return;
        }
        if (this.writeDataAsBlocks) {
            this.writeBlockDataHeader(this.blockDataCount);
        }
        this.realOutput.write(this.blockData, 0, this.blockDataCount);
        this.blockDataCount = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.realOutput.close();
    }

    @Override
    public void writeBoolean(boolean data) throws IOException {
        this.blockDataOutput.writeBoolean(data);
    }

    @Override
    public void writeByte(int data) throws IOException {
        this.blockDataOutput.writeByte(data);
    }

    @Override
    public void writeShort(int data) throws IOException {
        this.blockDataOutput.writeShort(data);
    }

    @Override
    public void writeChar(int data) throws IOException {
        this.blockDataOutput.writeChar(data);
    }

    @Override
    public void writeInt(int data) throws IOException {
        this.blockDataOutput.writeInt(data);
    }

    @Override
    public void writeLong(long data) throws IOException {
        this.blockDataOutput.writeLong(data);
    }

    @Override
    public void writeFloat(float data) throws IOException {
        this.blockDataOutput.writeFloat(data);
    }

    @Override
    public void writeDouble(double data) throws IOException {
        this.blockDataOutput.writeDouble(data);
    }

    @Override
    public void writeBytes(String data) throws IOException {
        this.blockDataOutput.writeBytes(data);
    }

    @Override
    public void writeChars(String data) throws IOException {
        this.dataOutput.writeChars(data);
    }

    @Override
    public void writeUTF(String data) throws IOException {
        this.dataOutput.writeUTF(data);
    }

    public PutField putFields() throws IOException {
        if (this.currentPutField != null) {
            return this.currentPutField;
        }
        this.currentPutField = new PutField(){
            private byte[] prim_field_data;
            private Object[] objs;
            {
                this.prim_field_data = new byte[ObjectOutputStream.this.currentObjectStreamClass.primFieldSize];
                this.objs = new Object[ObjectOutputStream.this.currentObjectStreamClass.objectFieldCount];
            }

            private ObjectStreamField getField(String name) {
                ObjectStreamField field = ObjectOutputStream.this.currentObjectStreamClass.getField(name);
                if (field == null) {
                    throw new IllegalArgumentException("no such serializable field " + name);
                }
                return field;
            }

            public void put(String name, boolean value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'Z');
                this.prim_field_data[field.getOffset()] = (byte)(value ? 1 : 0);
            }

            public void put(String name, byte value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'B');
                this.prim_field_data[field.getOffset()] = value;
            }

            public void put(String name, char value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'C');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, double value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'D');
                int off = field.getOffset();
                long l_value = Double.doubleToLongBits(value);
                this.prim_field_data[off++] = (byte)(l_value >>> 52);
                this.prim_field_data[off++] = (byte)(l_value >>> 48);
                this.prim_field_data[off++] = (byte)(l_value >>> 40);
                this.prim_field_data[off++] = (byte)(l_value >>> 32);
                this.prim_field_data[off++] = (byte)(l_value >>> 24);
                this.prim_field_data[off++] = (byte)(l_value >>> 16);
                this.prim_field_data[off++] = (byte)(l_value >>> 8);
                this.prim_field_data[off] = (byte)l_value;
            }

            public void put(String name, float value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'F');
                int off = field.getOffset();
                int i_value = Float.floatToIntBits(value);
                this.prim_field_data[off++] = (byte)(i_value >>> 24);
                this.prim_field_data[off++] = (byte)(i_value >>> 16);
                this.prim_field_data[off++] = (byte)(i_value >>> 8);
                this.prim_field_data[off] = (byte)i_value;
            }

            public void put(String name, int value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'I');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 24);
                this.prim_field_data[off++] = (byte)(value >>> 16);
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, long value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'J');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 52);
                this.prim_field_data[off++] = (byte)(value >>> 48);
                this.prim_field_data[off++] = (byte)(value >>> 40);
                this.prim_field_data[off++] = (byte)(value >>> 32);
                this.prim_field_data[off++] = (byte)(value >>> 24);
                this.prim_field_data[off++] = (byte)(value >>> 16);
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, short value) {
                ObjectStreamField field = this.getField(name);
                this.checkType(field, 'S');
                int off = field.getOffset();
                this.prim_field_data[off++] = (byte)(value >>> 8);
                this.prim_field_data[off] = (byte)value;
            }

            public void put(String name, Object value) {
                ObjectStreamField field = this.getField(name);
                if (value != null && !field.getType().isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("Class " + value.getClass() + " cannot be cast to " + field.getType());
                }
                this.objs[field.getOffset()] = value;
            }

            public void write(ObjectOutput out) throws IOException {
                boolean oldmode = ObjectOutputStream.this.setBlockDataMode(false);
                out.write(this.prim_field_data);
                int i = 0;
                while (i < this.objs.length) {
                    out.writeObject(this.objs[i]);
                    ++i;
                }
                ObjectOutputStream.this.setBlockDataMode(oldmode);
            }

            private void checkType(ObjectStreamField field, char type) throws IllegalArgumentException {
                if (TypeSignature.getEncodingOfClass(field.getType()).charAt(0) != type) {
                    throw new IllegalArgumentException();
                }
            }
        };
        return this.currentPutField;
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException("writeFields can only be called after putFields has been called");
        }
        this.markFieldsWritten();
        this.currentPutField.write(this);
    }

    private void writeBlockDataHeader(int size) throws IOException {
        if (size < 256) {
            this.realOutput.writeByte(119);
            this.realOutput.write(size);
        } else {
            this.realOutput.writeByte(122);
            this.realOutput.writeInt(size);
        }
    }

    private int findHandle(Object obj) {
        return this.OIDLookupTable.get(obj);
    }

    private int assignNewHandle(Object obj) {
        this.OIDLookupTable.put(obj, this.nextOID);
        return this.nextOID++;
    }

    private void clearHandles() {
        this.nextOID = 0x7E0000;
        this.OIDLookupTable.clear();
    }

    private void writeArraySizeAndElements(Object array, Class clazz) throws IOException {
        int length = Array.getLength(array);
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] cast_array = (boolean[])array;
                this.realOutput.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.realOutput.writeBoolean(cast_array[i]);
                    ++i;
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] cast_array = (byte[])array;
                this.realOutput.writeInt(length);
                this.realOutput.write(cast_array, 0, length);
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cast_array = (char[])array;
                this.realOutput.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.realOutput.writeChar(cast_array[i]);
                    ++i;
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] cast_array = (double[])array;
                this.realOutput.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.realOutput.writeDouble(cast_array[i]);
                    ++i;
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] cast_array = (float[])array;
                this.realOutput.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.realOutput.writeFloat(cast_array[i]);
                    ++i;
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] cast_array = (int[])array;
                this.realOutput.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.realOutput.writeInt(cast_array[i]);
                    ++i;
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] cast_array = (long[])array;
                this.realOutput.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.realOutput.writeLong(cast_array[i]);
                    ++i;
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] cast_array = (short[])array;
                this.realOutput.writeInt(length);
                int i = 0;
                while (i < length) {
                    this.realOutput.writeShort(cast_array[i]);
                    ++i;
                }
                return;
            }
        } else {
            Object[] cast_array = (Object[])array;
            this.realOutput.writeInt(length);
            int i = 0;
            while (i < length) {
                this.writeObject(cast_array[i]);
                ++i;
            }
        }
    }

    private void writeFields(Object obj, ObjectStreamClass osc) throws IOException {
        osc.ensureFieldsSet(osc.forClass());
        ObjectStreamField[] fields = osc.fields;
        boolean oldmode = this.setBlockDataMode(false);
        try {
            this.writeFields(obj, fields);
        }
        catch (IllegalArgumentException _) {
            InvalidClassException e = new InvalidClassException("writing fields of class " + osc.forClass().getName());
            e.initCause(_);
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception _) {
            IOException e = new IOException("Unexpected exception " + _);
            e.initCause(_);
            throw e;
        }
        this.setBlockDataMode(oldmode);
    }

    private void writeFields(Object obj, ObjectStreamField[] fields) throws IllegalArgumentException, IllegalAccessException, IOException {
        int i = 0;
        while (i < fields.length) {
            ObjectStreamField osf = fields[i];
            Field field = osf.field;
            switch (osf.getTypeCode()) {
                case 'Z': {
                    this.realOutput.writeBoolean(field.getBoolean(obj));
                    break;
                }
                case 'B': {
                    this.realOutput.writeByte(field.getByte(obj));
                    break;
                }
                case 'S': {
                    this.realOutput.writeShort(field.getShort(obj));
                    break;
                }
                case 'C': {
                    this.realOutput.writeChar(field.getChar(obj));
                    break;
                }
                case 'I': {
                    this.realOutput.writeInt(field.getInt(obj));
                    break;
                }
                case 'F': {
                    this.realOutput.writeFloat(field.getFloat(obj));
                    break;
                }
                case 'J': {
                    this.realOutput.writeLong(field.getLong(obj));
                    break;
                }
                case 'D': {
                    this.realOutput.writeDouble(field.getDouble(obj));
                    break;
                }
                case 'L': 
                case '[': {
                    this.writeObject(field.get(obj));
                    break;
                }
                default: {
                    throw new IOException("Unexpected type code " + osf.getTypeCode());
                }
            }
            ++i;
        }
    }

    boolean setBlockDataMode(boolean on) throws IOException {
        if (on == this.writeDataAsBlocks) {
            return on;
        }
        this.drain();
        boolean oldmode = this.writeDataAsBlocks;
        this.writeDataAsBlocks = on;
        this.dataOutput = on ? this.blockDataOutput : this.realOutput;
        return oldmode;
    }

    private void callWriteMethod(Object obj, ObjectStreamClass osc) throws IOException {
        this.currentPutField = null;
        try {
            Object[] args = new Object[]{this};
            osc.writeObjectMethod.invoke(obj, args);
        }
        catch (InvocationTargetException x) {
            Throwable exception = x.getTargetException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException ioe = new IOException("Exception thrown from writeObject() on " + osc.forClass().getName() + ": " + exception.getClass().getName());
            ioe.initCause(exception);
            throw ioe;
        }
        catch (Exception x) {
            IOException ioe = new IOException("Failure invoking writeObject() on " + osc.forClass().getName() + ": " + x.getClass().getName());
            ioe.initCause(x);
            throw ioe;
        }
    }

    private void dumpElementln(String msg, Object obj) {
        block7: {
            try {
                try {
                    int i = 0;
                    while (i < this.depth) {
                        System.out.print(" ");
                        ++i;
                    }
                    System.out.print(Thread.currentThread() + ": ");
                    System.out.print(msg);
                    if (Proxy.isProxyClass(obj.getClass())) {
                        System.out.print(obj.getClass());
                        break block7;
                    }
                    System.out.print(obj);
                }
                catch (Exception exception) {
                    System.out.println();
                }
            }
            finally {
                System.out.println();
            }
        }
    }

    private void dumpElementln(String msg) {
        int i = 0;
        while (i < this.depth) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(Thread.currentThread() + ": ");
        System.out.println(msg);
    }

    private static boolean overridesMethods(final Class<?> clazz) {
        if (clazz == ObjectOutputStream.class) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Method[] methods = clazz.getDeclaredMethods();
                int a = 0;
                while (a < methods.length) {
                    Class<?>[] paramTypes;
                    String name = methods[a].getName();
                    if (name.equals("writeUnshared") ? (paramTypes = methods[a].getParameterTypes()).length == 1 && paramTypes[0] == Object.class && methods[a].getReturnType() == Void.class : name.equals("putFields") && methods[a].getParameterTypes().length == 0 && methods[a].getReturnType() == PutField.class) {
                        return true;
                    }
                    ++a;
                }
                return false;
            }
        });
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

