/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.CharacterIterator;

public abstract class FontMetrics
implements Serializable {
    private static final long serialVersionUID = 1681126225205050147L;
    protected Font font;
    private static final FontRenderContext gRC = new FontRenderContext(null, false, false);

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return 0;
    }

    public int getAscent() {
        return 1;
    }

    public int getDescent() {
        return 1;
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent() + this.getLeading();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getMaxDecent();
    }

    public int getMaxDecent() {
        return this.getDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int ch) {
        char[] chars = Character.toChars(ch);
        return this.charsWidth(chars, 0, chars.length);
    }

    public int charWidth(char ch) {
        return 1;
    }

    public int stringWidth(String str) {
        char[] buf = new char[str.length()];
        str.getChars(0, str.length(), buf, 0);
        return this.charsWidth(buf, 0, buf.length);
    }

    public int charsWidth(char[] buf, int offset, int len) {
        int total_width = 0;
        int endOffset = offset + len;
        int i = offset;
        while (i < endOffset) {
            total_width += this.charWidth(buf[i]);
            ++i;
        }
        return total_width;
    }

    public int bytesWidth(byte[] buf, int offset, int len) {
        int total_width = 0;
        int i = offset;
        while (i < len) {
            total_width = this.charWidth((char)buf[i]);
            ++i;
        }
        return total_width;
    }

    public int[] getWidths() {
        int[] result = new int[256];
        char i = '\u0000';
        while (i < '\u0100') {
            result[i] = this.charWidth(i);
            i = (char)(i + '\u0001');
        }
        return result;
    }

    public String toString() {
        return this.getClass() + "[font=" + this.font + ",ascent=" + this.getAscent() + ",descent=" + this.getDescent() + ",height=" + this.getHeight() + "]";
    }

    public LineMetrics getLineMetrics(String text, Graphics g) {
        return this.getLineMetrics(text, 0, text.length(), g);
    }

    public LineMetrics getLineMetrics(String text, int begin, int limit, Graphics g) {
        FontRenderContext rc = g instanceof Graphics2D ? ((Graphics2D)g).getFontRenderContext() : gRC;
        return this.font.getLineMetrics(text, begin, limit, rc);
    }

    public LineMetrics getLineMetrics(char[] chars, int begin, int limit, Graphics g) {
        FontRenderContext rc = g instanceof Graphics2D ? ((Graphics2D)g).getFontRenderContext() : gRC;
        return this.font.getLineMetrics(chars, begin, limit, rc);
    }

    public Rectangle2D getMaxCharBounds(Graphics context) {
        if (context instanceof Graphics2D) {
            return this.font.getMaxCharBounds(((Graphics2D)context).getFontRenderContext());
        }
        return this.font.getMaxCharBounds(gRC);
    }

    public LineMetrics getLineMetrics(CharacterIterator ci, int begin, int limit, Graphics g) {
        FontRenderContext rc = g instanceof Graphics2D ? ((Graphics2D)g).getFontRenderContext() : gRC;
        return this.font.getLineMetrics(ci, begin, limit, rc);
    }

    public Rectangle2D getStringBounds(String str, Graphics context) {
        return this.font.getStringBounds(str, this.getFontRenderContext(context));
    }

    public Rectangle2D getStringBounds(String str, int beginIndex, int limit, Graphics context) {
        return this.font.getStringBounds(str, beginIndex, limit, this.getFontRenderContext(context));
    }

    public Rectangle2D getStringBounds(char[] chars, int beginIndex, int limit, Graphics context) {
        return this.font.getStringBounds(chars, beginIndex, limit, this.getFontRenderContext(context));
    }

    public Rectangle2D getStringBounds(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
        return this.font.getStringBounds(ci, beginIndex, limit, this.getFontRenderContext(context));
    }

    private FontRenderContext getFontRenderContext(Graphics context) {
        if (context instanceof Graphics2D) {
            return ((Graphics2D)context).getFontRenderContext();
        }
        return gRC;
    }

    public boolean hasUniformLineMetrics() {
        return this.font.hasUniformLineMetrics();
    }
}

