/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.AmbleMapper;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontUtils;
import com.sun.javafx.scene.text.FontManager;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import com.sun.t2k.T2KFontFactory;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class PrismFontLoader
extends FontLoader {
    private static PrismFontLoader theInstance = new PrismFontLoader();
    private static boolean lcdEnabled;
    private boolean embeddedFontsLoaded = false;
    private boolean runtimeEmbeddedFontsLoaded = false;
    private boolean runtimeEmbeddedFontsInstalled = false;
    static Map<String, String> cacheRTFontNameToPathMap;
    private static boolean lcdTextSupported;
    FontFactory installedFontFactory = null;

    public static PrismFontLoader getInstance() {
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEmbeddedFonts() {
        if (!this.embeddedFontsLoaded) {
            String[] stringArray = FontManager.getInstance().getAllNames();
            FontFactory fontFactory = this.getFontFactoryFromPipeline();
            for (String string : stringArray) {
                String string2 = FontManager.getInstance().findPathByName(string);
                InputStream inputStream = null;
                try {
                    inputStream = this.getClass().getResourceAsStream(string2);
                    fontFactory.loadEmbeddedFont(string, inputStream, 0.0f, true);
                }
                catch (Exception exception) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.embeddedFontsLoaded = true;
        }
    }

    private void loadRuntimeEmbeddedFonts() {
        if (!this.runtimeEmbeddedFontsInstalled) {
            return;
        }
        if (!this.runtimeEmbeddedFontsLoaded) {
            String[] stringArray = AmbleMapper.getAllFullNames();
            FontFactory fontFactory = this.getFontFactoryFromPipeline();
            for (String string : stringArray) {
                String string2 = null;
                String string3 = string.toLowerCase();
                if (cacheRTFontNameToPathMap.containsKey(string3)) continue;
                string2 = AmbleMapper.getFilePath(string);
                cacheRTFontNameToPathMap.put(string3, string2);
                if (string2 == null) continue;
                fontFactory.loadEmbeddedFont(string, string2, 0.0f, true);
            }
            this.runtimeEmbeddedFontsLoaded = true;
        }
    }

    @Override
    public Font font(Object object, float f) {
        InputStream inputStream;
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        PGFont pGFont = fontFactory.loadEmbeddedFont(null, inputStream = (InputStream)object, f, true);
        if (pGFont != null) {
            return this.createFont(pGFont);
        }
        return new Font("System Regular", f);
    }

    @Override
    public Font loadFont(InputStream inputStream, double d) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        PGFont pGFont = fontFactory.loadEmbeddedFont(null, inputStream, (float)d, true);
        if (pGFont != null) {
            return this.createFont(pGFont);
        }
        return null;
    }

    @Override
    public Font loadFont(String string, double d) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        PGFont pGFont = fontFactory.loadEmbeddedFont(null, string, (float)d, true);
        if (pGFont != null) {
            return this.createFont(pGFont);
        }
        return null;
    }

    private Font createFont(PGFont pGFont) {
        return Font.impl_NativeFont(pGFont, pGFont.getName(), pGFont.getFamilyName(), pGFont.getStyleName(), pGFont.getSize());
    }

    @Override
    public List<String> getFamilies() {
        this.loadEmbeddedFonts();
        this.loadRuntimeEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFamilyNames());
    }

    @Override
    public List<String> getFontNames() {
        this.loadEmbeddedFonts();
        this.loadRuntimeEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames());
    }

    @Override
    public List<String> getFontNames(String string) {
        this.loadEmbeddedFonts();
        this.loadRuntimeEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames(string));
    }

    @Override
    public Font font(String string, FontWeight fontWeight, FontPosture fontPosture, float f) {
        Object object;
        PGFont pGFont = null;
        if (fontWeight == null) {
            fontWeight = FontWeight.NORMAL;
        }
        if (fontPosture == null) {
            fontPosture = FontPosture.REGULAR;
        }
        if (this.runtimeEmbeddedFontsInstalled && string.toLowerCase().startsWith("amble")) {
            object = string.toLowerCase();
            String string2 = "Amble";
            FontFactory fontFactory = this.getFontFactoryFromPipeline();
            boolean bl = false;
            boolean bl2 = ((String)object).contains("lt");
            switch (fontWeight) {
                case THIN: 
                case EXTRA_LIGHT: 
                case LIGHT: {
                    string2 = string2 + " Light";
                    break;
                }
                case NORMAL: 
                case MEDIUM: 
                case SEMI_BOLD: {
                    if (bl2) {
                        string2 = string2 + " Light";
                        break;
                    }
                    bl = true;
                    break;
                }
                case BOLD: 
                case EXTRA_BOLD: 
                case BLACK: {
                    if (bl2) {
                        bl = true;
                        break;
                    }
                    string2 = string2 + " Bold";
                    boolean bl3 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (((String)object).contains("cn")) {
                string2 = string2 + " Condensed";
                bl = false;
            }
            switch (fontPosture) {
                case ITALIC: {
                    boolean bl4 = true;
                    string2 = string2 + " Italic";
                    break;
                }
                default: {
                    if (!bl) break;
                    string2 = "Amble Regular";
                }
            }
            String string3 = string2.toLowerCase();
            if (!cacheRTFontNameToPathMap.containsKey(string3)) {
                String string4 = AmbleMapper.getFilePath(string2);
                cacheRTFontNameToPathMap.put(string3, string4);
                if (string4 != null && !this.runtimeEmbeddedFontsLoaded) {
                    pGFont = fontFactory.loadEmbeddedFont(string2, string4, f, true);
                    string2 = pGFont != null ? pGFont.getFullName() : null;
                }
            } else {
                String string5 = cacheRTFontNameToPathMap.get(string3);
            }
            if (pGFont == null) {
                pGFont = fontFactory.createFont(string2, f);
            }
        } else {
            boolean bl = fontWeight != null && fontWeight.ordinal() >= FontWeight.BOLD.ordinal();
            boolean bl5 = fontPosture == FontPosture.ITALIC;
            float f2 = f <= 0.0f ? 1.0f : f;
            pGFont = this.getFontFactoryFromPipeline().createFont(string, bl, bl5, f2);
        }
        object = Font.impl_NativeFont(pGFont, pGFont.getName(), pGFont.getFamilyName(), pGFont.getStyleName(), f);
        return object;
    }

    @Override
    public void loadFont(Font font) {
        String string;
        this.loadEmbeddedFonts();
        boolean bl = false;
        PGFont pGFont = null;
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        String string2 = font.getName();
        String string3 = string2.toLowerCase();
        if (this.runtimeEmbeddedFontsInstalled && string3.startsWith("amble") && !this.runtimeEmbeddedFontsLoaded) {
            if (!cacheRTFontNameToPathMap.containsKey(string3)) {
                string = AmbleMapper.getFilePath(string2);
                cacheRTFontNameToPathMap.put(string3, string);
                if (string != null) {
                    pGFont = fontFactory.loadEmbeddedFont(string2, string, (float)font.getSize(), true);
                    string2 = pGFont != null ? pGFont.getFullName() : null;
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (pGFont == null) {
            pGFont = fontFactory.createFont(string2, (float)font.getSize());
        }
        if (bl) {
            font.impl_setNativeFont(pGFont, pGFont.getName(), "", "");
        } else {
            string = pGFont.getName();
            String string4 = pGFont.getFamilyName();
            String string5 = pGFont.getStyleName();
            font.impl_setNativeFont(pGFont, string, string4, string5);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (font != null) {
            PGFont pGFont = (PGFont)font.impl_getNativeFont();
            FontStrike.Metrics metrics = PrismFontUtils.getFontMetrics(pGFont);
            float f = -metrics.getAscent();
            float f2 = -metrics.getAscent();
            float f3 = metrics.getXHeight();
            float f4 = metrics.getDescent();
            float f5 = metrics.getDescent();
            float f6 = metrics.getLineGap();
            return FontMetrics.impl_createFontMetrics(f, f2, f3, f4, f5, f6, font);
        }
        return null;
    }

    @Override
    public float computeStringWidth(String string, Font font) {
        PGFont pGFont = (PGFont)font.impl_getNativeFont();
        return (float)PrismFontUtils.computeStringWidth(pGFont, string);
    }

    @Override
    public float getSystemFontSize() {
        return T2KFontFactory.getSystemFontSize();
    }

    public static boolean isLCDTextSupported() {
        return lcdEnabled && lcdTextSupported;
    }

    public FontFactory getFontFactoryFromPipeline() {
        if (this.installedFontFactory != null) {
            return this.installedFontFactory;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.prism.GraphicsPipeline");
            Method method = clazz.getMethod("getPipeline", null);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("getFontFactory", null);
            Object object2 = method2.invoke(object, new Object[0]);
            this.installedFontFactory = (FontFactory)object2;
            String string = object.getClass().getName();
            lcdTextSupported = string.indexOf("ES1Pipe") == -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.installedFontFactory;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = PlatformUtil.isMac() ? "false" : "true";
                String string2 = System.getProperty("prism.lcdtext", string);
                lcdEnabled = string2.equals("true");
                return null;
            }
        });
        cacheRTFontNameToPathMap = new HashMap<String, String>();
    }
}

