/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Device;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class Gt06ProtocolDecoder
extends BaseProtocolDecoder {
    private final Map<Integer, ByteBuf> photos = new HashMap<Integer, ByteBuf>();
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS = 16;
    public static final int MSG_LBS = 17;
    public static final int MSG_GPS_LBS_1 = 18;
    public static final int MSG_GPS_LBS_2 = 34;
    public static final int MSG_STATUS = 19;
    public static final int MSG_SATELLITE = 20;
    public static final int MSG_STRING = 21;
    public static final int MSG_GPS_LBS_STATUS_1 = 22;
    public static final int MSG_WIFI = 23;
    public static final int MSG_GPS_LBS_STATUS_2 = 38;
    public static final int MSG_GPS_LBS_STATUS_3 = 39;
    public static final int MSG_LBS_MULTIPLE = 40;
    public static final int MSG_LBS_WIFI = 44;
    public static final int MSG_LBS_EXTEND = 24;
    public static final int MSG_LBS_STATUS = 25;
    public static final int MSG_GPS_PHONE = 26;
    public static final int MSG_GPS_LBS_EXTEND = 30;
    public static final int MSG_HEARTBEAT = 35;
    public static final int MSG_ADDRESS_REQUEST = 42;
    public static final int MSG_ADDRESS_RESPONSE = 151;
    public static final int MSG_AZ735_GPS = 50;
    public static final int MSG_AZ735_ALARM = 51;
    public static final int MSG_X1_GPS = 52;
    public static final int MSG_X1_PHOTO_INFO = 53;
    public static final int MSG_X1_PHOTO_DATA = 54;
    public static final int MSG_WIFI_2 = 105;
    public static final int MSG_COMMAND_0 = 128;
    public static final int MSG_COMMAND_1 = 129;
    public static final int MSG_COMMAND_2 = 130;
    public static final int MSG_TIME_REQUEST = 138;
    public static final int MSG_INFO = 148;
    public static final int MSG_STRING_INFO = 33;
    public static final int MSG_GPS_2 = 160;
    public static final int MSG_LBS_2 = 161;
    public static final int MSG_WIFI_3 = 162;
    public static final int MSG_FENCE_SINGLE = 163;
    public static final int MSG_FENCE_MULTI = 164;
    public static final int MSG_LBS_ALARM = 165;
    public static final int MSG_LBS_ADDRESS = 167;
    public static final int MSG_OBD = 140;
    public static final int MSG_DTC = 101;
    public static final int MSG_PID = 102;
    private static final Pattern PATTERN_FUEL = new PatternBuilder().text("!AIOIL,").number("d+,").number("d+.d+,").number("(d+.d+),").expression("[^,]+,").number("dd").number("d").number("d,").number("(d+.d+),").expression("[01],").number("d+,").number("xx").compile();
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().text("Current position!").number("Lat:([NS])(d+.d+),").number("Lon:([EW])(d+.d+),").text("Course:").number("(d+.d+),").text("Speed:").number("(d+.d+),").text("DateTime:").number("(dddd)-(dd)-(dd) +").number("(dd):(dd):(dd)").compile();

    public Gt06ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static boolean isSupported(int type) {
        return Gt06ProtocolDecoder.hasGps(type) || Gt06ProtocolDecoder.hasLbs(type) || Gt06ProtocolDecoder.hasStatus(type);
    }

    private static boolean hasGps(int type) {
        switch (type) {
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 39: 
            case 160: 
            case 163: 
            case 164: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasLbs(int type) {
        switch (type) {
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 34: 
            case 38: 
            case 39: 
            case 160: 
            case 163: 
            case 164: 
            case 165: 
            case 167: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasStatus(int type) {
        switch (type) {
            case 19: 
            case 22: 
            case 25: 
            case 38: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasLanguage(int type) {
        switch (type) {
            case 26: 
            case 35: 
            case 39: 
            case 40: 
            case 161: 
            case 164: {
                return true;
            }
        }
        return false;
    }

    private void sendResponse(Channel channel, boolean extended, int type, int index, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            int length = 5 + (content != null ? content.readableBytes() : 0);
            if (extended) {
                response.writeShort(31097);
                response.writeShort(length);
            } else {
                response.writeShort(30840);
                response.writeByte(length);
            }
            response.writeByte(type);
            if (content != null) {
                response.writeBytes(content);
                content.release();
            }
            response.writeShort(index);
            response.writeShort(Checksum.crc16(Checksum.CRC16_X25, response.nioBuffer(2, response.writerIndex() - 2)));
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private void sendPhotoRequest(Channel channel, int pictureId) {
        ByteBuf photo = this.photos.get(pictureId);
        ByteBuf content = Unpooled.buffer();
        content.writeInt(pictureId);
        content.writeInt(photo.writerIndex());
        content.writeShort(Math.min(photo.writableBytes(), 1024));
        this.sendResponse(channel, false, 54, 0, content);
    }

    private boolean decodeGps(Position position, ByteBuf buf, boolean hasLength, TimeZone timezone) {
        DateBuilder dateBuilder = new DateBuilder(timezone).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        position.setTime(dateBuilder.getDate());
        if (hasLength && buf.readUnsignedByte() == 0) {
            return false;
        }
        position.set("sat", BitUtil.to(buf.readUnsignedByte(), 4));
        double latitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
        double longitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        int flags = buf.readUnsignedShort();
        position.setCourse(BitUtil.to(flags, 10));
        position.setValid(BitUtil.check(flags, 12));
        if (!BitUtil.check(flags, 10)) {
            latitude = -latitude;
        }
        if (BitUtil.check(flags, 11)) {
            longitude = -longitude;
        }
        position.setLatitude(latitude);
        position.setLongitude(longitude);
        if (BitUtil.check(flags, 14)) {
            position.set("ignition", BitUtil.check(flags, 15));
        }
        return true;
    }

    private boolean decodeLbs(Position position, ByteBuf buf, boolean hasLength) {
        short length = 0;
        if (hasLength && (length = buf.readUnsignedByte()) == 0) {
            return false;
        }
        int mcc = buf.readUnsignedShort();
        int mnc = BitUtil.check(mcc, 15) ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
        position.setNetwork(new Network(CellTower.from(BitUtil.to(mcc, 15), mnc, buf.readUnsignedShort(), buf.readUnsignedMedium())));
        if (length > 9) {
            buf.skipBytes(length - 9);
        }
        return true;
    }

    private boolean decodeStatus(Position position, ByteBuf buf) {
        short status = buf.readUnsignedByte();
        position.set("status", Integer.valueOf(status));
        position.set("ignition", BitUtil.check(status, 1));
        position.set("charge", BitUtil.check(status, 2));
        position.set("blocked", BitUtil.check(status, 7));
        switch (BitUtil.between(status, 3, 6)) {
            case 1: {
                position.set("alarm", "shock");
                break;
            }
            case 2: {
                position.set("alarm", "powerCut");
                break;
            }
            case 3: {
                position.set("alarm", "lowBattery");
                break;
            }
            case 4: {
                position.set("alarm", "sos");
                break;
            }
        }
        position.set("batteryLevel", buf.readUnsignedByte() * 100 / 6);
        position.set("rssi", buf.readUnsignedByte());
        position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
        return true;
    }

    private String decodeAlarm(short value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 2: {
                return "powerCut";
            }
            case 3: 
            case 9: {
                return "vibration";
            }
            case 4: {
                return "geofenceEnter";
            }
            case 5: {
                return "geofenceExit";
            }
            case 6: {
                return "overspeed";
            }
            case 14: 
            case 15: {
                return "lowBattery";
            }
            case 17: {
                return "powerOff";
            }
            case 19: {
                return "tampering";
            }
            case 20: {
                return "door";
            }
            case 41: {
                return "hardAcceleration";
            }
            case 48: {
                return "hardBraking";
            }
            case 42: 
            case 43: {
                return "hardCornering";
            }
            case 44: {
                return "accident";
            }
            case 35: {
                return "fallDown";
            }
        }
        return null;
    }

    private Position decodeFuelData(Position position, String sentence) {
        Parser parser = new Parser(PATTERN_FUEL, sentence);
        if (!parser.matches()) {
            return null;
        }
        position.set("temp1", parser.nextDouble(0.0));
        position.set("fuel", parser.nextDouble(0.0));
        return position;
    }

    private Position decodeLocationString(Position position, String sentence) {
        Parser parser = new Parser(PATTERN_LOCATION, sentence);
        if (!parser.matches()) {
            return null;
        }
        position.setValid(true);
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
        position.setCourse(parser.nextDouble());
        position.setSpeed(parser.nextDouble());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.YMD_HMS));
        return position;
    }

    private Object decodeBasic(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        short length = buf.readUnsignedByte();
        int dataLength = length - 5;
        short type = buf.readUnsignedByte();
        DeviceSession deviceSession = null;
        if (type != 1) {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            if (deviceSession.getTimeZone() == null) {
                deviceSession.setTimeZone(this.getTimeZone(deviceSession.getDeviceId()));
            }
        }
        if (type == 1) {
            String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
            buf.readUnsignedShort();
            deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            if (deviceSession != null && deviceSession.getTimeZone() == null) {
                deviceSession.setTimeZone(this.getTimeZone(deviceSession.getDeviceId()));
            }
            if (dataLength > 10) {
                TimeZone timeZone;
                int extensionBits = buf.readUnsignedShort();
                int hours = (extensionBits >> 4) / 100;
                int minutes = (extensionBits >> 4) % 100;
                int offset = (hours * 60 + minutes) * 60;
                if ((extensionBits & 8) != 0) {
                    offset = -offset;
                }
                if (deviceSession != null && (timeZone = deviceSession.getTimeZone()).getRawOffset() == 0) {
                    timeZone.setRawOffset(offset * 1000);
                    deviceSession.setTimeZone(timeZone);
                }
            }
            if (deviceSession != null) {
                this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
            }
        } else {
            if (type == 35) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                short status = buf.readUnsignedByte();
                position.set("armed", BitUtil.check(status, 0));
                position.set("ignition", BitUtil.check(status, 1));
                position.set("charge", BitUtil.check(status, 2));
                if (buf.readableBytes() >= 8) {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.01);
                }
                if (buf.readableBytes() >= 7) {
                    position.set("rssi", buf.readUnsignedByte());
                }
                this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
                return position;
            }
            if (type == 42) {
                String response = "NA&&NA&&0##";
                ByteBuf content = Unpooled.buffer();
                content.writeByte(response.length());
                content.writeInt(0);
                content.writeBytes(response.getBytes(StandardCharsets.US_ASCII));
                this.sendResponse(channel, true, 151, 0, content);
            } else if (type == 138) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                ByteBuf content = Unpooled.buffer();
                content.writeByte(calendar.get(1) - 2000);
                content.writeByte(calendar.get(2) + 1);
                content.writeByte(calendar.get(5));
                content.writeByte(calendar.get(11));
                content.writeByte(calendar.get(12));
                content.writeByte(calendar.get(13));
                this.sendResponse(channel, false, 138, 0, content);
            } else {
                if (type == 52 || type == 53) {
                    return this.decodeX1(channel, buf, deviceSession, type);
                }
                if (type == 23 || type == 105) {
                    return this.decodeWifi(channel, buf, deviceSession, type);
                }
                if (type == 148) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    this.getLastLocation(position, null);
                    position.set("power", (double)buf.readShort() * 0.01);
                    return position;
                }
                return this.decodeBasicOther(channel, buf, deviceSession, type, dataLength);
            }
        }
        return null;
    }

    private Object decodeX1(Channel channel, ByteBuf buf, DeviceSession deviceSession, int type) {
        if (type == 52) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            buf.readUnsignedInt();
            this.decodeGps(position, buf, false, deviceSession.getTimeZone());
            buf.readUnsignedShort();
            position.set("odometer", buf.readUnsignedInt());
            position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedByte(), buf.readUnsignedShort(), buf.readUnsignedInt())));
            long driverId = buf.readUnsignedInt();
            if (driverId > 0L) {
                position.set("driverUniqueId", String.valueOf(driverId));
            }
            position.set("battery", (double)buf.readUnsignedShort() * 0.01);
            position.set("power", (double)buf.readUnsignedShort() * 0.01);
            return position;
        }
        if (type == 53) {
            buf.skipBytes(6);
            buf.readUnsignedByte();
            buf.readUnsignedInt();
            buf.readUnsignedInt();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            ByteBuf photo = Unpooled.buffer((int)buf.readInt());
            int pictureId = buf.readInt();
            this.photos.put(pictureId, photo);
            this.sendPhotoRequest(channel, pictureId);
        }
        return null;
    }

    private Object decodeWifi(Channel channel, ByteBuf buf, DeviceSession deviceSession, int type) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        ByteBuf time = buf.readSlice(6);
        DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(time, 2)).setMonth(BcdUtil.readInteger(time, 2)).setDay(BcdUtil.readInteger(time, 2)).setHour(BcdUtil.readInteger(time, 2)).setMinute(BcdUtil.readInteger(time, 2)).setSecond(BcdUtil.readInteger(time, 2));
        this.getLastLocation(position, dateBuilder.getDate());
        Network network = new Network();
        int wifiCount = buf.getByte(2);
        for (int i = 0; i < wifiCount; ++i) {
            String mac = String.format("%02x:%02x:%02x:%02x:%02x:%02x", buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            network.addWifiAccessPoint(WifiAccessPoint.from(mac, buf.readUnsignedByte()));
        }
        int cellCount = buf.readUnsignedByte();
        int mcc = buf.readUnsignedShort();
        short mnc = buf.readUnsignedByte();
        for (int i = 0; i < cellCount; ++i) {
            network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
        }
        position.setNetwork(network);
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(30840);
            response.writeByte(0);
            response.writeByte(type);
            response.writeBytes(time.resetReaderIndex());
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
        return position;
    }

    private Object decodeBasicOther(Channel channel, ByteBuf buf, DeviceSession deviceSession, int type, int dataLength) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (type == 40 || type == 24 || type == 44 || type == 161 || type == 162) {
            boolean longFormat = type == 161 || type == 162;
            DateBuilder dateBuilder = new DateBuilder(deviceSession.getTimeZone()).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            this.getLastLocation(position, dateBuilder.getDate());
            int mcc = buf.readUnsignedShort();
            int mnc = BitUtil.check(mcc, 15) ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
            Network network = new Network();
            for (int i = 0; i < 7; ++i) {
                int lac = longFormat ? buf.readInt() : buf.readUnsignedShort();
                int cid = longFormat ? (int)buf.readLong() : buf.readUnsignedMedium();
                short rssi = -buf.readUnsignedByte();
                if (lac <= 0) continue;
                network.addCellTower(CellTower.from(BitUtil.to(mcc, 15), mnc, lac, cid, rssi));
            }
            buf.readUnsignedByte();
            if (type != 40 && type != 161) {
                int wifiCount = buf.readUnsignedByte();
                for (int i = 0; i < wifiCount; ++i) {
                    String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                    network.addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), buf.readUnsignedByte()));
                }
            }
            position.setNetwork(network);
        } else if (type == 21) {
            this.getLastLocation(position, null);
            short commandLength = buf.readUnsignedByte();
            if (commandLength > 0) {
                buf.readUnsignedByte();
                position.set("result", buf.readSlice(commandLength - 1).toString(StandardCharsets.US_ASCII));
            }
        } else if (Gt06ProtocolDecoder.isSupported(type)) {
            if (Gt06ProtocolDecoder.hasGps(type)) {
                this.decodeGps(position, buf, false, deviceSession.getTimeZone());
            } else {
                this.getLastLocation(position, null);
            }
            if (Gt06ProtocolDecoder.hasLbs(type)) {
                this.decodeLbs(position, buf, Gt06ProtocolDecoder.hasStatus(type));
            }
            if (Gt06ProtocolDecoder.hasStatus(type)) {
                this.decodeStatus(position, buf);
            }
            if (type == 18 && buf.readableBytes() >= 10) {
                position.set("odometer", buf.readUnsignedInt());
            }
            if (type == 34 && buf.readableBytes() >= 9) {
                position.set("ignition", buf.readUnsignedByte() > 0);
                position.set("event", buf.readUnsignedByte());
                position.set("archive", buf.readUnsignedByte() > 0);
            }
        } else {
            if (dataLength > 0) {
                buf.skipBytes(dataLength);
            }
            if (type != 128 && type != 129 && type != 130) {
                this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
            }
            return null;
        }
        if (Gt06ProtocolDecoder.hasLanguage(type)) {
            buf.readUnsignedShort();
        }
        if (type == 39 || type == 164) {
            position.set("geofence", buf.readUnsignedByte());
        }
        this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
        return position;
    }

    private Object decodeExtended(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (deviceSession.getTimeZone() == null) {
            deviceSession.setTimeZone(this.getTimeZone(deviceSession.getDeviceId()));
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedShort();
        short type = buf.readUnsignedByte();
        if (type == 33) {
            buf.readUnsignedInt();
            String data = buf.readUnsignedByte() == 1 ? buf.readSlice(buf.readableBytes() - 6).toString(StandardCharsets.US_ASCII) : buf.readSlice(buf.readableBytes() - 6).toString(StandardCharsets.UTF_16BE);
            if (this.decodeLocationString(position, data) == null) {
                this.getLastLocation(position, null);
                position.set("result", data);
            }
            return position;
        }
        if (type == 148) {
            short subType = buf.readUnsignedByte();
            this.getLastLocation(position, null);
            if (subType == 0) {
                position.set("power", (double)buf.readUnsignedShort() * 0.01);
                return position;
            }
            if (subType == 5) {
                short flags = buf.readUnsignedByte();
                position.set("door", BitUtil.check(flags, 0));
                position.set("io1", BitUtil.check(flags, 2));
                return position;
            }
            if (subType == 10) {
                buf.skipBytes(8);
                buf.skipBytes(8);
                position.set("iccid", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)));
                return position;
            }
            if (subType == 13) {
                if (buf.getByte(buf.readerIndex()) != 33) {
                    buf.skipBytes(6);
                }
                return this.decodeFuelData(position, buf.toString(buf.readerIndex(), buf.readableBytes() - 4 - 2, StandardCharsets.US_ASCII));
            }
        } else if (type == 54) {
            int pictureId = buf.readInt();
            ByteBuf photo = this.photos.get(pictureId);
            buf.readUnsignedInt();
            buf.readBytes(photo, buf.readUnsignedShort());
            if (photo.writableBytes() > 0) {
                this.sendPhotoRequest(channel, pictureId);
            } else {
                Device device = (Device)Context.getDeviceManager().getById(deviceSession.getDeviceId());
                position.set("image", Context.getMediaManager().writeFile(device.getUniqueId(), photo, "jpg"));
                this.photos.remove(pictureId).release();
            }
        } else {
            if (type == 50 || type == 51) {
                if (!this.decodeGps(position, buf, true, deviceSession.getTimeZone())) {
                    this.getLastLocation(position, position.getDeviceTime());
                }
                if (this.decodeLbs(position, buf, true)) {
                    position.set("rssi", buf.readUnsignedByte());
                }
                buf.skipBytes((int)buf.readUnsignedByte());
                buf.skipBytes((int)buf.readUnsignedByte());
                short status = buf.readUnsignedByte();
                position.set("status", Integer.valueOf(status));
                if (type == 51) {
                    switch (status) {
                        case 160: {
                            position.set("armed", true);
                            break;
                        }
                        case 161: {
                            position.set("armed", false);
                            break;
                        }
                        case 162: 
                        case 163: {
                            position.set("alarm", "lowBattery");
                            break;
                        }
                        case 164: {
                            position.set("alarm", "general");
                            break;
                        }
                        case 165: {
                            position.set("alarm", "door");
                            break;
                        }
                    }
                }
                buf.skipBytes((int)buf.readUnsignedByte());
                this.sendResponse(channel, true, type, buf.getShort(buf.writerIndex() - 6), null);
                return position;
            }
            if (type == 140) {
                DateBuilder dateBuilder = new DateBuilder(deviceSession.getTimeZone()).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                this.getLastLocation(position, dateBuilder.getDate());
                position.set("ignition", buf.readUnsignedByte() > 0);
                String data = buf.readCharSequence(buf.readableBytes() - 18, StandardCharsets.US_ASCII).toString();
                block17: for (String pair : data.split(",")) {
                    String[] values = pair.split("=");
                    switch (Integer.parseInt(values[0].substring(0, 2), 16)) {
                        case 40: {
                            position.set("odometer", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block17;
                        }
                        case 43: {
                            position.set("fuel", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block17;
                        }
                        case 45: {
                            position.set("coolantTemp", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block17;
                        }
                        case 53: {
                            position.set("obdSpeed", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block17;
                        }
                        case 54: {
                            position.set("rpm", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block17;
                        }
                        case 71: {
                            position.set("fuelUsed", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block17;
                        }
                        case 73: {
                            position.set("hours", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block17;
                        }
                        case 74: {
                            position.set("vin", values[1]);
                            continue block17;
                        }
                    }
                }
                return position;
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short header = buf.readShort();
        if (header == 30840) {
            return this.decodeBasic(channel, remoteAddress, buf);
        }
        if (header == 31097) {
            return this.decodeExtended(channel, remoteAddress, buf);
        }
        return null;
    }
}

