/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;

public class EelinkProtocolEncoder
extends BaseProtocolEncoder {
    private boolean connectionless;

    public EelinkProtocolEncoder(boolean connectionless) {
        this.connectionless = connectionless;
    }

    public static int checksum(ByteBuffer buf) {
        int sum = 0;
        while (buf.hasRemaining()) {
            sum = (sum << 1 | sum >> 15) + (buf.get() & 0xFF) & 0xFFFF;
        }
        return sum;
    }

    public static ByteBuf encodeContent(boolean connectionless, String uniqueId, int type, int index, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        if (connectionless) {
            buf.writeBytes(DataConverter.parseHex('0' + uniqueId));
        }
        buf.writeByte(103);
        buf.writeByte(103);
        buf.writeByte(type);
        buf.writeShort(2 + (content != null ? content.readableBytes() : 0));
        buf.writeShort(index);
        if (content != null) {
            buf.writeBytes(content);
        }
        ByteBuf result = Unpooled.buffer();
        if (connectionless) {
            result.writeByte(69);
            result.writeByte(76);
            result.writeShort(2 + buf.readableBytes());
            result.writeShort(EelinkProtocolEncoder.checksum(buf.nioBuffer()));
        }
        result.writeBytes(buf);
        buf.release();
        return result;
    }

    private ByteBuf encodeContent(long deviceId, String content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(1);
        buf.writeInt(0);
        buf.writeBytes(content.getBytes(StandardCharsets.UTF_8));
        return EelinkProtocolEncoder.encodeContent(this.connectionless, this.getUniqueId(deviceId), 128, 0, buf);
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.encodeContent(command.getDeviceId(), command.getString("data"));
            }
            case "positionSingle": {
                return this.encodeContent(command.getDeviceId(), "WHERE#");
            }
            case "engineStop": {
                return this.encodeContent(command.getDeviceId(), "RELAY,1#");
            }
            case "engineResume": {
                return this.encodeContent(command.getDeviceId(), "RELAY,0#");
            }
            case "rebootDevice": {
                return this.encodeContent(command.getDeviceId(), "RESET#");
            }
        }
        return null;
    }
}

