/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.NetworkMessage;
import org.traccar.model.Command;
import org.traccar.model.Device;

public abstract class BaseProtocolEncoder
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseProtocolEncoder.class);

    protected String getUniqueId(long deviceId) {
        return Context.getIdentityManager().getById(deviceId).getUniqueId();
    }

    protected void initDevicePassword(Command command, String defaultPassword) {
        if (!command.getAttributes().containsKey("devicePassword")) {
            Device device = Context.getIdentityManager().getById(command.getDeviceId());
            String password = device.getString("devicePassword");
            if (password != null) {
                command.set("devicePassword", password);
            } else {
                command.set("devicePassword", defaultPassword);
            }
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        NetworkMessage networkMessage = (NetworkMessage)msg;
        if (networkMessage.getMessage() instanceof Command) {
            Command command = (Command)networkMessage.getMessage();
            Object encodedCommand = this.encodeCommand(ctx.channel(), command);
            StringBuilder s = new StringBuilder();
            s.append("[").append(ctx.channel().id().asShortText()).append("] ");
            s.append("id: ").append(this.getUniqueId(command.getDeviceId())).append(", ");
            s.append("command type: ").append(command.getType()).append(" ");
            if (encodedCommand != null) {
                s.append("sent");
            } else {
                s.append("not sent");
            }
            LOGGER.info(s.toString());
            ctx.write((Object)new NetworkMessage(encodedCommand, networkMessage.getRemoteAddress()), promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    protected Object encodeCommand(Channel channel, Command command) {
        return this.encodeCommand(command);
    }

    protected Object encodeCommand(Command command) {
        return null;
    }
}

