/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.editorpane;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class Utils {
    private static final String[] SCHEMES = new String[]{"http://", "https://", "file:/", "www."};
    private static final String[] PREFIXES = new String[]{"", "", "", "http://"};

    public static String text2html(String text) {
        text = text == null ? "" : text;
        text = StringEscapeUtils.escapeXml((String)text);
        text = Utils.convertURLs(text);
        text = Utils.preserveWhitespace(text);
        text = Utils.fixProblems(text);
        return "<html><body>" + text + "</body></html>";
    }

    private static String convertURLs(String string) {
        String skipped;
        StringBuffer sb = new StringBuffer();
        int lastEnd = 0;
        Pattern pattern = Pattern.compile("\\[[^\\[\\]]+\\]|[\\S]+");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            skipped = string.substring(lastEnd, matcher.start());
            sb.append(skipped);
            String segment = string.substring(matcher.start(), matcher.end());
            if (segment.startsWith("[")) {
                sb.append(Utils.processBracketed(segment));
            } else {
                sb.append(Utils.processNotBracketed(segment));
            }
            lastEnd = matcher.end();
        }
        skipped = string.substring(lastEnd, string.length());
        sb.append(skipped);
        return sb.toString();
    }

    private static String processBracketed(String string) {
        String str = string.substring(1, string.length() - 1);
        for (int i = 0; i < SCHEMES.length; ++i) {
            String txt;
            String url;
            if (!str.startsWith(SCHEMES[i])) continue;
            int p = str.indexOf("|");
            if (p == -1) {
                url = PREFIXES[i] + str;
                txt = str;
            } else {
                url = PREFIXES[i] + str.substring(0, p);
                txt = str.substring(p + 1);
            }
            return "<a href=\"" + url + "\">" + txt + "</a>";
        }
        return string;
    }

    private static String processNotBracketed(String string) {
        for (int i = 0; i < SCHEMES.length; ++i) {
            if (!string.startsWith(SCHEMES[i])) continue;
            String url = PREFIXES[i] + string;
            return "<a href=\"" + url + "\">" + string + "</a>";
        }
        return string;
    }

    private static String preserveWhitespace(String html) {
        html = html.replace("\r\n", "<br>");
        html = html.replace("\r", "<br>");
        html = html.replace("\n", "<br>");
        html = html.replace("  ", "&nbsp;&nbsp;");
        html = html.replace("\u000b", "&nbsp;");
        html = html.replace("\t", "&nbsp;");
        html = html.replace("\f", "&nbsp;");
        html = html.replace("\r", "&nbsp;");
        return html;
    }

    private static String fixProblems(String html) {
        html = html.replace("&apos;", "'");
        return html;
    }
}

