/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.TreeVisitor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNodeVisitor<T>
implements TreeVisitor {
    protected static final Logger LOG = Logger.getInstance(AbstractTreeNodeVisitor.class);
    private final Supplier<? extends T> supplier;
    private final Predicate<? super TreePath> predicate;

    public AbstractTreeNodeVisitor(@NotNull Supplier<? extends T> supplier, @Nullable Predicate<? super TreePath> predicate) {
        if (supplier == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(0);
        }
        this.supplier = supplier;
        this.predicate = predicate;
    }

    @Nullable
    public final T getElement() {
        return this.supplier.get();
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        T element;
        if (path == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("process ", new Object[]{path});
        }
        if ((element = this.getElement()) == null) {
            TreeVisitor.Action action = TreeVisitor.Action.SKIP_SIBLINGS;
            if (action == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(2);
            }
            return action;
        }
        Object component = path.getLastPathComponent();
        if (component instanceof AbstractTreeNode) {
            TreeVisitor.Action action = this.visit(path, (AbstractTreeNode)component, element);
            if (action == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(3);
            }
            return action;
        }
        if (component instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            Object object = node.getUserObject();
            if (object instanceof AbstractTreeNode) {
                TreeVisitor.Action action = this.visit(path, (AbstractTreeNode)object, element);
                if (action == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(4);
                }
                return action;
            }
            if (object instanceof String) {
                LOG.debug("ignore children: ", new Object[]{object});
            } else {
                LOG.warn(object == null ? "no object" : "unexpected object " + object.getClass());
            }
        } else if (component instanceof String) {
            LOG.debug("ignore children: ", new Object[]{component});
        } else {
            LOG.warn(component == null ? "no component" : "unexpected component " + component.getClass());
        }
        TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
        if (action == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(5);
        }
        return action;
    }

    @NotNull
    protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull AbstractTreeNode node, @NotNull T element) {
        if (path == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(6);
        }
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(7);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(8);
        }
        if (this.matches(node, element)) {
            LOG.debug("found ", new Object[]{path});
            if (this.predicate == null) {
                TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                if (action == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(9);
                }
                return action;
            }
            if (this.predicate.test(path)) {
                TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(10);
                }
                return action;
            }
        } else if (this.contains(node, element)) {
            LOG.debug("visit ", new Object[]{path});
            TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
            if (action == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(11);
            }
            return action;
        }
        TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
        if (action == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(12);
        }
        return action;
    }

    protected boolean matches(@NotNull AbstractTreeNode node, @NotNull T element) {
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(13);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(14);
        }
        return node.canRepresent(element);
    }

    protected boolean contains(@NotNull AbstractTreeNode node, @NotNull T element) {
        T content;
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(15);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(16);
        }
        return (content = this.getContent(node)) != null && this.isAncestor(content, element);
    }

    protected T getContent(@NotNull AbstractTreeNode node) {
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(17);
        }
        return null;
    }

    protected boolean isAncestor(@NotNull T content, @NotNull T element) {
        if (content == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(18);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(19);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "visit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

