/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestsMerger {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.RequestsMerger");
    private final MyWorker myWorker;
    private final Object myLock = new Object();
    private MyState myState;
    private final Consumer<? super Runnable> myAlarm;
    private final List<Runnable> myWaitingStartListeners = new ArrayList<Runnable>();
    private final List<Runnable> myWaitingFinishListeners = new ArrayList<Runnable>();

    public RequestsMerger(Runnable runnable2, Consumer<? super Runnable> alarm) {
        this.myAlarm = alarm;
        this.myWorker = new MyWorker(runnable2);
        this.myState = MyState.empty;
    }

    public void request() {
        LOG.debug("ext: request");
        this.doAction(MyAction.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return MyState.empty.equals((Object)this.myState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitRefresh(Runnable runnable2) {
        LOG.debug("ext: wait refresh");
        Object object = this.myLock;
        synchronized (object) {
            this.myWaitingStartListeners.add(runnable2);
        }
        this.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(MyAction action) {
        LOG.debug("doAction: START " + action.name());
        ArrayList<Runnable> toBeCalled = null;
        MyExitAction[] myExitActionArray = this.myLock;
        synchronized (this.myLock) {
            MyState oldState = this.myState;
            this.myState = this.myState.transition(action);
            if (oldState.equals((Object)this.myState)) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            MyExitAction[] exitActions = MyTransitionAction.getExit(oldState, this.myState);
            LOG.debug("doAction: oldState: " + oldState.name() + ", newState: " + this.myState.name());
            if (LOG.isDebugEnabled() && exitActions != null) {
                String debugExitActions = StringUtil.join((Object[])exitActions, exitAction -> exitAction.name(), (String)" ");
                LOG.debug("exit actions: " + debugExitActions);
            }
            if (exitActions != null) {
                for (MyExitAction exitAction2 : exitActions) {
                    if (MyExitAction.markStart.equals((Object)exitAction2)) {
                        this.myWaitingFinishListeners.addAll(this.myWaitingStartListeners);
                        this.myWaitingStartListeners.clear();
                        continue;
                    }
                    if (!MyExitAction.markEnd.equals((Object)exitAction2)) continue;
                    toBeCalled = new ArrayList<Runnable>(this.myWaitingFinishListeners);
                    this.myWaitingFinishListeners.clear();
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (exitActions != null) {
                for (MyExitAction exitAction3 : exitActions) {
                    if (!MyExitAction.submitRequestToExecutor.equals((Object)exitAction3)) continue;
                    this.myAlarm.consume((Object)this.myWorker);
                }
            }
            if (toBeCalled != null) {
                for (Runnable runnable2 : toBeCalled) {
                    runnable2.run();
                }
            }
            LOG.debug("doAction: END " + action.name());
            return;
        }
    }

    private static enum MyAction {
        request,
        start,
        finish;

    }

    private static enum MyExitAction {
        empty,
        submitRequestToExecutor,
        markStart,
        markEnd;

    }

    private static class MyTransitionAction {
        private static final Map<Couple<MyState>, MyExitAction[]> myMap = new HashMap<Couple<MyState>, MyExitAction[]>();

        private MyTransitionAction() {
        }

        private static void add(MyState from, MyState to, MyExitAction ... action) {
            myMap.put((Couple<MyState>)Couple.of((Object)((Object)from), (Object)((Object)to)), action);
        }

        @Nullable
        public static MyExitAction[] getExit(MyState from, MyState to) {
            return myMap.get(Couple.of((Object)((Object)from), (Object)((Object)to)));
        }

        static {
            MyTransitionAction.add(MyState.empty, MyState.requestSubmitted, MyExitAction.submitRequestToExecutor);
            MyTransitionAction.add(MyState.requestSubmitted, MyState.inProgress, MyExitAction.markStart);
            MyTransitionAction.add(MyState.inProgress, MyState.empty, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgressRequestSubmitted, MyState.requestSubmitted, MyExitAction.submitRequestToExecutor, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgressRequestSubmitted, MyState.empty, MyExitAction.markEnd);
            MyTransitionAction.add(MyState.inProgress, MyState.requestSubmitted, MyExitAction.markEnd);
        }
    }

    private static enum MyState {
        empty{

            @Override
            @NotNull
            public MyState transition(MyAction action) {
                if (MyAction.request.equals((Object)action)) {
                    MyState myState = requestSubmitted;
                    if (myState == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                MyState.logWrongAction((MyState)this, action);
                1 v1 = this;
                if (v1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return v1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$1", "transition"));
            }
        }
        ,
        inProgress{

            @Override
            @NotNull
            public MyState transition(MyAction action) {
                if (MyAction.finish.equals((Object)action)) {
                    MyState myState = empty;
                    if (myState == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                if (MyAction.request.equals((Object)action)) {
                    MyState myState = inProgressRequestSubmitted;
                    if (myState == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return myState;
                }
                MyState.logWrongAction((MyState)this, action);
                2 v2 = this;
                if (v2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return v2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$2", "transition"));
            }
        }
        ,
        inProgressRequestSubmitted{

            @Override
            @NotNull
            public MyState transition(MyAction action) {
                if (MyAction.finish.equals((Object)action)) {
                    MyState myState = requestSubmitted;
                    if (myState == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                if (MyAction.start.equals((Object)action)) {
                    MyState.logWrongAction((MyState)this, action);
                }
                3 v1 = this;
                if (v1 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return v1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$3", "transition"));
            }
        }
        ,
        requestSubmitted{

            @Override
            @NotNull
            public MyState transition(MyAction action) {
                if (MyAction.start.equals((Object)action)) {
                    MyState myState = inProgress;
                    if (myState == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return myState;
                }
                if (MyAction.finish.equals((Object)action)) {
                    MyState.logWrongAction((MyState)this, action);
                    MyState myState = empty;
                    if (myState == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return myState;
                }
                4 v2 = this;
                if (v2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                return v2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RequestsMerger$MyState$4", "transition"));
            }
        };


        @NotNull
        public abstract MyState transition(MyAction var1);

        private static void logWrongAction(MyState state, MyAction action) {
            LOG.info("Wrong action: state=" + state.name() + ", action=" + action.name());
        }
    }

    private class MyWorker
    implements Runnable {
        private volatile boolean myInitialized;
        private final Runnable myRunnable;

        private MyWorker(Runnable runnable2) {
            this.myRunnable = runnable2;
        }

        @Override
        public void run() {
            LOG.debug("worker: started refresh");
            try {
                RequestsMerger.this.doAction(MyAction.start);
                this.myRunnable.run();
                this.myInitialized = true;
            }
            finally {
                RequestsMerger.this.doAction(MyAction.finish);
            }
        }

        public boolean isInitialized() {
            return this.myInitialized;
        }
    }
}

