/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PathReferenceProviderBase
implements PathReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.paths.PathReferenceProviderBase");

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            PathReferenceProviderBase.$$$reportNull$$$0(0);
        }
        if (references == null) {
            PathReferenceProviderBase.$$$reportNull$$$0(1);
        }
        TextRange range2 = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        int offset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        String elementText = psiElement.getText();
        if (elementText == null) {
            return false;
        }
        for (DynamicContextProvider provider : DynamicContextProvider.EP_NAME.getExtensionList()) {
            int dynamicOffset = provider.getOffset(psiElement, offset, elementText);
            if (dynamicOffset == -1) {
                return false;
            }
            if (dynamicOffset == offset) continue;
            offset = dynamicOffset;
        }
        int pos = PathReferenceProviderBase.getLastPosOfURL(offset, elementText);
        if (pos != -1 && pos < endOffset) {
            endOffset = pos;
        }
        try {
            String text = elementText.substring(offset, endOffset);
            return this.createReferences(psiElement, offset, text, references, soft);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Cannot process string: '" + psiElement.getParent().getParent().getText() + "'", (Throwable)e);
            return false;
        }
    }

    public abstract boolean createReferences(@NotNull PsiElement var1, int var2, String var3, @NotNull List<PsiReference> var4, boolean var5);

    public static int getLastPosOfURL(int offset, @NotNull String url) {
        if (url == null) {
            PathReferenceProviderBase.$$$reportNull$$$0(2);
        }
        for (int i = offset; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/paths/PathReferenceProviderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastPosOfURL";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

