/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.Interval;

class Trapezium {
    private final Interval myBase1;
    private final Interval myBase2;

    Trapezium(int start1, int length1, int start2, int length2) {
        this(new Interval(start1, length1), new Interval(start2, length2));
    }

    Trapezium(Interval base1, Interval base2) {
        this.myBase1 = base1;
        this.myBase2 = base2;
    }

    public Interval getBase1() {
        return this.myBase1;
    }

    public Interval getBase2() {
        return this.myBase2;
    }

    public Interval getBase(FragmentSide side) {
        if (FragmentSide.SIDE1 == side) {
            return this.getBase1();
        }
        if (FragmentSide.SIDE2 == side) {
            return this.getBase2();
        }
        throw side.invalidException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Trapezium)) {
            return false;
        }
        Trapezium other = (Trapezium)obj;
        return this.myBase1.equals(other.myBase1) && this.myBase2.equals(other.myBase2);
    }

    public int hashCode() {
        return this.myBase1.hashCode() ^ this.myBase2.hashCode();
    }

    public String toString() {
        return "{" + this.myBase1 + ", " + this.myBase2 + "}";
    }
}

