/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.impl.exclude.ExcludeListItem;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;

class ValidExcludeListItem
extends ExcludeListItem {
    private final VirtualFile myFile;
    private final FrameworkType myFrameworkType;

    ValidExcludeListItem(FrameworkType frameworkType, VirtualFile file2) {
        this.myFrameworkType = frameworkType;
        this.myFile = file2;
    }

    @Override
    public String getFrameworkTypeId() {
        return this.myFrameworkType != null ? this.myFrameworkType.getId() : null;
    }

    @Override
    public String getFileUrl() {
        return this.myFile != null ? this.myFile.getUrl() : null;
    }

    @Override
    public void renderItem(ColoredListCellRenderer renderer) {
        if (this.myFrameworkType != null) {
            renderer.setIcon(this.myFrameworkType.getIcon());
            renderer.append(this.myFrameworkType.getPresentableName());
            if (this.myFile != null) {
                renderer.append(" in " + this.myFile.getName());
                renderer.append(" (" + this.myFile.getPresentableUrl() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else {
            renderer.setIcon(VirtualFilePresentation.getIcon((VirtualFile)this.myFile));
            renderer.append(this.myFile.getName());
            renderer.append(" (" + this.myFile.getPresentableUrl() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Override
    public String getPresentableFrameworkName() {
        return this.myFrameworkType != null ? this.myFrameworkType.getPresentableName() : null;
    }
}

