/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import java.awt.Color;

public class LvcsHelper {
    private static final Color RED = new JBColor(new Color(250, 220, 220), new Color(104, 67, 67));
    private static final Color GREEN = new JBColor(new Color(220, 250, 220), new Color(44, 66, 60));

    public static void addLabel(TestFrameworkRunningModel model) {
        String label2;
        int color;
        AbstractTestProxy root = model.getRoot();
        if (root.isInterrupted()) {
            return;
        }
        if (root.isPassed() || root.isIgnored()) {
            color = GREEN.getRGB();
            label2 = ExecutionBundle.message((String)"junit.runing.info.tests.passed.label", (Object[])new Object[0]);
        } else {
            color = RED.getRGB();
            label2 = ExecutionBundle.message((String)"junit.runing.info.tests.failed.label", (Object[])new Object[0]);
        }
        TestConsoleProperties consoleProperties = model.getProperties();
        String name = label2 + " " + consoleProperties.getConfiguration().getName();
        Project project = consoleProperties.getProject();
        if (project.isDisposed()) {
            return;
        }
        LocalHistory.getInstance().putSystemLabel(project, name, color);
    }
}

