/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ApplicationStorageManager;
import com.intellij.configurationStore.ComponentStoreWithExtraComponents;
import com.intellij.configurationStore.DefaultProjectExportableAndSaveTrigger;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServiceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/ApplicationStoreImpl;", "Lcom/intellij/configurationStore/ComponentStoreWithExtraComponents;", "application", "Lcom/intellij/openapi/application/Application;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/components/PathMacroManager;)V", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "storageManager", "Lcom/intellij/configurationStore/ApplicationStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ApplicationStorageManager;", "saveAdditionalComponents", "", "isForce", "", "setPath", "path", "", "intellij.platform.configurationStore.impl"})
public final class ApplicationStoreImpl
extends ComponentStoreWithExtraComponents {
    @NotNull
    private final ApplicationStorageManager storageManager;
    private final Application application;

    @Override
    @NotNull
    public ApplicationStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        return this.application.isUnitTestMode() ? StateLoadPolicy.LOAD_ONLY_DEFAULT : StateLoadPolicy.LOAD;
    }

    @Override
    public void setPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.getStorageManager().addMacro("$APP_CONFIG$", path + "/options");
        this.getStorageManager().addMacro("$ROOT_CONFIG$", path);
    }

    @Override
    protected void saveAdditionalComponents(boolean isForce) {
        Object object = ServiceManager.getService(DefaultProjectExportableAndSaveTrigger.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        ((DefaultProjectExportableAndSaveTrigger)object).save(isForce);
    }

    public ApplicationStoreImpl(@NotNull Application application, @Nullable PathMacroManager pathMacroManager) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.application = application;
        this.storageManager = new ApplicationStorageManager(this.application, pathMacroManager);
    }

    public /* synthetic */ ApplicationStoreImpl(Application application, PathMacroManager pathMacroManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pathMacroManager = null;
        }
        this(application, pathMacroManager);
    }
}

