/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSystemWideInterpreterPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/module/Module;Ljava/util/List;)V", "panelName", "", "getPanelName", "()Ljava/lang/String;", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getOrCreateSdk", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.python.community.impl"})
public final class PyAddSystemWideInterpreterPanel
extends PyAddSdkPanel {
    @NotNull
    private final String panelName = "System interpreter";
    private final PySdkPathChoosingComboBox sdkComboBox;
    private final List<Sdk> existingSdks;

    @Override
    @NotNull
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object)PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox));
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk = this.sdkComboBox.getSelectedSdk();
        Sdk sdk2 = sdk;
        return sdk2 instanceof PyDetectedSdk ? PySdkExtKt.setup((PyDetectedSdk)sdk, this.existingSdks) : sdk;
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        ((JComboBox)this.sdkComboBox.getChildComponent()).addItemListener(new ItemListener(listener2){
            final /* synthetic */ Runnable $listener;

            public final void itemStateChanged(ItemEvent it) {
                this.$listener.run();
            }
            {
                this.$listener = runnable;
            }
        });
    }

    public PyAddSystemWideInterpreterPanel(@Nullable Module module2, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        this.existingSdks = existingSdks;
        this.panelName = "System interpreter";
        this.sdkComboBox = new PySdkPathChoosingComboBox(PySdkExtKt.detectSystemWideSdks(module2, this.existingSdks), null);
        this.setLayout(new BorderLayout());
        Object object = new JBLabel(StringsKt.trimMargin$default((String)"|<html><strong>Note:</strong> You'll need admin permissions to install packages for this interpreter. Consider\n         |creating a per-project virtual environment instead.</html>", null, (int)1, null));
        Object $receiver = object;
        final JBLabel permWarning = object;
        object = new Runnable(){

            @Override
            public final void run() {
                Sdk sdk = sdkComboBox.getSelectedSdk();
                permWarning.setVisible(sdk != null ? PySdkExtKt.adminPermissionsNeeded(sdk) : false);
            }
        };
        $receiver = (Runnable)object;
        $receiver.run();
        this.addChangeListener((Runnable)$receiver);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent("Interpreter:", (JComponent)((Object)this.sdkComboBox)).addComponentToRightColumn((JComponent)permWarning);
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026oRightColumn(permWarning)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
    }
}

